/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox;

import ij.ImagePlus;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;
import org.imagearchive.lsm.toolbox.info.scaninfo.DataType;
import org.imagearchive.lsm.toolbox.info.scaninfo.Recording;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomXmlExporter {
    private Document doc;
    private static String comment = "Created with LSM_Toolbox v" + MasterModel.VERSION + " (C) Patrick Pirrotte 2008";

    public String getXML(String filename, boolean filter) {
        Reader reader = ServiceMediator.getReader();
        ImagePlus imp = reader.open(filename, false);
        reader.updateMetadata(imp);
        LSMFileInfo lsm = (LSMFileInfo)imp.getOriginalFileInfo();
        ImageDirectory imDir = (ImageDirectory)lsm.imageDirectories.get(0);
        CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)imDir.TIF_CZ_LSMINFO);
        return this.buildTree(cz, filter);
    }

    public String buildTree(CZLSMInfoExtended cz, boolean filter) {
        try {
            ArrayList<Recording> recordings = cz.scanInfo.recordings;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.doc.appendChild(this.doc.createComment(comment));
            Element root = this.doc.createElement("org.imagearchive.lsm.toolbox");
            Element child = this.doc.createElement("CarlZeiss");
            this.addNode(child, "DimensionX", DataType.LONG, cz.DimensionX);
            this.addNode(child, "DimensionY", DataType.LONG, cz.DimensionY);
            this.addNode(child, "DimensionZ", DataType.LONG, cz.DimensionZ);
            this.addNode(child, "DimensionChannels", DataType.LONG, cz.DimensionChannels);
            this.addNode(child, "DimensionTime", DataType.LONG, cz.DimensionTime);
            this.addNode(child, "IntensityDataType", DataType.LONG, cz.IntensityDataType);
            this.addNode(child, "ThumbnailX", DataType.LONG, cz.ThumbnailX);
            this.addNode(child, "ThumbnailY", DataType.LONG, cz.ThumbnailY);
            this.addNode(child, "VoxelSizeX", DataType.DOUBLE, cz.VoxelSizeX);
            this.addNode(child, "VoxelSizeY", DataType.DOUBLE, cz.VoxelSizeY);
            this.addNode(child, "VoxelSizeZ", DataType.DOUBLE, cz.VoxelSizeZ);
            this.addNode(child, "OriginX", DataType.DOUBLE, cz.OriginX);
            this.addNode(child, "OriginY", DataType.DOUBLE, cz.OriginY);
            this.addNode(child, "OriginZ", DataType.DOUBLE, cz.OriginZ);
            this.addNode(child, "ScanType", DataType.INTEGER, cz.OriginZ);
            this.addNode(child, "SpectralScan", DataType.INTEGER, cz.SpectralScan);
            this.addNode(child, "DataType", DataType.LONG, cz.DataType);
            this.addNode(child, "TimeIntervall", DataType.DOUBLE, cz.TimeIntervall);
            this.addNode(child, "DisplayAspectX", DataType.DOUBLE, cz.DisplayAspectX);
            this.addNode(child, "DisplayAspectY", DataType.DOUBLE, cz.DisplayAspectY);
            this.addNode(child, "DisplayAspectZ", DataType.DOUBLE, cz.DisplayAspectZ);
            this.addNode(child, "DisplayAspectTime", DataType.DOUBLE, cz.DisplayAspectTime);
            this.addNode(child, "ToolbarFlags", DataType.DOUBLE, cz.OriginZ);
            root.appendChild(child);
            for (int i = 0; i < recordings.size(); ++i) {
                int j;
                Recording recording = recordings.get(i);
                Element rec = this.doc.createElement("Recording");
                rec = this.populateNode(rec, Recording.data, recording.records);
                if (recording.lasers != null) {
                    Element las = this.doc.createElement("Lasers");
                    for (j = 0; j < recording.lasers.length; ++j) {
                        LinkedHashMap<String, Object> records;
                        LinkedHashMap<String, Object> m = records = recording.lasers[j].records;
                        Object o = m.get("LASER_ACQUIRE");
                        if (filter && o != null && !(o != null & o.toString().equals("-1"))) continue;
                        Element lasNode = this.doc.createElement("Laser");
                        lasNode = this.populateNode(lasNode, recording.lasers[j].data, records);
                        las.appendChild(lasNode);
                    }
                    rec.appendChild(las);
                }
                if (recording.tracks != null) {
                    Element tra = this.doc.createElement("Tracks");
                    for (j = 0; j < recording.tracks.length; ++j) {
                        Object o;
                        LinkedHashMap<String, Object> m;
                        int k;
                        Element traNode = this.doc.createElement("Track");
                        traNode = this.populateNode(traNode, recording.tracks[j].data, recording.tracks[j].records);
                        if (recording.tracks[j].detectionChannels != null && recording.tracks[j].detectionChannels.length > 0) {
                            Element cha = this.doc.createElement("DetectionChannels");
                            for (k = 0; k < recording.tracks[j].detectionChannels.length; ++k) {
                                m = recording.tracks[j].detectionChannels[k].records;
                                o = m.get("ACQUIRE");
                                if (filter && o != null && !(o != null & o.toString().equals("-1"))) continue;
                                Element chaNode = this.doc.createElement("DetectionChannel");
                                chaNode = this.populateNode(chaNode, recording.tracks[j].detectionChannels[k].data, recording.tracks[j].detectionChannels[k].records);
                                cha.appendChild(chaNode);
                            }
                            traNode.appendChild(cha);
                        }
                        if (recording.tracks[j].illuminationChannels != null && recording.tracks[j].illuminationChannels.length > 0) {
                            Element ill = this.doc.createElement("IlluminationChannels");
                            for (k = 0; k < recording.tracks[j].illuminationChannels.length; ++k) {
                                m = recording.tracks[j].illuminationChannels[k].records;
                                o = m.get("ACQUIRE");
                                if (filter && o != null && !(o != null & o.toString().equals("-1"))) continue;
                                Element illNode = this.doc.createElement("IlluminationChannel");
                                illNode = this.populateNode(illNode, recording.tracks[j].illuminationChannels[k].data, recording.tracks[j].illuminationChannels[k].records);
                                ill.appendChild(illNode);
                            }
                            traNode.appendChild(ill);
                        }
                        if (recording.tracks[j].beamSplitters != null && recording.tracks[j].beamSplitters.length > 0) {
                            Element bsp = this.doc.createElement("BeamSplitters");
                            for (k = 0; k < recording.tracks[j].beamSplitters.length; ++k) {
                                Element bspNode = this.doc.createElement("BeamSplitter");
                                bspNode = this.populateNode(bspNode, recording.tracks[j].beamSplitters[k].data, recording.tracks[j].beamSplitters[k].records);
                                bsp.appendChild(bspNode);
                            }
                            traNode.appendChild(bsp);
                        }
                        if (recording.tracks[j].dataChannels != null && recording.tracks[j].dataChannels.length > 0) {
                            Element dch = this.doc.createElement("DataChannels");
                            for (k = 0; k < recording.tracks[j].dataChannels.length; ++k) {
                                m = recording.tracks[j].dataChannels[k].records;
                                o = m.get("ACQUIRE");
                                if (filter && o != null && !(o != null & o.toString().equals("-1"))) continue;
                                Element dchNode = this.doc.createElement("DataChannel");
                                dchNode = this.populateNode(dchNode, recording.tracks[j].dataChannels[k].data, recording.tracks[j].dataChannels[k].records);
                                dch.appendChild(dchNode);
                            }
                            traNode.appendChild(dch);
                        }
                        if (!traNode.hasChildNodes()) continue;
                        tra.appendChild(traNode);
                    }
                    rec.appendChild(tra);
                }
                if (recording.markers != null) {
                    Element mar = this.doc.createElement("Markers");
                    for (j = 0; j < recording.markers.length; ++j) {
                        Element marNode = this.doc.createElement("Marker");
                        marNode = this.populateNode(marNode, recording.markers[j].data, recording.markers[j].records);
                        mar.appendChild(marNode);
                    }
                    rec.appendChild(mar);
                }
                if (recording.timers != null) {
                    Element tim = this.doc.createElement("Timers");
                    for (j = 0; j < recording.timers.length; ++j) {
                        Element timNode = this.doc.createElement("Timer");
                        timNode = this.populateNode(timNode, recording.markers[j].data, recording.markers[j].records);
                        tim.appendChild(timNode);
                    }
                    rec.appendChild(tim);
                }
                root.appendChild(rec);
            }
            this.doc.appendChild(root);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Element populateNode(Element pNode, Object[][] data, LinkedHashMap<String, Object> records) {
        for (int i = 0; i < data.length; ++i) {
            Object o = records.get(data[i][2]);
            if (o == null) continue;
            String s = "";
            if ((Enum)data[i][1] == DataType.STRING) {
                s = o.toString();
            }
            if ((Enum)data[i][1] == DataType.INTEGER) {
                s = Integer.toString((Integer)o);
            }
            if ((Enum)data[i][1] == DataType.LONG) {
                s = Long.toString((Long)o);
            }
            if ((Enum)data[i][1] == DataType.DOUBLE) {
                s = Double.toString((Double)o);
            }
            String id = Long.toString((Long)data[i][0]);
            Element node = this.doc.createElement((String)data[i][2]);
            node.setAttribute("id", id);
            node.setAttribute("type", ((Enum)data[i][1]).toString());
            node.appendChild(this.doc.createTextNode(s));
            pNode.appendChild(node);
        }
        return pNode;
    }

    private Element addNode(Element pNode, String name, Enum e, Object value) {
        Element node = this.doc.createElement(name);
        node.setAttribute("type", e.toString());
        node.appendChild(this.doc.createTextNode(value.toString()));
        pNode.appendChild(node);
        return pNode;
    }

    private String getDataType(Enum e) {
        return e.toString();
    }
}

