/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.logging.Level;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent2DRetained;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.NioImageBuffer;
import org.jogamp.java3d.NodeComponent;

public class ImageComponent2D
extends ImageComponent {
    ImageComponent2D() {
    }

    public ImageComponent2D(int format, int width, int height) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(format, width, height, 1);
    }

    public ImageComponent2D(int format, BufferedImage image) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(format, image.getWidth(), image.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public ImageComponent2D(int format, RenderedImage image) {
        if (MasterControl.isDevLoggable(Level.FINER)) {
            MasterControl.getDevLogger().finer("ImageComponent - using default of byCopy");
        }
        ((ImageComponent2DRetained)this.retained).processParams(format, image.getWidth(), image.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public ImageComponent2D(int format, int width, int height, boolean byReference, boolean yUp) {
        if (MasterControl.isDevLoggable(Level.INFO) && byReference && !yUp) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent2DRetained)this.retained).processParams(format, width, height, 1);
    }

    public ImageComponent2D(int format, BufferedImage image, boolean byReference, boolean yUp) {
        if (MasterControl.isDevLoggable(Level.INFO) && byReference && !yUp) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent2DRetained)this.retained).processParams(format, image.getWidth(), image.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public ImageComponent2D(int format, RenderedImage image, boolean byReference, boolean yUp) {
        if (MasterControl.isDevLoggable(Level.INFO) && byReference && !yUp) {
            MasterControl.getDevLogger().info("ImageComponent - yUp should be set when using byReference, otherwise an extra copy of the image will be created");
        }
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent2DRetained)this.retained).processParams(format, image.getWidth(), image.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public ImageComponent2D(int format, NioImageBuffer image, boolean byReference, boolean yUp) {
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent2DRetained)this.retained).processParams(format, image.getWidth(), image.getHeight(), 1);
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public void set(BufferedImage image) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public void set(RenderedImage image) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public void set(NioImageBuffer image) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        ((ImageComponent2DRetained)this.retained).set(image);
    }

    public BufferedImage getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        RenderedImage img = ((ImageComponent2DRetained)this.retained).getImage();
        if (img != null && !(img instanceof BufferedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D5"));
        }
        return (BufferedImage)img;
    }

    public RenderedImage getRenderedImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        return ((ImageComponent2DRetained)this.retained).getImage();
    }

    public NioImageBuffer getNioImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D0"));
        }
        return ((ImageComponent2DRetained)this.retained).getNioImage();
    }

    public void setSubImage(RenderedImage image, int width, int height, int srcX, int srcY, int dstX, int dstY) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        if (((ImageComponent2DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D4"));
        }
        int w = ((ImageComponent2DRetained)this.retained).getWidth();
        int h = ((ImageComponent2DRetained)this.retained).getHeight();
        if (srcX < 0 || srcY < 0 || srcX + width > image.getWidth() || srcY + height > image.getHeight() || dstX < 0 || dstY < 0 || dstX + width > w || dstY + height > h) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D3"));
        }
        ((ImageComponent2DRetained)this.retained).setSubImage(image, width, height, srcX, srcY, dstX, dstY);
    }

    public void updateData(Updater updater, int x, int y, int width, int height) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent2D1"));
        }
        if (!((ImageComponent2DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D2"));
        }
        int w = ((ImageComponent2DRetained)this.retained).getWidth();
        int h = ((ImageComponent2DRetained)this.retained).getHeight();
        if (x < 0 || y < 0 || x + width > w || y + height > h) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent2D3"));
        }
        ((ImageComponent2DRetained)this.retained).updateData(updater, x, y, width, height);
    }

    @Override
    void createRetained() {
        this.retained = new ImageComponent2DRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        ImageComponent2DRetained rt = (ImageComponent2DRetained)this.retained;
        ImageComponent2D img = new ImageComponent2D(rt.getFormat(), rt.width, rt.height, rt.byReference, rt.yUp);
        img.duplicateNodeComponent(this);
        return img;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        ImageComponent.ImageClass imageClass = ((ImageComponentRetained)originalNodeComponent.retained).getImageClass();
        if (imageClass == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            NioImageBuffer nioImg = ((ImageComponent2DRetained)originalNodeComponent.retained).getNioImage();
            if (nioImg != null) {
                ((ImageComponent2DRetained)this.retained).set(nioImg);
            }
        } else {
            RenderedImage img = ((ImageComponent2DRetained)originalNodeComponent.retained).getImage();
            if (img != null) {
                ((ImageComponent2DRetained)this.retained).set(img);
            }
        }
    }

    public static interface Updater {
        public void updateData(ImageComponent2D var1, int var2, int var3, int var4, int var5);
    }
}

