/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;

class RenderingAttributesRetained
extends NodeComponentRetained {
    static final int DEPTH_ENABLE = 1;
    static final int DEPTH_WRITE_ENABLE = 2;
    static final int ALPHA_TEST_VALUE = 4;
    static final int ALPHA_TEST_FUNC = 8;
    static final int VISIBLE = 16;
    static final int IGNORE_VCOLOR = 32;
    static final int RASTER_OP_ENABLE = 64;
    static final int RASTER_OP_VALUE = 128;
    static final int DEPTH_TEST_FUNC = 256;
    static final int STENCIL_ENABLE = 512;
    static final int STENCIL_OP_VALUES = 1024;
    static final int STENCIL_FUNC = 2048;
    static final int STENCIL_WRITE_MASK = 4096;
    boolean depthBufferEnable = true;
    boolean depthBufferWriteEnable = true;
    float alphaTestValue = 0.0f;
    int alphaTestFunction = 0;
    int depthTestFunction = 5;
    boolean visible = true;
    boolean ignoreVertexColors = false;
    boolean rasterOpEnable = false;
    int rasterOp = 3;
    boolean stencilEnable = false;
    int stencilFailOp = 1;
    int stencilZFailOp = 1;
    int stencilZPassOp = 1;
    int stencilFunction = 0;
    int stencilReferenceValue = 0;
    int stencilCompareMask = -1;
    int stencilWriteMask = -1;
    static final int LESS = 0;
    static final int LEQUAL = 1;

    RenderingAttributesRetained() {
    }

    final void initVisible(boolean state) {
        this.visible = state;
    }

    final void setVisible(boolean state) {
        this.initVisible(state);
        this.sendMessage(16, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getVisible() {
        return this.visible;
    }

    final void initIgnoreVertexColors(boolean state) {
        this.ignoreVertexColors = state;
    }

    final void setIgnoreVertexColors(boolean state) {
        this.initIgnoreVertexColors(state);
        this.sendMessage(32, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getIgnoreVertexColors() {
        return this.ignoreVertexColors;
    }

    final void initDepthBufferEnable(boolean state) {
        this.depthBufferEnable = state;
    }

    final void setDepthBufferEnable(boolean state) {
        this.initDepthBufferEnable(state);
        this.sendMessage(1, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferEnable() {
        return this.depthBufferEnable;
    }

    final void initDepthBufferWriteEnable(boolean state) {
        this.depthBufferWriteEnable = state;
    }

    final void setDepthBufferWriteEnable(boolean state) {
        this.initDepthBufferWriteEnable(state);
        this.sendMessage(2, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getDepthBufferWriteEnable() {
        return this.depthBufferWriteEnable;
    }

    final void initAlphaTestValue(float value) {
        this.alphaTestValue = value;
    }

    final void setAlphaTestValue(float value) {
        this.initAlphaTestValue(value);
        this.sendMessage(4, new Float(value));
    }

    final float getAlphaTestValue() {
        return this.alphaTestValue;
    }

    final void initAlphaTestFunction(int function) {
        this.alphaTestFunction = function;
    }

    final void setAlphaTestFunction(int function) {
        this.initAlphaTestFunction(function);
        this.sendMessage(8, new Integer(function));
    }

    final int getAlphaTestFunction() {
        return this.alphaTestFunction;
    }

    final void initDepthTestFunction(int function) {
        this.depthTestFunction = function;
    }

    final void setDepthTestFunction(int function) {
        this.initDepthTestFunction(function);
        this.sendMessage(256, new Integer(function));
    }

    final int getDepthTestFunction() {
        return this.depthTestFunction;
    }

    final void initRasterOpEnable(boolean flag) {
        this.rasterOpEnable = flag;
    }

    final void setRasterOpEnable(boolean flag) {
        this.initRasterOpEnable(flag);
        this.sendMessage(64, new Boolean(flag));
    }

    final boolean getRasterOpEnable() {
        return this.rasterOpEnable;
    }

    final void initRasterOp(int op) {
        this.rasterOp = op;
    }

    final void setRasterOp(int op) {
        this.initRasterOp(op);
        this.sendMessage(128, new Integer(op));
    }

    final int getRasterOp() {
        return this.rasterOp;
    }

    final void initStencilEnable(boolean state) {
        this.stencilEnable = state;
    }

    final void setStencilEnable(boolean state) {
        this.initStencilEnable(state);
        this.sendMessage(512, new Boolean(state));
    }

    final boolean getStencilEnable() {
        return this.stencilEnable;
    }

    final void initStencilOp(int failOp, int zFailOp, int zPassOp) {
        this.stencilFailOp = failOp;
        this.stencilZFailOp = zFailOp;
        this.stencilZPassOp = zPassOp;
    }

    final void setStencilOp(int failOp, int zFailOp, int zPassOp) {
        this.initStencilOp(failOp, zFailOp, zPassOp);
        ArrayList<Integer> arrList = new ArrayList<Integer>(3);
        arrList.add(new Integer(failOp));
        arrList.add(new Integer(zFailOp));
        arrList.add(new Integer(zPassOp));
        this.sendMessage(1024, arrList);
    }

    final void getStencilOp(int[] stencilOps) {
        stencilOps[0] = this.stencilFailOp;
        stencilOps[1] = this.stencilZFailOp;
        stencilOps[2] = this.stencilZPassOp;
    }

    final void initStencilFunction(int function, int refValue, int compareMask) {
        this.stencilFunction = function;
        this.stencilReferenceValue = refValue;
        this.stencilCompareMask = compareMask;
    }

    final void setStencilFunction(int function, int refValue, int compareMask) {
        this.initStencilOp(function, refValue, compareMask);
        ArrayList<Integer> arrList = new ArrayList<Integer>(3);
        arrList.add(new Integer(function));
        arrList.add(new Integer(refValue));
        arrList.add(new Integer(compareMask));
        this.sendMessage(2048, arrList);
    }

    final void getStencilFunction(int[] params) {
        params[0] = this.stencilFunction;
        params[1] = this.stencilReferenceValue;
        params[2] = this.stencilCompareMask;
    }

    final void initStencilWriteMask(int mask) {
        this.stencilWriteMask = mask;
    }

    final void setStencilWriteMask(int mask) {
        this.initStencilWriteMask(mask);
        this.sendMessage(4096, new Integer(mask));
    }

    final int getStencilWriteMask() {
        return this.stencilWriteMask;
    }

    void updateNative(Canvas3D c3d, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride) {
        Pipeline.getPipeline().updateRenderingAttributes(c3d.ctx, depthBufferWriteEnableOverride, depthBufferEnableOverride, this.depthBufferEnable, this.depthBufferWriteEnable, this.depthTestFunction, this.alphaTestValue, this.alphaTestFunction, this.ignoreVertexColors, this.rasterOpEnable, this.rasterOp, c3d.userStencilAvailable, this.stencilEnable, this.stencilFailOp, this.stencilZFailOp, this.stencilZPassOp, this.stencilFunction, this.stencilReferenceValue, this.stencilCompareMask, this.stencilWriteMask);
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                RenderingAttributesRetained mirrorRa = new RenderingAttributesRetained();
                mirrorRa.set(this);
                mirrorRa.source = this.source;
                this.mirror = mirrorRa;
            }
        } else {
            ((RenderingAttributesRetained)this.mirror).set(this);
        }
    }

    @Override
    synchronized void initMirrorObject() {
        ((RenderingAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        RenderingAttributesRetained mirrorRa = (RenderingAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorRa.depthBufferEnable = (Boolean)value;
        } else if ((component & 2) != 0) {
            mirrorRa.depthBufferWriteEnable = (Boolean)value;
        } else if ((component & 0x100) != 0) {
            mirrorRa.depthTestFunction = (Integer)value;
        } else if ((component & 4) != 0) {
            mirrorRa.alphaTestValue = ((Float)value).floatValue();
        } else if ((component & 8) != 0) {
            mirrorRa.alphaTestFunction = (Integer)value;
        } else if ((component & 0x10) != 0) {
            mirrorRa.visible = (Boolean)value;
        } else if ((component & 0x20) != 0) {
            mirrorRa.ignoreVertexColors = (Boolean)value;
        } else if ((component & 0x40) != 0) {
            mirrorRa.rasterOpEnable = (Boolean)value;
        } else if ((component & 0x80) != 0) {
            mirrorRa.rasterOp = (Integer)value;
        } else if ((component & 0x200) != 0) {
            mirrorRa.stencilEnable = (Boolean)value;
        } else if ((component & 0x400) != 0) {
            ArrayList arrlist = (ArrayList)value;
            mirrorRa.stencilFailOp = (Integer)arrlist.get(0);
            mirrorRa.stencilZFailOp = (Integer)arrlist.get(1);
            mirrorRa.stencilZPassOp = (Integer)arrlist.get(2);
        } else if ((component & 0x800) != 0) {
            ArrayList arrlist = (ArrayList)value;
            mirrorRa.stencilFunction = (Integer)arrlist.get(0);
            mirrorRa.stencilReferenceValue = (Integer)arrlist.get(1);
            mirrorRa.stencilCompareMask = (Integer)arrlist.get(2);
        } else if ((component & 0x1000) != 0) {
            mirrorRa.stencilWriteMask = (Integer)value;
        }
    }

    boolean equivalent(RenderingAttributesRetained rr) {
        return this == rr || rr != null && rr.depthBufferEnable == this.depthBufferEnable && rr.depthBufferWriteEnable == this.depthBufferWriteEnable && rr.alphaTestValue == this.alphaTestValue && rr.alphaTestFunction == this.alphaTestFunction && rr.visible == this.visible && rr.ignoreVertexColors == this.ignoreVertexColors && rr.rasterOpEnable == this.rasterOpEnable && rr.rasterOp == this.rasterOp && rr.depthTestFunction == this.depthTestFunction && rr.stencilEnable == this.stencilEnable && rr.stencilFailOp == this.stencilFailOp && rr.stencilZFailOp == this.stencilZFailOp && rr.stencilZPassOp == this.stencilZPassOp && rr.stencilFunction == this.stencilFunction && rr.stencilReferenceValue == this.stencilReferenceValue && rr.stencilCompareMask == this.stencilCompareMask && rr.stencilWriteMask == this.stencilWriteMask;
    }

    protected void set(RenderingAttributesRetained ra) {
        super.set(ra);
        this.depthBufferEnable = ra.depthBufferEnable;
        this.depthBufferWriteEnable = ra.depthBufferWriteEnable;
        this.alphaTestValue = ra.alphaTestValue;
        this.alphaTestFunction = ra.alphaTestFunction;
        this.depthTestFunction = ra.depthTestFunction;
        this.visible = ra.visible;
        this.ignoreVertexColors = ra.ignoreVertexColors;
        this.rasterOpEnable = ra.rasterOpEnable;
        this.rasterOp = ra.rasterOp;
        this.stencilEnable = ra.stencilEnable;
        this.stencilFailOp = ra.stencilFailOp;
        this.stencilZFailOp = ra.stencilZFailOp;
        this.stencilZPassOp = ra.stencilZPassOp;
        this.stencilFunction = ra.stencilFunction;
        this.stencilReferenceValue = ra.stencilReferenceValue;
        this.stencilCompareMask = ra.stencilCompareMask;
        this.stencilWriteMask = ra.stencilWriteMask;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 10;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            if (attrMask == 16) {
                createMessage.threads |= 0x40;
            }
            createMessage.type = 10;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if (bit == 1) {
            mask = 4;
        }
        if (bit == 3) {
            mask = 8;
        }
        if (bit == 6) {
            mask = 16;
        }
        if (bit == 10) {
            mask = 32;
        }
        if (bit == 8) {
            mask = 64;
        }
        if (bit == 11) {
            mask = 2;
        }
        if (bit == 13) {
            mask = 256;
        }
        if (bit == 15) {
            mask = 256;
        }
        if (bit == 13) {
            mask = 7680;
        }
        if (mask != 0) {
            this.setFrequencyChangeMask(bit, mask);
        }
    }
}

