/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.J3dClock;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.SoundScheduler;

class SoundSchedulerAtom {
    SoundRetained sound = null;
    MediaContainer soundData = null;
    long startTime = 0L;
    long endTime = 0L;
    long sampleLength = 0L;
    long loopStartOffset = 0L;
    long loopLength = 0L;
    long attackLength = 0L;
    long releaseLength = 0L;
    int loadStatus = 0;
    boolean playing = false;
    int numberChannels = 0;
    boolean activated = false;
    static final int OFF = 0;
    static final int ON = 1;
    static final int PENDING_ON = 2;
    static final int PENDING_OFF = 3;
    int enabled = 0;
    static final int UNMUTED = 0;
    static final int MUTED = 1;
    static final int PENDING_UNMUTE = 2;
    static final int PENDING_MUTE = 3;
    int muted = 0;
    static final int UNPAUSED = 0;
    static final int PAUSED = 1;
    static final int PENDING_UNPAUSE = 2;
    static final int PENDING_PAUSE = 3;
    int paused = 0;
    static final int DO_NOTHING = 0;
    static final int LEAVE_OFF = 1;
    static final int LEAVE_SILENT = 2;
    static final int LEAVE_AUDIBLE = 3;
    static final int LEAVE_PAUSED = 4;
    static final int RESTART_AUDIBLE = 5;
    static final int START_AUDIBLE = 6;
    static final int RESTART_SILENT = 7;
    static final int START_SILENT = 8;
    static final int MAKE_AUDIBLE = 11;
    static final int MAKE_SILENT = 12;
    static final int PAUSE_AUDIBLE = 13;
    static final int PAUSE_SILENT = 14;
    static final int RESUME_AUDIBLE = 15;
    static final int RESUME_SILENT = 16;
    static final int TURN_OFF = 17;
    static final int UPDATE = 18;
    static final int COMPLETE = 19;
    int schedulingAction = 0;
    static final int SOUND_OFF = 0;
    static final int SOUND_AUDIBLE = 1;
    static final int SOUND_SILENT = 2;
    static final int SOUND_PAUSED = 3;
    static final int SOUND_COMPLETE = 4;
    int status = 0;
    int attribsDirty = 0;
    int stateDirty = 0;
    int sampleId = -1;
    SoundScheduler soundScheduler = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundSchedulerAtom() {
    }

    synchronized void calculateEndTime() {
        SoundRetained sgSound = this.sound.sgSound;
        int loops = sgSound.loopCount;
        if (this.sampleLength <= 0L || this.loopLength <= 0L || loops < 0) {
            this.endTime = -1L;
        } else if (this.playing && this.startTime > 0L) {
            this.endTime = this.startTime + this.attackLength + this.loopLength * (long)(loops + 1) + this.releaseLength;
        } else {
            long currentTime = J3dClock.currentTimeMillis();
            this.endTime = currentTime + (this.loopLength - (currentTime - this.startTime - this.attackLength) % this.loopLength + this.releaseLength);
        }
    }

    void enable(boolean enabled) {
        if (enabled) {
            this.setEnableState(2);
        } else {
            this.setEnableState(3);
        }
    }

    void mute(boolean muted) {
        if (muted) {
            this.setMuteState(3);
        } else {
            this.setMuteState(2);
        }
    }

    void pause(boolean paused) {
        if (paused) {
            this.setPauseState(3);
        } else {
            this.setPauseState(2);
        }
    }

    void setEnableState(int state) {
        this.enabled = state;
        switch (state) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                break;
            }
        }
    }

    void setMuteState(int state) {
        this.muted = state;
        switch (state) {
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                break;
            }
        }
    }

    void setPauseState(int state) {
        this.paused = state;
        switch (state) {
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                break;
            }
        }
    }

    synchronized int calcActiveSchedAction() {
        SoundRetained sgSound = this.sound.sgSound;
        int action = 0;
        this.activated = true;
        switch (this.enabled) {
            case 2: {
                this.setEnableState(1);
                if (this.status == 0 || this.status == 3) {
                    action = 6;
                    break;
                }
                action = 5;
                break;
            }
            case 1: {
                if (this.status == 0) {
                    action = 6;
                    break;
                }
                if (this.status == 2) {
                    action = 11;
                    break;
                }
                action = 3;
                break;
            }
            case 3: {
                this.setEnableState(0);
            }
            case 0: {
                if (this.status == 1) {
                    if (sgSound.release) {
                        if (this.enabled == 3) {
                            this.calculateEndTime();
                        }
                        action = 3;
                        break;
                    }
                    action = 17;
                    break;
                }
                if (this.status == 2) {
                    if (sgSound.release) {
                        this.calculateEndTime();
                        action = 11;
                        break;
                    }
                    action = 17;
                    break;
                }
                action = 1;
            }
        }
        if (this.paused == 3) {
            switch (action) {
                case 3: 
                case 11: 
                case 15: {
                    action = 13;
                    break;
                }
                case 2: 
                case 12: 
                case 16: {
                    action = 14;
                    break;
                }
            }
        } else if (this.paused == 2) {
            this.debugPrint("    PENDING_UNPAUSE");
            switch (action) {
                case 3: 
                case 11: 
                case 13: {
                    action = 15;
                    break;
                }
                case 2: 
                case 12: 
                case 14: {
                    action = 16;
                    break;
                }
            }
        }
        return action;
    }

    synchronized int calcInactiveSchedAction() {
        int action = 0;
        SoundRetained sgSound = this.sound.sgSound;
        this.activated = false;
        switch (this.enabled) {
            case 2: {
                this.setEnableState(1);
                if (sgSound.continuous) {
                    if (this.status == 0) {
                        action = 8;
                        break;
                    }
                    action = 7;
                    break;
                }
                if (this.status == 0) {
                    action = 1;
                    break;
                }
                action = 17;
                break;
            }
            case 1: {
                if (sgSound.continuous) {
                    if (this.status == 1) {
                        action = 12;
                        break;
                    }
                    if (this.status == 0) {
                        action = 8;
                        break;
                    }
                    action = 2;
                    break;
                }
                if (this.status == 0) {
                    action = 1;
                    break;
                }
                action = 17;
                break;
            }
            case 3: {
                this.setEnableState(0);
            }
            case 0: {
                if (sgSound.release && sgSound.continuous) {
                    if (this.enabled == 3) {
                        this.calculateEndTime();
                    }
                    if (this.status == 1) {
                        action = 12;
                        break;
                    }
                    if (this.status == 2) {
                        action = 2;
                        break;
                    }
                    action = 1;
                    break;
                }
                if (this.status == 0) {
                    action = 1;
                    break;
                }
                action = 17;
                break;
            }
        }
        if (this.paused == 3) {
            switch (action) {
                case 2: 
                case 12: 
                case 16: {
                    action = 14;
                    break;
                }
            }
        } else if (this.paused == 2) {
            switch (action) {
                case 2: {
                    action = 16;
                    break;
                }
            }
        }
        return action;
    }

    void debugPrint(String message) {
    }

    void setAttribsDirtyFlag(int bitFlag) {
        this.attribsDirty |= bitFlag;
    }

    void setStateDirtyFlag(int bitFlag) {
        this.stateDirty |= bitFlag;
    }

    void clearAttribsDirtyFlag(int bitFlag) {
        this.attribsDirty &= ~bitFlag;
    }

    void clearAttribsDirtyFlag() {
        this.attribsDirty = 0;
    }

    void clearStateDirtyFlag(int bitFlag) {
        this.stateDirty &= ~bitFlag;
    }

    void clearStateDirtyFlag() {
        this.stateDirty = 0;
    }

    boolean testDirtyFlag(int field, int bitFlag) {
        return (field & bitFlag) > 0;
    }

    boolean testDirtyFlags() {
        if ((this.attribsDirty & 0xFFFF) > 0) {
            return true;
        }
        return (this.stateDirty & 0xFFFF) > 0;
    }
}

