/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Move_Roi
implements PlugInFilter {
    private ImagePlus image;
    public static final int COPY = 0;
    public static final int CUT = 1;
    public static final int DEF_PIX_PER_SLICE = 3;
    public static final int DEF_MODE = 0;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public void run(ImageProcessor ip) {
        int current = this.image.getCurrentSlice();
        GenericDialog gd = new GenericDialog("Delete Frame");
        gd.addNumericField("Slice", (double)current, 0);
        gd.addNumericField("Pixels per slice", 3.0, 0);
        String[] modeSt = new String[]{"Copy", "Cut"};
        gd.addChoice("Mode", modeSt, modeSt[0]);
        gd.addNumericField("dx", 0.0, 0);
        gd.addNumericField("dy", 0.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int slice = (int)gd.getNextNumber();
        int speed = (int)gd.getNextNumber();
        int dx = (int)gd.getNextNumber();
        int dy = (int)gd.getNextNumber();
        int mode = gd.getNextChoiceIndex();
        Move_Roi.moveRoi(this.image, this.image.getRoi(), dx, dy, slice, speed, mode);
    }

    public static void moveRoi(ImagePlus image, Roi roi, int dx, int dy, int slice, int speed, int mode) {
        if (roi == null) {
            IJ.error((String)"Roi required");
            return;
        }
        ImageStack stack = image.getStack();
        Rectangle r = roi.getBounds();
        int dt = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        ImageProcessor ip = stack.getProcessor(slice).duplicate();
        ip.setRoi(roi);
        ImageProcessor copy = ip.crop();
        if (mode == 1) {
            ip.setRoi(roi);
            ip.setValue(0.0);
            ip.fill();
        }
        ImageProcessor ip2 = null;
        int inserted = 0;
        for (int i = 0; i < dt; ++i) {
            int xt = r.x + Math.round((float)i * (float)dx / (float)dt);
            int yt = r.y + Math.round((float)i * (float)dy / (float)dt);
            ip2 = ip.duplicate();
            ip2.copyBits(copy, xt, yt, 14);
            if (speed < 1 || i % speed != 0) continue;
            stack.addSlice("", ip2, slice + inserted);
            ++inserted;
        }
        if (speed < 1 || dt % speed != 0) {
            stack.addSlice("", ip2, slice + inserted);
        }
    }
}

