/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Color;
import org.scijava.util.ColorRGB;
import org.scijava.util.ColorRGBA;

public final class AWTColors {
    private AWTColors() {
    }

    public static Color getColor(ColorRGB c) {
        if (c == null) {
            return null;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static Color getColor(ColorRGB c, int alpha) {
        if (c == null) {
            return null;
        }
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha value of " + alpha + " is out of range (0-255)");
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static ColorRGB getColorRGB(Color color) {
        if (color == null) {
            return null;
        }
        return new ColorRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static ColorRGBA getColorRGBA(Color color) {
        if (color == null) {
            return null;
        }
        return new ColorRGBA(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

