/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.scijava.module.Module;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.ui.AbstractInputHarvesterPlugin;
import org.scijava.ui.awt.widget.AWTInputPanel;
import org.scijava.widget.InputPanel;

@Plugin(type=PreprocessorPlugin.class, priority=-10000.0)
public class AWTInputHarvester
extends AbstractInputHarvesterPlugin<Panel, Panel> {
    public AWTInputPanel createInputPanel() {
        return new AWTInputPanel();
    }

    public boolean harvestInputs(InputPanel<Panel, Panel> inputPanel, Module module) {
        Panel pane = (Panel)inputPanel.getComponent();
        String title = module.getInfo().getTitle();
        boolean allowCancel = module.getInfo().canCancel();
        int optionType = allowCancel ? 2 : -1;
        int messageType = inputPanel.isMessageOnly() ? (allowCancel ? 3 : 1) : -1;
        JOptionPane optionPane = new JOptionPane(pane, messageType, optionType);
        JDialog dialog = optionPane.createDialog(title);
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.pack();
        this.ensureDialogSizeReasonable(dialog);
        dialog.setVisible(true);
        Integer rval = (Integer)optionPane.getValue();
        dialog.dispose();
        return rval != null && rval == 0;
    }

    protected String getUI() {
        return "awt";
    }

    private void ensureDialogSizeReasonable(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        int newWidth = dialogSize.width;
        int newHeight = dialogSize.height;
        int maxWidth = 3 * screenSize.width / 4;
        int maxHeight = 3 * screenSize.height / 4;
        if (newWidth > maxWidth) {
            newWidth = maxWidth;
        }
        if (newHeight > maxHeight) {
            newHeight = maxHeight;
        }
        dialog.setSize(newWidth, newHeight);
    }
}

