/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.widget.AWTInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.NumberWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class AWTNumberWidget
extends AWTInputWidget<Number>
implements NumberWidget<Panel>,
AdjustmentListener,
TextListener {
    private Scrollbar scrollBar;
    private TextField textField;

    public Number getValue() {
        return this.scrollBar.getValue();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        Number min = model.getMin();
        Number max = model.getMax();
        Number stepSize = model.getStepSize();
        this.scrollBar = new Scrollbar(0, min.intValue(), 1, min.intValue(), max.intValue() + 1);
        this.scrollBar.setUnitIncrement(stepSize.intValue());
        this.scrollBar.addAdjustmentListener(this);
        this.getComponent().add((Component)this.scrollBar, "Center");
        this.textField = new TextField(6);
        this.textField.addTextListener(this);
        this.getComponent().add((Component)this.textField, "East");
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isNumber();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.textField.setText("" + this.scrollBar.getValue());
    }

    @Override
    public void textValueChanged(TextEvent e) {
        try {
            this.scrollBar.setValue(Integer.parseInt(this.textField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void doRefresh() {
        String value = this.get().getValue().toString();
        if (this.textField.getText().equals(value)) {
            return;
        }
        this.textField.setText(value);
    }
}

