/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;

public class Bearing {
    private static final Earth defaultEarth = EarthEllipsoid.WGS84;
    private static final double EPS = 5.0E-14;
    private static final double DEGREES_TO_RADIANS = Math.toRadians(1.0);
    private static final double RADIANS_TO_DEGREES = Math.toDegrees(1.0);
    private double azimuth;
    private double backazimuth;
    private double distance;

    @Deprecated
    public static Bearing calculateBearing(Earth e, LatLonPoint pt1, LatLonPoint pt2, Bearing result) {
        return Bearing.calculateBearing(e, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude(), result);
    }

    public static Bearing calculateBearing(Earth e, LatLonPoint pt1, LatLonPoint pt2) {
        return Bearing.calculateBearing(e, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude());
    }

    @Deprecated
    public static Bearing calculateBearing(LatLonPoint pt1, LatLonPoint pt2, Bearing result) {
        return Bearing.calculateBearing(defaultEarth, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude(), result);
    }

    public static Bearing calculateBearing(LatLonPoint pt1, LatLonPoint pt2) {
        return Bearing.calculateBearing(defaultEarth, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude());
    }

    @Deprecated
    public static Bearing calculateBearing(double lat1, double lon1, double lat2, double lon2, Bearing result) {
        return Bearing.calculateBearing(defaultEarth, lat1, lon1, lat2, lon2, result);
    }

    public static Bearing calculateBearing(double lat1, double lon1, double lat2, double lon2) {
        return Bearing.calculateBearing(defaultEarth, lat1, lon1, lat2, lon2);
    }

    @Deprecated
    public static Bearing calculateBearing(Earth e, double lat1, double lon1, double lat2, double lon2, Bearing result) {
        double E;
        double CZ;
        double C2A;
        double Y;
        double CY;
        double SY;
        double CX;
        double SX;
        double C;
        double D;
        if (result == null) {
            result = new Bearing();
        }
        if (lat1 == lat2 && lon1 == lon2) {
            result.distance = 0.0;
            result.azimuth = 0.0;
            result.backazimuth = 0.0;
            return result;
        }
        double A = e.getMajor();
        double F = e.getFlattening();
        double R = 1.0 - F;
        double GLAT1 = DEGREES_TO_RADIANS * lat1;
        double GLAT2 = DEGREES_TO_RADIANS * lat2;
        double TU1 = R * Math.sin(GLAT1) / Math.cos(GLAT1);
        double TU2 = R * Math.sin(GLAT2) / Math.cos(GLAT2);
        double CU1 = 1.0 / Math.sqrt(TU1 * TU1 + 1.0);
        double SU1 = CU1 * TU1;
        double CU2 = 1.0 / Math.sqrt(TU2 * TU2 + 1.0);
        double S = CU1 * CU2;
        double BAZ = S * TU2;
        double FAZ = BAZ * TU1;
        double GLON1 = DEGREES_TO_RADIANS * lon1;
        double GLON2 = DEGREES_TO_RADIANS * lon2;
        double X = GLON2 - GLON1;
        int loopCnt = 0;
        do {
            if (++loopCnt > 1000) {
                throw new IllegalArgumentException("Too many iterations calculating bearing:" + lat1 + " " + lon1 + " " + lat2 + " " + lon2);
            }
            SX = Math.sin(X);
            CX = Math.cos(X);
            TU1 = CU2 * SX;
            TU2 = BAZ - SU1 * CU2 * CX;
            SY = Math.sqrt(TU1 * TU1 + TU2 * TU2);
            CY = S * CX + FAZ;
            Y = Math.atan2(SY, CY);
            double SA = S * SX / SY;
            C2A = -SA * SA + 1.0;
            CZ = FAZ + FAZ;
            if (C2A > 0.0) {
                CZ = -CZ / C2A + CY;
            }
            E = CZ * CZ * 2.0 - 1.0;
            C = ((-3.0 * C2A + 4.0) * F + 4.0) * C2A * F / 16.0;
            D = X;
            X = ((E * CY * C + CZ) * SY * C + Y) * SA;
        } while (Math.abs(D - (X = (1.0 - C) * X * F + GLON2 - GLON1)) > 5.0E-14);
        FAZ = Math.atan2(TU1, TU2);
        BAZ = Math.atan2(CU1 * SX, BAZ * CX - SU1 * CU2) + Math.PI;
        X = Math.sqrt((1.0 / R / R - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        D = (0.375 * X * X - 1.0) * X;
        X = E * CY;
        S = 1.0 - E - E;
        S = ((((SY * SY * 4.0 - 3.0) * S * CZ * D / 6.0 - X) * D / 4.0 + CZ) * SY * D + Y) * C * A * R;
        result.distance = S / 1000.0;
        result.azimuth = FAZ * RADIANS_TO_DEGREES;
        if (result.azimuth < 0.0) {
            result.azimuth += 360.0;
        }
        result.backazimuth = BAZ * RADIANS_TO_DEGREES;
        return result;
    }

    public static LatLonPointImpl findPoint(Earth e, LatLonPoint pt1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(e, pt1.getLatitude(), pt1.getLongitude(), az, dist, result);
    }

    public static LatLonPointImpl findPoint(LatLonPoint pt1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(defaultEarth, pt1.getLatitude(), pt1.getLongitude(), az, dist, result);
    }

    public static LatLonPointImpl findPoint(double lat1, double lon1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(defaultEarth, lat1, lon1, az, dist, result);
    }

    @Deprecated
    public static LatLonPointImpl findPoint(Earth e, double lat1, double lon1, double az, double dist, LatLonPointImpl result) {
        LatLonPoint pt = Bearing.findPoint(e, lat1, lon1, az, dist);
        if (result == null) {
            result = new LatLonPointImpl();
        }
        result.setLatitude(pt.getLatitude());
        result.setLongitude(pt.getLongitude());
        return result;
    }

    public static LatLonPoint findPoint(Earth e, double lat1, double lon1, double az, double dist) {
        double E;
        double CY;
        double CZ;
        double SY;
        if (dist == 0.0) {
            return LatLonPoint.create(lat1, lon1);
        }
        double A = e.getMajor();
        double F = e.getFlattening();
        double R = 1.0 - F;
        if (az < 0.0) {
            az += 360.0;
        }
        double FAZ = az * DEGREES_TO_RADIANS;
        double GLAT1 = lat1 * DEGREES_TO_RADIANS;
        double GLON1 = lon1 * DEGREES_TO_RADIANS;
        double S = dist * 1000.0;
        double TU = R * Math.sin(GLAT1) / Math.cos(GLAT1);
        double SF = Math.sin(FAZ);
        double CF2 = Math.cos(FAZ);
        double BAZ = 0.0;
        if (CF2 != 0.0) {
            BAZ = Math.atan2(TU, CF2) * 2.0;
        }
        double CU = 1.0 / Math.sqrt(TU * TU + 1.0);
        double SU = TU * CU;
        double SA = CU * SF;
        double C2A = -SA * SA + 1.0;
        double X = Math.sqrt((1.0 / R / R - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        double C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        double D = (0.375 * X * X - 1.0) * X;
        double Y = TU = S / R / A / C;
        do {
            SY = Math.sin(Y);
            CY = Math.cos(Y);
            CZ = Math.cos(BAZ + Y);
            E = CZ * CZ * 2.0 - 1.0;
            C = Y;
            X = E * CY;
            Y = E + E - 1.0;
        } while (Math.abs((Y = (((SY * SY * 4.0 - 3.0) * Y * CZ * D / 6.0 + X) * D / 4.0 - CZ) * SY * D + TU) - C) > 5.0E-14);
        BAZ = CU * CY * CF2 - SU * SY;
        C = R * Math.sqrt(SA * SA + BAZ * BAZ);
        D = SU * CY + CU * SY * CF2;
        double GLAT2 = Math.atan2(D, C);
        C = CU * CY - SU * SY * CF2;
        X = Math.atan2(SY * SF, C);
        C = ((-3.0 * C2A + 4.0) * F + 4.0) * C2A * F / 16.0;
        D = ((E * CY * C + CZ) * SY * C + Y) * SA;
        double GLON2 = GLON1 + X - (1.0 - C) * D * F;
        return LatLonPoint.create(GLAT2 * RADIANS_TO_DEGREES, GLON2 * RADIANS_TO_DEGREES);
    }

    public static Bearing calculateBearing(Earth e, double lat1, double lon1, double lat2, double lon2) {
        double E;
        double CZ;
        double C2A;
        double Y;
        double CY;
        double SY;
        double CX;
        double SX;
        double C;
        double D;
        if (lat1 == lat2 && lon1 == lon2) {
            return new Bearing(0.0, 0.0, 0.0);
        }
        double A = e.getMajor();
        double F = e.getFlattening();
        double R = 1.0 - F;
        double GLAT1 = DEGREES_TO_RADIANS * lat1;
        double GLAT2 = DEGREES_TO_RADIANS * lat2;
        double TU1 = R * Math.sin(GLAT1) / Math.cos(GLAT1);
        double TU2 = R * Math.sin(GLAT2) / Math.cos(GLAT2);
        double CU1 = 1.0 / Math.sqrt(TU1 * TU1 + 1.0);
        double SU1 = CU1 * TU1;
        double CU2 = 1.0 / Math.sqrt(TU2 * TU2 + 1.0);
        double S = CU1 * CU2;
        double BAZ = S * TU2;
        double FAZ = BAZ * TU1;
        double GLON1 = DEGREES_TO_RADIANS * lon1;
        double GLON2 = DEGREES_TO_RADIANS * lon2;
        double X = GLON2 - GLON1;
        int loopCnt = 0;
        do {
            if (++loopCnt > 1000) {
                throw new IllegalArgumentException("Too many iterations calculating bearing:" + lat1 + " " + lon1 + " " + lat2 + " " + lon2);
            }
            SX = Math.sin(X);
            CX = Math.cos(X);
            TU1 = CU2 * SX;
            TU2 = BAZ - SU1 * CU2 * CX;
            SY = Math.sqrt(TU1 * TU1 + TU2 * TU2);
            CY = S * CX + FAZ;
            Y = Math.atan2(SY, CY);
            double SA = S * SX / SY;
            C2A = -SA * SA + 1.0;
            CZ = FAZ + FAZ;
            if (C2A > 0.0) {
                CZ = -CZ / C2A + CY;
            }
            E = CZ * CZ * 2.0 - 1.0;
            C = ((-3.0 * C2A + 4.0) * F + 4.0) * C2A * F / 16.0;
            D = X;
            X = ((E * CY * C + CZ) * SY * C + Y) * SA;
        } while (Math.abs(D - (X = (1.0 - C) * X * F + GLON2 - GLON1)) > 5.0E-14);
        FAZ = Math.atan2(TU1, TU2);
        BAZ = Math.atan2(CU1 * SX, BAZ * CX - SU1 * CU2) + Math.PI;
        X = Math.sqrt((1.0 / R / R - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        D = (0.375 * X * X - 1.0) * X;
        X = E * CY;
        S = 1.0 - E - E;
        S = ((((SY * SY * 4.0 - 3.0) * S * CZ * D / 6.0 - X) * D / 4.0 + CZ) * SY * D + Y) * C * A * R;
        double distance = S / 1000.0;
        double azimuth = FAZ * RADIANS_TO_DEGREES;
        if (azimuth < 0.0) {
            azimuth += 360.0;
        }
        double backazimuth = BAZ * RADIANS_TO_DEGREES;
        return new Bearing(azimuth, backazimuth, distance);
    }

    private Bearing() {
    }

    public Bearing(double azimuth, double backazimuth, double distance) {
        this.azimuth = azimuth;
        this.backazimuth = backazimuth;
        this.distance = distance;
    }

    public double getAngle() {
        return this.azimuth;
    }

    public double getBackAzimuth() {
        return this.backazimuth;
    }

    public double getDistance() {
        return this.distance;
    }

    public String toString() {
        return "Azimuth: " + this.azimuth + " Back azimuth: " + this.backazimuth + " Distance: " + this.distance;
    }
}

