/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.converters;

import java.util.TreeSet;
import java.util.function.BiConsumer;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.UnsignedShortType;

public class UnsignedShortLinearConverter<T extends AbstractIntegerType<T>>
implements Converter<T, UnsignedShortType>,
BiConsumer<T, UnsignedShortType> {
    public static final long MAXUSHORT = 65535L;
    private final double m;
    private final long b;
    private boolean isIdentity = false;

    public UnsignedShortLinearConverter() {
        this.m = 1.0;
        this.b = 0L;
        this.isIdentity = true;
    }

    public UnsignedShortLinearConverter(IterableInterval<T> img) {
        TreeSet<Long> values = UnsignedShortLinearConverter.uniqueValues(img);
        long min = values.first();
        long max = values.last();
        if (min > 0L && max <= 65535L) {
            this.isIdentity = true;
            this.m = 1.0;
            this.b = 0L;
        } else {
            this.b = -min;
            long diff = max - min;
            this.m = diff <= 65535L ? 1.0 : 65535.0 / (double)diff;
        }
    }

    public static <T extends AbstractIntegerType<T>> TreeSet<Long> uniqueValues(IterableInterval<T> img) {
        TreeSet<Long> uniqueValues = new TreeSet<Long>();
        Cursor c = img.cursor();
        while (c.hasNext()) {
            uniqueValues.add(((AbstractIntegerType)c.next()).getIntegerLong());
        }
        return uniqueValues;
    }

    @Override
    public void accept(T t, UnsignedShortType out) {
        this.convert(t, out);
    }

    public void convert(T t, UnsignedShortType output) {
        if (this.isIdentity) {
            output.setInteger(t.getInteger());
        } else {
            output.setInteger(Math.round(this.m * (double)(this.b + t.getIntegerLong())));
        }
    }
}

