/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.SpatialMetadataToImagePlus;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;

public class CosemToImagePlus
extends SpatialMetadataToImagePlus<N5CosemMetadata> {
    private boolean includeChannelAxis = false;

    public void includeChannelAxis(boolean includeChannelAxis) {
        this.includeChannelAxis = includeChannelAxis;
    }

    @Override
    public void writeMetadata(N5CosemMetadata t, ImagePlus ip) throws IOException {
        int nt;
        ip.setTitle(t.getPath());
        Calibration cal = ip.getCalibration();
        long[] dims = ArrayUtils.clone((long[])t.getAttributes().getDimensions());
        ArrayUtils.reverse((long[])dims);
        int[] spatialIndexes = this.spatialIndexes(t.getCosemTransform().axes);
        N5CosemMetadata.CosemTransform transform = t.getCosemTransform();
        cal.pixelWidth = spatialIndexes[0] > -1 ? transform.scale[spatialIndexes[0]] : 1.0;
        cal.pixelHeight = spatialIndexes[1] > -1 ? transform.scale[spatialIndexes[1]] : 1.0;
        cal.pixelDepth = spatialIndexes[2] > -1 ? transform.scale[spatialIndexes[2]] : 1.0;
        cal.xOrigin = spatialIndexes[0] > -1 ? transform.translate[spatialIndexes[0]] : 0.0;
        cal.yOrigin = spatialIndexes[1] > -1 ? transform.translate[spatialIndexes[1]] : 0.0;
        cal.zOrigin = spatialIndexes[2] > -1 ? transform.translate[spatialIndexes[2]] : 0.0;
        cal.setUnit(t.unit());
        int ci = this.channelIndex(t.getAxisLabels());
        int nc = ci == -1 ? 1 : (int)dims[ci];
        int ti = this.timeIndex(transform.axes);
        int n = nt = ti == -1 ? 1 : (int)dims[ti];
        if (ti != -1) {
            cal.frameInterval = transform.scale[ti];
        }
        int nz = spatialIndexes.length > 2 && spatialIndexes[2] != -1 ? (int)dims[spatialIndexes[2]] : 1;
    }

    @Override
    public N5CosemMetadata readMetadata(ImagePlus imp) throws IOException {
        int nd = 2;
        if (this.includeChannelAxis && imp.getNChannels() > 1) {
            ++nd;
        }
        if (imp.getNSlices() > 1) {
            ++nd;
        }
        if (imp.getNFrames() > 1) {
            ++nd;
        }
        String[] axes = new String[nd];
        double[] scale = new double[nd];
        Arrays.fill(scale, 1.0);
        double[] translation = new double[nd];
        int k = nd - 1;
        scale[k] = imp.getCalibration().pixelWidth;
        translation[k] = imp.getCalibration().xOrigin;
        axes[k--] = "x";
        scale[k] = imp.getCalibration().pixelHeight;
        translation[k] = imp.getCalibration().yOrigin;
        axes[k--] = "y";
        if (this.includeChannelAxis && imp.getNChannels() > 1) {
            axes[k--] = "c";
        }
        if (imp.getNSlices() > 1) {
            scale[k] = imp.getCalibration().pixelDepth;
            translation[k] = imp.getCalibration().zOrigin;
            axes[k--] = "z";
        }
        if (imp.getNFrames() > 1) {
            axes[k--] = "t";
        }
        Object[] units = new String[nd];
        Arrays.fill(units, imp.getCalibration().getUnit());
        return new N5CosemMetadata("", new N5CosemMetadata.CosemTransform(axes, scale, translation, (String[])units), ImageplusMetadata.datasetAttributes(imp));
    }

    private int[] spatialIndexes(String[] axes) {
        int[] spaceIndexes = new int[3];
        Arrays.fill(spaceIndexes, -1);
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i].equals("x")) {
                spaceIndexes[0] = i;
                continue;
            }
            if (axes[i].equals("y")) {
                spaceIndexes[1] = i;
                continue;
            }
            if (!axes[i].equals("z")) continue;
            spaceIndexes[2] = i;
        }
        return spaceIndexes;
    }

    private int timeIndex(String[] axes) {
        for (int i = 0; i < axes.length; ++i) {
            if (!axes[i].equals("t")) continue;
            return i;
        }
        return -1;
    }

    private int channelIndex(String[] axes) {
        for (int i = 0; i < axes.length; ++i) {
            if (!axes[i].equals("c")) continue;
            return i;
        }
        return -1;
    }
}

