/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import java.awt.Component;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang.ArrayUtils;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ImagePlusMetadata;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;

public class N5DatasetTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -4245251506197982653L;
    protected static final String thinSpace = "&#x2009;";
    protected static final String times = "&#xd7;";
    protected static final String warningFormat = "<font color=\"rgb(179, 58, 58)\">%s</font>";
    protected static final String nameFormat = "<b>%s</b>";
    protected static final String dimDelimeter = "&#x2009;&#xd7;&#x2009;";
    protected final boolean showConversionWarning;
    protected String rootName;

    public N5DatasetTreeCellRenderer(boolean showConversionWarning) {
        this.showConversionWarning = showConversionWarning;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, hasFocus);
        if (value instanceof N5SwingTreeNode) {
            N5SwingTreeNode node = (N5SwingTreeNode)value;
            if (node.getMetadata() != null && node.getMetadata() instanceof N5DatasetMetadata) {
                String convSuffix = N5DatasetTreeCellRenderer.conversionSuffix(node);
                String conversionString = this.showConversionWarning && !convSuffix.isEmpty() ? " " + String.format(warningFormat, N5DatasetTreeCellRenderer.conversionSuffix(node)) : "";
                String memStr = this.memString(node);
                String memSizeString = memStr.isEmpty() ? "" : " (" + memStr + ")";
                String name = node.getParent() == null ? this.rootName : node.getNodeName();
                this.setText(String.join((CharSequence)"", "<html>", String.format(nameFormat, name), " (", this.getParameterString(node), conversionString, ")", memSizeString, "</html>"));
            } else {
                this.setText(node.getParent() == null ? this.rootName : node.getNodeName());
            }
        }
        return this;
    }

    public static String conversionSuffix(N5TreeNode node) {
        N5ImagePlusMetadata ijMeta;
        N5Metadata meta = node.getMetadata();
        if (meta == null || !(meta instanceof N5DatasetMetadata)) {
            return "";
        }
        DataType type = ((N5DatasetMetadata)node.getMetadata()).getAttributes().getDataType();
        if (node.getMetadata() instanceof N5ImagePlusMetadata && (ijMeta = (N5ImagePlusMetadata)node.getMetadata()).getType() == 4 && type == DataType.UINT32) {
            return "(RGB)";
        }
        if (type == DataType.FLOAT64) {
            return "&#x2192; 32-bit";
        }
        if (type == DataType.INT8) {
            return "&#x2192; 8-bit";
        }
        if (type == DataType.INT32 || type == DataType.INT64 || type == DataType.UINT32 || type == DataType.UINT64 || type == DataType.INT16) {
            return "&#x2192; 16-bit";
        }
        return "";
    }

    public String getParameterString(N5TreeNode node) {
        N5Metadata meta = node.getMetadata();
        if (meta == null || !(meta instanceof N5DatasetMetadata)) {
            return "";
        }
        DatasetAttributes attributes = ((N5DatasetMetadata)node.getMetadata()).getAttributes();
        Object[] dimStrArr = (String[])Arrays.stream(attributes.getDimensions()).mapToObj(d -> Long.toString(d)).toArray(String[]::new);
        if (OmeNgffMultiScaleMetadata.fOrder((DatasetAttributes)attributes)) {
            ArrayUtils.reverse((Object[])dimStrArr);
        }
        return String.join((CharSequence)dimDelimeter, (CharSequence[])dimStrArr) + ", " + attributes.getDataType();
    }

    protected String memString(N5TreeNode node) {
        N5Metadata meta = node.getMetadata();
        if (meta == null || !(meta instanceof N5DatasetMetadata)) {
            return "";
        }
        DatasetAttributes attributes = ((N5DatasetMetadata)node.getMetadata()).getAttributes();
        long nBytes = this.estimateBytes(attributes);
        if (nBytes < 0L) {
            return "";
        }
        return N5DatasetTreeCellRenderer.humanReadableByteCountSI(nBytes);
    }

    protected static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    private long estimateBytes(DatasetAttributes attrs) {
        long N = Arrays.stream(attrs.getDimensions()).reduce(1L, (i, v) -> i * v);
        String typeString = attrs.getDataType().toString();
        long nBytes = -1L;
        if (typeString.endsWith("8")) {
            nBytes = N;
        } else if (typeString.endsWith("16")) {
            nBytes = N * 2L;
        } else if (typeString.endsWith("32")) {
            nBytes = N * 4L;
        } else if (typeString.endsWith("64")) {
            nBytes = N * 8L;
        }
        return nBytes;
    }
}

