/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.trakem2.transform.InvertibleCoordinateTransform;

public class RigidModel2D
extends mpicbg.models.RigidModel2D
implements InvertibleCoordinateTransform {
    @Override
    public final void init(String data) {
        String[] fields = data.split("\\s+");
        if (fields.length != 3) {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
        float theta = Float.parseFloat(fields[0]);
        float tx = Float.parseFloat(fields[1]);
        float ty = Float.parseFloat(fields[2]);
        this.set(theta, tx, ty);
    }

    @Override
    public final String toXML(String indent) {
        return indent + "<iict_transform class=\"" + this.getClass().getCanonicalName() + "\" data=\"" + this.toDataString() + "\" />";
    }

    @Override
    public final String toDataString() {
        return Math.atan2(this.sin, this.cos) + " " + this.tx + " " + this.ty;
    }

    @Override
    public final RigidModel2D copy() {
        RigidModel2D t = new RigidModel2D();
        t.init(this.toDataString());
        return t;
    }
}

