/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.util;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public final class Downsampler {
    private static final int averageByte(int i1, int i2, int i3, int i4, byte[] data) {
        return ((data[i1] & 0xFF) + (data[i2] & 0xFF) + (data[i3] & 0xFF) + (data[i4] & 0xFF)) / 4;
    }

    private static final int averageShort(int i1, int i2, int i3, int i4, short[] data) {
        return ((data[i1] & 0xFFFF) + (data[i2] & 0xFFFF) + (data[i3] & 0xFFFF) + (data[i4] & 0xFFFF)) / 4;
    }

    private static final float averageFloat(int i1, int i2, int i3, int i4, float[] data) {
        return (data[i1] + data[i2] + data[i3] + data[i4]) / 4.0f;
    }

    private static final int averageColorRed(int rgb1, int rgb2, int rgb3, int rgb4) {
        return ((rgb1 >> 16 & 0xFF) + (rgb2 >> 16 & 0xFF) + (rgb3 >> 16 & 0xFF) + (rgb4 >> 16 & 0xFF)) / 4;
    }

    private static final int averageColorGreen(int rgb1, int rgb2, int rgb3, int rgb4) {
        return ((rgb1 >> 8 & 0xFF) + (rgb2 >> 8 & 0xFF) + (rgb3 >> 8 & 0xFF) + (rgb4 >> 8 & 0xFF)) / 4;
    }

    private static final int averageColorBlue(int rgb1, int rgb2, int rgb3, int rgb4) {
        return ((rgb1 & 0xFF) + (rgb2 & 0xFF) + (rgb3 & 0xFF) + (rgb4 & 0xFF)) / 4;
    }

    private static final int averageColor(int i1, int i2, int i3, int i4, int[] data) {
        int rgb1 = data[i1];
        int rgb2 = data[i2];
        int rgb3 = data[i3];
        int rgb4 = data[i4];
        int red = Downsampler.averageColorRed(rgb1, rgb2, rgb3, rgb4);
        int green = Downsampler.averageColorGreen(rgb1, rgb2, rgb3, rgb4);
        int blue = Downsampler.averageColorBlue(rgb1, rgb2, rgb3, rgb4);
        return ((0xFF000000 | red) << 8 | green) << 8 | blue;
    }

    private static final int andByte(int i1, int i2, int i3, int i4, byte[] data) {
        return data[i1] & data[i2] & data[i3] & data[i4] & 0xFF;
    }

    public static final ByteProcessor downsampleByteProcessor(ByteProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ByteProcessor b = new ByteProcessor(wb, hb);
        byte[] aPixels = (byte[])a.getPixels();
        byte[] bPixels = (byte[])b.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int s = Downsampler.averageByte(ya + xa, ya + xa1, ya1 + xa, ya1 + xa1, aPixels);
                bPixels[yb + xb] = (byte)s;
                xa += 2;
            }
            ya += wa2;
        }
        return b;
    }

    public static final ByteProcessor downsampleByteProcessor(ByteProcessor a, int level) {
        for (int i = 0; i < level; ++i) {
            a = Downsampler.downsampleByteProcessor(a);
        }
        return a;
    }

    public static final ShortProcessor downsampleShortProcessor(ShortProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ShortProcessor b = new ShortProcessor(wb, hb);
        short[] aPixels = (short[])a.getPixels();
        short[] bPixels = (short[])b.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int s = Downsampler.averageShort(ya + xa, ya + xa1, ya1 + xa, ya1 + xa1, aPixels);
                bPixels[yb + xb] = (short)s;
                xa += 2;
            }
            ya += wa2;
        }
        return b;
    }

    public static final FloatProcessor downsampleFloatProcessor(FloatProcessor a, int level) {
        for (int i = 0; i < level; ++i) {
            a = Downsampler.downsampleFloatProcessor(a);
        }
        return a;
    }

    public static final FloatProcessor downsampleFloatProcessor(FloatProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        FloatProcessor b = new FloatProcessor(wb, hb);
        float[] aPixels = (float[])a.getPixels();
        float[] bPixels = (float[])b.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                float s;
                int xa1 = xa + 1;
                bPixels[yb + xb] = s = Downsampler.averageFloat(ya + xa, ya + xa1, ya1 + xa, ya1 + xa1, aPixels);
                xa += 2;
            }
            ya += wa2;
        }
        return b;
    }

    public static final ColorProcessor downsampleColorProcessor(ColorProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ColorProcessor b = new ColorProcessor(wb, hb);
        int[] aPixels = (int[])a.getPixels();
        int[] bPixels = (int[])b.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                bPixels[yb + xb] = Downsampler.averageColor(ya + xa, ya + xa1, ya1 + xa, ya1 + xa1, aPixels);
                xa += 2;
            }
            ya += wa2;
        }
        return b;
    }

    public static final ColorProcessor downsampleColorProcessor(ColorProcessor a, int level) {
        for (int i = 0; i < level; ++i) {
            a = Downsampler.downsampleColorProcessor(a);
        }
        return a;
    }

    public static final ImageProcessor downsampleImageProcessor(ImageProcessor a) {
        if (ByteProcessor.class.isInstance(a)) {
            return Downsampler.downsampleByteProcessor((ByteProcessor)a);
        }
        if (ShortProcessor.class.isInstance(a)) {
            return Downsampler.downsampleShortProcessor((ShortProcessor)a);
        }
        if (FloatProcessor.class.isInstance(a)) {
            return Downsampler.downsampleFloatProcessor((FloatProcessor)a);
        }
        if (ColorProcessor.class.isInstance(a)) {
            return Downsampler.downsampleColorProcessor((ColorProcessor)a);
        }
        return null;
    }

    public static final ImageProcessor downsampleImageProcessor(ImageProcessor a, int level) {
        for (int i = 0; i < level; ++i) {
            a = Downsampler.downsampleImageProcessor(a);
        }
        return a;
    }

    public static final Pair<ShortProcessor, byte[]> downsampleShort(ShortProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        double min = a.getMin();
        double max = a.getMax();
        double scale = 255.0 / (max - min);
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ShortProcessor b = new ShortProcessor(wb, hb);
        b.setMinAndMax(min, max);
        short[] aPixels = (short[])a.getPixels();
        short[] bPixels = (short[])b.getPixels();
        byte[] bBytes = new byte[bPixels.length];
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int yaxa = ya + xa;
                int yaxa1 = ya + xa1;
                int ya1xa = ya1 + xa;
                int ya1xa1 = ya1 + xa1;
                int ybxb = yb + xb;
                int s = Downsampler.averageShort(yaxa, yaxa1, ya1xa, ya1xa1, aPixels);
                bPixels[ybxb] = (short)s;
                int sb = (int)(((double)s - min) * scale + 0.5);
                bBytes[ybxb] = (byte)(sb < 0 ? 0 : (sb > 255 ? 255 : sb));
                xa += 2;
            }
            ya += wa2;
        }
        return new Pair<ShortProcessor, byte[]>(b, bBytes);
    }

    public static final Pair<FloatProcessor, byte[]> downsampleFloat(FloatProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        double min = a.getMin();
        double max = a.getMax();
        double scale = 255.0 / (max - min);
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        FloatProcessor b = new FloatProcessor(wb, hb);
        b.setMinAndMax(min, max);
        float[] aPixels = (float[])a.getPixels();
        float[] bPixels = (float[])b.getPixels();
        byte[] bBytes = new byte[bPixels.length];
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                float s;
                int xa1 = xa + 1;
                int yaxa = ya + xa;
                int yaxa1 = ya + xa1;
                int ya1xa = ya1 + xa;
                int ya1xa1 = ya1 + xa1;
                int ybxb = yb + xb;
                bPixels[ybxb] = s = Downsampler.averageFloat(yaxa, yaxa1, ya1xa, ya1xa1, aPixels);
                int sb = (int)(((double)s - min) * scale + 0.5);
                bBytes[ybxb] = (byte)(sb < 0 ? 0 : (sb > 255 ? 255 : sb));
                xa += 2;
            }
            ya += wa2;
        }
        return new Pair<FloatProcessor, byte[]>(b, bBytes);
    }

    public static final Pair<ColorProcessor, byte[][]> downsampleColor(ColorProcessor a) {
        int wa = a.getWidth();
        int ha = a.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ColorProcessor b = new ColorProcessor(wb, hb);
        int[] aPixels = (int[])a.getPixels();
        int[] bPixels = (int[])b.getPixels();
        byte[] rBytes = new byte[bPixels.length];
        byte[] gBytes = new byte[bPixels.length];
        byte[] bBytes = new byte[bPixels.length];
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int yaxa = ya + xa;
                int yaxa1 = ya + xa1;
                int ya1xa = ya1 + xa;
                int ya1xa1 = ya1 + xa1;
                int ybxb = yb + xb;
                int rgb1 = aPixels[yaxa];
                int rgb2 = aPixels[yaxa1];
                int rgb3 = aPixels[ya1xa];
                int rgb4 = aPixels[ya1xa1];
                int red = Downsampler.averageColorRed(rgb1, rgb2, rgb3, rgb4);
                int green = Downsampler.averageColorGreen(rgb1, rgb2, rgb3, rgb4);
                int blue = Downsampler.averageColorBlue(rgb1, rgb2, rgb3, rgb4);
                bPixels[ybxb] = ((0xFF000000 | red) << 8 | green) << 8 | blue;
                rBytes[ybxb] = (byte)red;
                gBytes[ybxb] = (byte)green;
                bBytes[ybxb] = (byte)blue;
                xa += 2;
            }
            ya += wa2;
        }
        return new Pair<ColorProcessor, byte[][]>(b, new byte[][]{rBytes, gBytes, bBytes});
    }

    private static final void combineAlphaAndOutside(int sOutside, int yaxa, int yaxa1, int ya1xa, int ya1xa1, int ybxb, byte[] aAlphaPixels, byte[] bAlphaPixels, byte[] bOutsidePixels) {
        if (sOutside == 255) {
            int sAlpha = Downsampler.averageByte(yaxa, yaxa1, ya1xa, ya1xa1, aAlphaPixels);
            bAlphaPixels[ybxb] = (byte)sAlpha;
            bOutsidePixels[ybxb] = -1;
        } else {
            bAlphaPixels[ybxb] = 0;
            bOutsidePixels[ybxb] = 0;
        }
    }

    public static final Pair<ByteProcessor, ByteProcessor> downsampleAlphaAndOutside(ByteProcessor aAlpha, ByteProcessor aOutside) {
        int wa = aAlpha.getWidth();
        int ha = aAlpha.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ByteProcessor bAlpha = new ByteProcessor(wb, hb);
        ByteProcessor bOutside = new ByteProcessor(wb, hb);
        byte[] aAlphaPixels = (byte[])aAlpha.getPixels();
        byte[] aOutsidePixels = (byte[])aOutside.getPixels();
        byte[] bAlphaPixels = (byte[])bAlpha.getPixels();
        byte[] bOutsidePixels = (byte[])bOutside.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int yaxa = ya + xa;
                int yaxa1 = ya + xa1;
                int ya1xa = ya1 + xa;
                int ya1xa1 = ya1 + xa1;
                int ybxb = yb + xb;
                int sOutside = Downsampler.andByte(yaxa, yaxa1, ya1xa, ya1xa1, aOutsidePixels);
                Downsampler.combineAlphaAndOutside(sOutside, yaxa, yaxa1, ya1xa, ya1xa1, ybxb, aAlphaPixels, bAlphaPixels, bOutsidePixels);
                xa += 2;
            }
            ya += wa2;
        }
        return new Pair<ByteProcessor, ByteProcessor>(bAlpha, bOutside);
    }

    public static final ByteProcessor downsampleOutside(ByteProcessor aOutside) {
        int wa = aOutside.getWidth();
        int ha = aOutside.getHeight();
        int wa2 = wa + wa;
        int wb = wa / 2;
        int hb = ha / 2;
        int nb = hb * wb;
        ByteProcessor bOutside = new ByteProcessor(wb, hb);
        byte[] aOutsidePixels = (byte[])aOutside.getPixels();
        byte[] bOutsidePixels = (byte[])bOutside.getPixels();
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int ya1 = ya + wa;
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                int xa1 = xa + 1;
                int sOutside = Downsampler.andByte(ya + xa, ya + xa1, ya1 + xa, ya1 + xa1, aOutsidePixels);
                bOutsidePixels[yb + xb] = sOutside == 255 ? -1 : 0;
                xa += 2;
            }
            ya += wa2;
        }
        return bOutside;
    }

    public static final class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    public static final class Entry {
        public final int width;
        public final int height;
        public final byte[][] data;

        public Entry(int width, int height, byte[][] data) {
            this.width = width;
            this.height = height;
            this.data = data;
        }

        public Entry(int width, int height, int channels) {
            this(width, height, new byte[channels][width * height]);
        }
    }
}

