/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Koala_Bin_Reader
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        String path = this.getPath(arg);
        if (null == path) {
            return;
        }
        if (!this.parse(path)) {
            return;
        }
        if (null == arg || 0 == arg.trim().length()) {
            this.show();
        }
    }

    private String getPath(String arg) {
        if (null != arg && (0 == arg.indexOf("http://") || new File(arg).exists())) {
            return arg;
        }
        OpenDialog od = new OpenDialog("Choose a .bin file", null);
        String dir = od.getDirectory();
        if (null == dir) {
            return null;
        }
        if (!(dir = dir.replace('\\', '/')).endsWith("/")) {
            dir = dir + "/";
        }
        return dir + od.getFileName();
    }

    private InputStream open(String path) throws Exception {
        if (0 == path.indexOf("http://")) {
            return new URL(path).openStream();
        }
        return new FileInputStream(path);
    }

    private boolean parse(String path) {
        byte[] buf = new byte[23];
        try {
            InputStream stream = this.open(path);
            stream.read(buf, 0, 23);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        byte version = buf[0];
        byte endianness = buf[1];
        int header_size = this.readIntLittleEndian(buf, 2);
        int width = this.readIntLittleEndian(buf, 6);
        int height = this.readIntLittleEndian(buf, 10);
        float pixel_size = this.readFloatLittleEndian(buf, 14);
        float height_conv = this.readFloatLittleEndian(buf, 18);
        byte unit = buf[22];
        FileInfo fi = new FileInfo();
        fi.fileType = 4;
        fi.fileFormat = 1;
        int islash = path.lastIndexOf(47);
        if (0 == path.indexOf("http://")) {
            fi.url = path;
        } else {
            fi.directory = path.substring(0, islash + 1);
        }
        fi.fileName = path.substring(islash + 1);
        fi.width = width;
        fi.height = height;
        fi.pixelHeight = (double)pixel_size * 1000000.0;
        fi.pixelWidth = (double)pixel_size * 1000000.0;
        fi.unit = "um";
        if (unit > 0) {
            fi.valueUnit = "nm";
        }
        fi.nImages = 1;
        fi.gapBetweenImages = 0;
        fi.intelByteOrder = endianness == 0;
        fi.whiteIsZero = false;
        fi.offset = header_size;
        fi.longOffset = fi.offset;
        try {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            ImageProcessor temp = imp.getProcessor();
            if (unit > 0) {
                temp.multiply((double)height_conv * 1.0E9);
                imp.setProcessor(temp);
            }
            this.setStack(imp.getTitle(), imp.getStack());
            this.setCalibration(imp.getCalibration());
            Object obinfo = imp.getProperty("Info");
            if (null != obinfo) {
                this.setProperty("Info", obinfo);
            }
            this.setFileInfo(imp.getOriginalFileInfo());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private final int readIntLittleEndian(byte[] buf, int start) {
        byte[] temp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            temp[i] = buf[start + i];
        }
        return ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private final float readFloatLittleEndian(byte[] buf, int start) {
        byte[] temp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            temp[i] = buf[start + i];
        }
        return ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }
}

