/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Open_MRC_Leginon
extends ImagePlus
implements PlugIn {
    private boolean bigEndian;

    public void run(String arg) {
        String path = arg;
        String directory = null;
        String filename = null;
        if (null == path || 0 == path.length()) {
            OpenDialog od = new OpenDialog("Choose .mrc file", null);
            directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            filename = od.getFileName();
            path = directory + "/" + filename;
        } else {
            File file = new File(path);
            directory = file.getParent();
            filename = file.getName();
            if (directory.startsWith("http:/")) {
                directory = "http://" + directory.substring(6);
            }
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        byte[] buf = new byte[213];
        try {
            InputStream is = 0 == path.indexOf("http://") ? new URL(path).openStream() : new FileInputStream(path);
            is.read(buf, 0, buf.length);
            is.close();
        }
        catch (IOException e) {
            return;
        }
        this.bigEndian = false;
        if (this.readInt(buf, 208) == 542130509 && buf[212] == 17) {
            this.bigEndian = true;
        }
        int w = this.readInt(buf, 0);
        int h = this.readInt(buf, 4);
        int n = this.readInt(buf, 8);
        int dtype = this.getType(this.readInt(buf, 12));
        if (-1 == dtype) {
            return;
        }
        long offset = 1024 + this.readInt(buf, 92);
        ImagePlus imp = Open_MRC_Leginon.openRaw(dtype, directory, filename, w, h, offset, n, 0, true, false);
        ImageStack stack = imp.getStack();
        this.setStack(imp.getTitle(), stack);
        this.setCalibration(imp.getCalibration());
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor tempImageProcessor = stack.getProcessor(i);
            tempImageProcessor.flipVertical();
        }
        Object obinfo = imp.getProperty("Info");
        if (null != obinfo) {
            this.setProperty("Info", obinfo);
        }
        this.setFileInfo(imp.getOriginalFileInfo());
        if (null == arg || 0 == arg.length()) {
            this.show();
        }
    }

    private int getType(int datatype) {
        switch (datatype) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 6: {
                return 2;
            }
        }
        return -1;
    }

    private final int readInt(byte[] buf, int start) {
        int b0 = buf[start] & 0xFF;
        int b1 = buf[start + 1] & 0xFF;
        int b2 = buf[start + 2] & 0xFF;
        int b3 = buf[start + 3] & 0xFF;
        if (this.bigEndian) {
            return b3 | b2 << 8 | b1 << 16 | b0 << 24;
        }
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    public static ImagePlus openRaw(int imageType, String directory, String fileName, int width, int height, long offset, int nImages, int gapBetweenImages, boolean intelByteOrder, boolean whiteIsZero) {
        FileInfo fi = new FileInfo();
        fi.fileType = imageType;
        fi.fileFormat = 1;
        fi.fileName = fileName;
        if (0 == directory.indexOf("http://")) {
            fi.url = directory;
        } else {
            fi.directory = directory;
        }
        fi.width = width;
        fi.height = height;
        if (offset > Integer.MAX_VALUE) {
            fi.longOffset = offset;
        } else {
            fi.offset = (int)offset;
        }
        fi.nImages = nImages;
        fi.gapBetweenImages = gapBetweenImages;
        fi.intelByteOrder = intelByteOrder;
        fi.whiteIsZero = whiteIsZero;
        FileOpener fo = new FileOpener(fi);
        try {
            return fo.open(false);
        }
        catch (Exception e) {
            return null;
        }
    }
}

