/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.ViewerImgLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.io.File;
import java.util.List;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.display.imagej.ImageJFunctions;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="File>Import>BigDataViewer...")
public class ImportPlugIn
implements Command {
    public static String xmlFile = "";
    public static int timepoint = 0;
    public static int setup = 0;
    public static int mipmap = 0;
    public static boolean openAsVirtualStack = false;

    private static SequenceDescriptionMinimal openSequence(String xmlFilename) throws SpimDataException {
        File f = new File(xmlFilename);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            SpimDataMinimal spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(xmlFilename);
            return (SequenceDescriptionMinimal)spimData.getSequenceDescription();
        }
        return null;
    }

    public void run() {
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        final GenericDialogPlus gd = new GenericDialogPlus("Import from BigDataViewer file");
        gd.addFileField("xml file", xmlFile);
        final TextField tfXmlFile = (TextField)gd.getStringFields().lastElement();
        gd.addSlider("timepoint index", 0.0, 0.0, (double)timepoint);
        final Scrollbar slTimepoint = (Scrollbar)gd.getSliders().lastElement();
        final TextField tfTimepoint = (TextField)gd.getNumericFields().lastElement();
        gd.addSlider("setup index", 0.0, 0.0, (double)setup);
        final Scrollbar slSetup = (Scrollbar)gd.getSliders().lastElement();
        final TextField tfSetup = (TextField)gd.getNumericFields().lastElement();
        gd.addSlider("resolution level", 0.0, 0.0, (double)setup);
        final Scrollbar slMipmap = (Scrollbar)gd.getSliders().lastElement();
        final TextField tfMipmap = (TextField)gd.getNumericFields().lastElement();
        gd.addCheckbox("open as virtual stack", openAsVirtualStack);
        final Checkbox cVirtual = (Checkbox)gd.getCheckboxes().lastElement();
        class TryOpen {
            TryOpen() {
            }

            void check(String xmlFilename) {
                boolean enable = false;
                boolean enableMipmap = false;
                try {
                    SequenceDescriptionMinimal seq = ImportPlugIn.openSequence(xmlFilename);
                    if (seq != null) {
                        int numTimepoints = seq.getTimePoints().size();
                        int numSetups = seq.getViewSetupsOrdered().size();
                        slTimepoint.setMaximum(numTimepoints);
                        slSetup.setMaximum(numSetups);
                        enable = true;
                        if (seq.getImgLoader() instanceof ViewerImgLoader) {
                            ViewerImgLoader vil = (ViewerImgLoader)seq.getImgLoader();
                            int numMipmapLevels = vil.getSetupImgLoader(((BasicViewSetup)seq.getViewSetupsOrdered().get(0)).getId()).numMipmapLevels();
                            slMipmap.setMaximum(numMipmapLevels);
                            enableMipmap = true;
                        } else {
                            enableMipmap = false;
                        }
                    }
                }
                catch (Exception ex) {
                    IJ.error((String)ex.getMessage());
                    ex.printStackTrace();
                }
                slTimepoint.setEnabled(enable);
                tfTimepoint.setEnabled(enable);
                slSetup.setEnabled(enable);
                tfSetup.setEnabled(enable);
                slMipmap.setEnabled(enableMipmap);
                tfMipmap.setEnabled(enableMipmap);
                cVirtual.setEnabled(enable);
            }
        }
        final TryOpen tryOpen = new TryOpen();
        tryOpen.check(xmlFile);
        gd.addDialogListener(new DialogListener(){
            {
            }

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                gd.getNextString();
                gd.getNextNumber();
                gd.getNextNumber();
                gd.getNextNumber();
                gd.getNextBoolean();
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfXmlFile) {
                    TextField tf = (TextField)e.getSource();
                    String xmlFilename = tf.getText();
                    tryOpen.check(xmlFilename);
                }
                return true;
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        xmlFile = gd.getNextString();
        timepoint = (int)gd.getNextNumber();
        setup = (int)gd.getNextNumber();
        mipmap = (int)gd.getNextNumber();
        openAsVirtualStack = gd.getNextBoolean();
        System.out.println(xmlFile + " " + timepoint + " " + setup);
        try {
            SequenceDescriptionMinimal seq = ImportPlugIn.openSequence(xmlFile);
            if (seq != null) {
                double[] mipmapResolution;
                RandomAccessibleInterval img;
                ImgLoaderHint[] imgLoaderHintArray;
                boolean duplicateImp;
                List timepointsOrdered = seq.getTimePoints().getTimePointsOrdered();
                List setupsOrdered = seq.getViewSetupsOrdered();
                int numTimepoints = timepointsOrdered.size();
                int numSetups = setupsOrdered.size();
                timepoint = Math.max(Math.min(timepoint, numTimepoints - 1), 0);
                setup = Math.max(Math.min(setup, numSetups - 1), 0);
                int timepointId = ((TimePoint)timepointsOrdered.get(timepoint)).getId();
                int setupId = ((BasicViewSetup)setupsOrdered.get(setup)).getId();
                BasicImgLoader il = seq.getImgLoader();
                boolean bl = duplicateImp = !openAsVirtualStack;
                if (openAsVirtualStack) {
                    imgLoaderHintArray = new ImgLoaderHint[]{};
                } else {
                    ImgLoaderHint[] imgLoaderHintArray2 = new ImgLoaderHint[1];
                    imgLoaderHintArray = imgLoaderHintArray2;
                    imgLoaderHintArray2[0] = ImgLoaderHints.LOAD_COMPLETELY;
                }
                ImgLoaderHint[] hints = imgLoaderHintArray;
                if (il instanceof BasicMultiResolutionImgLoader) {
                    BasicMultiResolutionImgLoader mil = (BasicMultiResolutionImgLoader)il;
                    int numMipmapLevels = mil.getSetupImgLoader(setupId).numMipmapLevels();
                    if (mipmap >= numMipmapLevels) {
                        mipmap = numMipmapLevels - 1;
                    }
                    img = mil.getSetupImgLoader(setupId).getImage(timepointId, mipmap, hints);
                    mipmapResolution = mil.getSetupImgLoader(setupId).getMipmapResolutions()[mipmap];
                } else {
                    img = il.getSetupImgLoader(setupId).getImage(timepointId, hints);
                    mipmapResolution = new double[]{1.0, 1.0, 1.0};
                }
                ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)img, (String)"");
                imp.setDimensions(1, imp.getImageStackSize(), 1);
                if (duplicateImp) {
                    imp = imp.duplicate();
                }
                imp.setTitle(new File(xmlFile).getName() + " " + timepoint + " " + setup);
                VoxelDimensions voxelSize = ((BasicViewSetup)setupsOrdered.get(setup)).getVoxelSize();
                if (voxelSize != null) {
                    Calibration calibration = imp.getCalibration();
                    calibration.setUnit(voxelSize.unit());
                    calibration.pixelWidth = voxelSize.dimension(0) * mipmapResolution[0];
                    calibration.pixelHeight = voxelSize.dimension(1) * mipmapResolution[1];
                    calibration.pixelDepth = voxelSize.dimension(2) * mipmapResolution[2];
                }
                imp.show();
            }
        }
        catch (Exception ex) {
            IJ.error((String)ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new ImageJ();
        new ImportPlugIn().run();
    }
}

