/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.RandomAccessStream;
import ij.io.RoiDecoder;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;
    private static boolean showConflictMessage = true;
    private double minValue;
    private double maxValue;
    private static boolean silentMode;

    public FileOpener(FileInfo fi) {
        this.fi = fi;
        if (fi != null) {
            this.width = fi.width;
            this.height = fi.height;
        }
        if (IJ.debugMode) {
            IJ.log("FileInfo: " + fi);
        }
    }

    public ImagePlus openImage() {
        boolean headless = GraphicsEnvironment.isHeadless();
        if (!headless) {
            Recorder.suspendRecording();
        }
        ImagePlus imp = this.open(false);
        if (!headless) {
            Recorder.resumeRecording();
        }
        return imp;
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean show) {
        ImagePlus imp = null;
        Object pb = null;
        ColorModel cm = this.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(cm, show);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 20: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 16: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 19: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ColorProcessor ip = new ColorProcessor(this.width, this.height, (int[])pixels);
                if (this.fi.fileType == 19) {
                    ip.invert();
                }
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 12: 
            case 17: {
                boolean planar = this.fi.fileType == 17;
                Object[] pixelArray = (Object[])this.readPixels(this.fi);
                if (pixelArray == null) {
                    return null;
                }
                int nChannels = 3;
                ImageStack stack = new ImageStack(this.width, this.height);
                stack.addSlice("Red", pixelArray[0]);
                stack.addSlice("Green", pixelArray[1]);
                stack.addSlice("Blue", pixelArray[2]);
                if (this.fi.samplesPerPixel == 4 && pixelArray.length == 4) {
                    stack.addSlice("Gray", pixelArray[3]);
                    nChannels = 4;
                }
                imp = new ImagePlus(this.fi.fileName, stack);
                imp.setDimensions(nChannels, 1, 1);
                if (planar) {
                    imp.getProcessor().resetMinAndMax();
                }
                imp.setFileInfo(this.fi);
                int mode = 1;
                if (this.fi.description != null) {
                    if (this.fi.description.indexOf("mode=color") != -1) {
                        mode = 2;
                    } else if (this.fi.description.indexOf("mode=gray") != -1) {
                        mode = 3;
                    }
                }
                imp = new CompositeImage(imp, mode);
                if (!planar && this.fi.displayRanges == null) {
                    if (nChannels == 4) {
                        ((CompositeImage)imp).resetDisplayRanges();
                    } else {
                        for (int c = 1; c <= 3; ++c) {
                            imp.setPosition(c, 1, 1);
                            imp.setDisplayRange(this.minValue, this.maxValue);
                        }
                        imp.setPosition(1, 1, 1);
                    }
                }
                if (!this.fi.whiteIsZero) break;
                IJ.run(imp, "Invert", "");
            }
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        if (this.fi.info != null) {
            imp.setProperty("Info", this.fi.info);
        }
        if (this.fi.sliceLabels != null && this.fi.sliceLabels.length == 1 && this.fi.sliceLabels[0] != null) {
            imp.setProp("Slice_Label", this.fi.sliceLabels[0]);
        }
        if (this.fi.plot != null) {
            try {
                Plot plot = new Plot(imp, new ByteArrayInputStream(this.fi.plot));
                imp.setProperty("thePlot", plot);
            }
            catch (Exception e) {
                IJ.handleException(e);
            }
        }
        if (this.fi.roi != null) {
            this.decodeAndSetRoi(imp, this.fi);
        }
        if (this.fi.overlay != null) {
            this.setOverlay(imp, this.fi.overlay);
        }
        if (this.fi.properties != null) {
            imp.setProperties(this.fi.properties);
        }
        if (show) {
            imp.show();
        }
        return imp;
    }

    public ImageProcessor openProcessor() {
        Object pb = null;
        ImageProcessor ip = null;
        ColorModel cm = this.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 20: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 16: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 19: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ip = new ColorProcessor(this.width, this.height, (int[])pixels);
                if (this.fi.fileType != 19) break;
                ip.invert();
            }
        }
        return ip;
    }

    void setOverlay(ImagePlus imp, byte[][] rois) {
        Overlay overlay = new Overlay();
        Overlay proto = null;
        for (int i = 0; i < rois.length; ++i) {
            Roi roi = RoiDecoder.openFromByteArray(rois[i]);
            if (roi == null) continue;
            if (proto == null) {
                proto = roi.getPrototypeOverlay();
                overlay.drawLabels(proto.getDrawLabels());
                overlay.drawNames(proto.getDrawNames());
                overlay.drawBackgrounds(proto.getDrawBackgrounds());
                overlay.setLabelColor(proto.getLabelColor());
                overlay.setLabelFont(proto.getLabelFont(), proto.scalableLabels());
            }
            overlay.add(roi);
        }
        imp.setOverlay(overlay);
    }

    ImagePlus openStack(ColorModel cm, boolean show) {
        ImageStack stack = new ImageStack(this.fi.width, this.fi.height, cm);
        long skip = this.fi.getOffset();
        try {
            ImageReader reader = new ImageReader(this.fi);
            InputStream is = this.createInputStream(this.fi);
            if (is == null) {
                return null;
            }
            IJ.resetEscape();
            for (int i = 1; i <= this.fi.nImages; ++i) {
                if (!silentMode) {
                    IJ.showStatus("Reading: " + i + "/" + this.fi.nImages);
                }
                if (IJ.escapePressed()) {
                    IJ.beep();
                    IJ.showProgress(1.0);
                    silentMode = false;
                    return null;
                }
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                stack.addSlice(null, pixels);
                skip = this.fi.getGap();
                if (silentMode) continue;
                IJ.showProgress(i, this.fi.nImages);
            }
            is.close();
        }
        catch (Exception e) {
            IJ.log("" + e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(this.fi.fileName);
            stack.trim();
        }
        if (!silentMode) {
            IJ.showProgress(1.0);
        }
        if (stack.size() == 0) {
            return null;
        }
        if (this.fi.sliceLabels != null && this.fi.sliceLabels.length <= stack.size()) {
            for (int i = 0; i < this.fi.sliceLabels.length; ++i) {
                stack.setSliceLabel(this.fi.sliceLabels[i], i + 1);
            }
        }
        ImagePlus imp = new ImagePlus(this.fi.fileName, stack);
        if (this.fi.info != null) {
            imp.setProperty("Info", this.fi.info);
        }
        if (this.fi.roi != null) {
            this.decodeAndSetRoi(imp, this.fi);
        }
        if (this.fi.overlay != null) {
            this.setOverlay(imp, this.fi.overlay);
        }
        if (this.fi.properties != null) {
            imp.setProperties(this.fi.properties);
        }
        if (show) {
            imp.show();
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMin() == ip.getMax()) {
            this.setStackDisplayRange(imp);
        }
        if (!silentMode) {
            IJ.showProgress(1.0);
        }
        return imp;
    }

    private void decodeAndSetRoi(ImagePlus imp, FileInfo fi) {
        Roi roi = RoiDecoder.openFromByteArray(fi.roi);
        imp.setRoi(roi);
        if (roi instanceof PointRoi && ((PointRoi)roi).getNCounters() > 1) {
            IJ.setTool("multi-point");
        }
    }

    void setStackDisplayRange(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int n = stack.size();
        for (int i = 1; i <= n; ++i) {
            if (!silentMode) {
                IJ.showStatus("Calculating stack min and max: " + i + "/" + n);
            }
            ImageProcessor ip = stack.getProcessor(i);
            ip.resetMinAndMax();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (!(ip.getMax() > max)) continue;
            max = ip.getMax();
        }
        imp.getProcessor().setMinAndMax(min, max);
        imp.updateAndDraw();
    }

    public void revertToSaved(ImagePlus imp) {
        if (this.fi == null) {
            return;
        }
        String path = this.fi.getFilePath();
        if (this.fi.url != null && !this.fi.url.equals("") && (this.fi.directory == null || this.fi.directory.equals(""))) {
            path = this.fi.url;
        }
        IJ.showStatus("Loading: " + path);
        ImagePlus imp2 = null;
        if (!path.endsWith(".raw")) {
            imp2 = IJ.openImage(path);
        }
        if (imp2 != null) {
            imp.setImage(imp2);
        } else {
            if (this.fi.nImages > 1) {
                return;
            }
            Object pixels = this.readPixels(this.fi);
            if (pixels == null) {
                return;
            }
            ColorModel cm = this.createColorModel(this.fi);
            ImageProcessor ip = null;
            switch (this.fi.fileType) {
                case 0: 
                case 5: 
                case 8: {
                    ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                    imp.setProcessor(null, ip);
                    break;
                }
                case 1: 
                case 2: 
                case 13: 
                case 20: {
                    ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                    imp.setProcessor(null, ip);
                    break;
                }
                case 3: 
                case 4: {
                    ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                    imp.setProcessor(null, ip);
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 18: {
                    Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])pixels, 0, this.width));
                    imp.setImage(img);
                    break;
                }
                case 19: {
                    ip = new ColorProcessor(this.width, this.height, (int[])pixels);
                    ip.invert();
                    imp.setProcessor(null, ip);
                }
            }
        }
    }

    void setCalibration(ImagePlus imp) {
        int stackSize;
        if (this.fi.fileType == 1) {
            if (IJ.debugMode) {
                IJ.log("16-bit signed");
            }
            imp.getLocalCalibration().setSigned16BitCalibration();
        }
        Properties props = this.decodeDescriptionString(this.fi);
        Calibration cal = imp.getCalibration();
        boolean calibrated = false;
        if (this.fi.pixelWidth > 0.0 && this.fi.unit != null) {
            double threshold = 0.001;
            if (this.fi.description != null && this.fi.description.startsWith("ImageJ")) {
                threshold = 1.0E-4;
            }
            if (Prefs.convertToMicrons && this.fi.pixelWidth <= threshold && this.fi.unit.equals("cm")) {
                this.fi.pixelWidth *= 10000.0;
                this.fi.pixelHeight *= 10000.0;
                if (this.fi.pixelDepth != 1.0) {
                    this.fi.pixelDepth *= 10000.0;
                }
                this.fi.unit = "um";
            }
            cal.pixelWidth = this.fi.pixelWidth;
            cal.pixelHeight = this.fi.pixelHeight;
            cal.pixelDepth = this.fi.pixelDepth;
            cal.setUnit(this.fi.unit);
            calibrated = true;
        }
        if (this.fi.valueUnit != null) {
            if (imp.getBitDepth() == 32) {
                cal.setValueUnit(this.fi.valueUnit);
            } else {
                int f = this.fi.calibrationFunction;
                if (f >= 0 && f <= 13 && this.fi.coefficients != null || f == 21) {
                    boolean zeroClip = props != null && props.getProperty("zeroclip", "false").equals("true");
                    cal.setFunction(f, this.fi.coefficients, this.fi.valueUnit, zeroClip);
                    calibrated = true;
                }
            }
        }
        if (calibrated) {
            this.checkForCalibrationConflict(imp, cal);
        }
        if (this.fi.frameInterval != 0.0) {
            cal.frameInterval = this.fi.frameInterval;
        }
        if (props == null) {
            return;
        }
        cal.xOrigin = this.getDouble(props, "xorigin");
        cal.yOrigin = this.getDouble(props, "yorigin");
        cal.zOrigin = this.getDouble(props, "zorigin");
        cal.setInvertY(this.getBoolean(props, "inverty"));
        cal.info = props.getProperty("info");
        cal.fps = this.getDouble(props, "fps");
        cal.loop = this.getBoolean(props, "loop");
        cal.frameInterval = this.getDouble(props, "finterval");
        cal.setTimeUnit(props.getProperty("tunit", "sec"));
        cal.setYUnit(props.getProperty("yunit"));
        cal.setZUnit(props.getProperty("zunit"));
        double displayMin = this.getDouble(props, "min");
        double displayMax = this.getDouble(props, "max");
        if (displayMin != 0.0 || displayMax != 0.0) {
            int type = imp.getType();
            ImageProcessor ip = imp.getProcessor();
            if (type == 0 || type == 3) {
                ip.setMinAndMax(displayMin, displayMax);
            } else if (!(type != 1 && type != 2 || ip.getMin() == displayMin && ip.getMax() == displayMax)) {
                ip.setMinAndMax(displayMin, displayMax);
            }
        }
        if (this.getBoolean(props, "8bitcolor")) {
            imp.setTypeToColor256();
        }
        if ((stackSize = imp.getStackSize()) > 1) {
            int channels = (int)this.getDouble(props, "channels");
            int slices = (int)this.getDouble(props, "slices");
            int frames = (int)this.getDouble(props, "frames");
            if (channels == 0) {
                channels = 1;
            }
            if (slices == 0) {
                slices = 1;
            }
            if (frames == 0) {
                frames = 1;
            }
            if (channels * slices * frames == stackSize) {
                imp.setDimensions(channels, slices, frames);
                if (this.getBoolean(props, "hyperstack")) {
                    imp.setOpenAsHyperStack(true);
                }
            }
        }
    }

    void checkForCalibrationConflict(ImagePlus imp, Calibration cal) {
        boolean dontShow;
        Calibration gcal = imp.getGlobalCalibration();
        if (gcal == null || !showConflictMessage || IJ.isMacro()) {
            return;
        }
        if (cal.pixelWidth == gcal.pixelWidth && cal.getUnit().equals(gcal.getUnit())) {
            return;
        }
        GenericDialog gd = new GenericDialog(imp.getTitle());
        gd.addMessage("The calibration of this image conflicts\nwith the current global calibration.");
        gd.addCheckbox("Disable_Global Calibration", true);
        gd.addCheckbox("Disable_these Messages", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean disable = gd.getNextBoolean();
        if (disable) {
            imp.setGlobalCalibration(null);
            imp.setCalibration(cal);
            WindowManager.repaintImageWindows();
        }
        if (dontShow = gd.getNextBoolean()) {
            showConflictMessage = false;
        }
    }

    public ColorModel createColorModel(FileInfo fi) {
        if (fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    public InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        boolean gzip;
        InputStream is = null;
        boolean bl = gzip = fi.fileName != null && (fi.fileName.endsWith(".gz") || fi.fileName.endsWith(".GZ"));
        if (fi.inputStream != null) {
            is = fi.inputStream;
        } else if (fi.url != null && !fi.url.equals("")) {
            is = new URL(fi.url + fi.fileName).openStream();
        } else {
            if (fi.directory != null && fi.directory.length() > 0 && !fi.directory.endsWith(Prefs.separator) && !fi.directory.endsWith("/")) {
                fi.directory = fi.directory + Prefs.separator;
            }
            File f = new File(fi.getFilePath());
            if (gzip) {
                fi.compression = 0;
            }
            is = f == null || !f.exists() || f.isDirectory() || !FileOpener.validateFileInfo(f, fi) ? null : new FileInputStream(f);
        }
        if (is != null) {
            if (fi.compression >= 2) {
                is = new RandomAccessStream(is);
            } else if (gzip) {
                is = new GZIPInputStream(is, 50000);
            }
        }
        return is;
    }

    static boolean validateFileInfo(File f, FileInfo fi) {
        long offset = fi.getOffset();
        long length = 0L;
        if (fi.width <= 0 || fi.height <= 0) {
            FileOpener.error("Width or height <= 0.", fi, offset, length);
            return false;
        }
        if (offset >= 0L && offset < 1000L) {
            return true;
        }
        if (offset < 0L) {
            FileOpener.error("Offset is negative.", fi, offset, length);
            return false;
        }
        if (fi.fileType == 8 || fi.compression != 1) {
            return true;
        }
        length = f.length();
        long size = fi.width * fi.height * fi.getBytesPerPixel();
        long l = size = fi.nImages > 1 ? size : size / 4L;
        if (fi.height == 1) {
            size = 0L;
        }
        if (offset + size > length) {
            FileOpener.error("Offset + image size > file length.", fi, offset, length);
            return false;
        }
        return true;
    }

    static void error(String msg, FileInfo fi, long offset, long length) {
        String msg2 = "FileInfo parameter error. \n" + msg + "\n \n  Width: " + fi.width + "\n  Height: " + fi.height + "\n  Offset: " + offset + "\n  Bytes/pixel: " + fi.getBytesPerPixel() + "\n" + (length > 0L ? "  File length: " + length + "\n" : "");
        if (silentMode) {
            IJ.log("Error opening " + fi.getFilePath());
            IJ.log(msg2);
        } else {
            IJ.error("FileOpener", msg2);
        }
    }

    Object readPixels(FileInfo fi) {
        Object pixels;
        block3: {
            pixels = null;
            try {
                InputStream is = this.createInputStream(fi);
                if (is == null) {
                    return null;
                }
                ImageReader reader = new ImageReader(fi);
                pixels = reader.readPixels(is);
                this.minValue = reader.min;
                this.maxValue = reader.max;
                is.close();
            }
            catch (Exception e) {
                if ("Macro canceled".equals(e.getMessage())) break block3;
                IJ.handleException(e);
            }
        }
        return pixels;
    }

    public Properties decodeDescriptionString(FileInfo fi) {
        String name;
        int i;
        if (fi.description == null || fi.description.length() < 7) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(fi.description).replace('\n', ' '));
        }
        if (!fi.description.startsWith("ImageJ")) {
            return null;
        }
        Properties props = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(fi.description.getBytes());
        try {
            props.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return null;
        }
        String dsUnit = props.getProperty("unit", "");
        if ("cm".equals(fi.unit) && "um".equals(dsUnit)) {
            fi.pixelWidth *= 10000.0;
            fi.pixelHeight *= 10000.0;
        }
        fi.unit = dsUnit;
        Double n = this.getNumber(props, "cf");
        if (n != null) {
            fi.calibrationFunction = n.intValue();
        }
        double[] c = new double[5];
        int count = 0;
        for (i = 0; i < 5 && (n = this.getNumber(props, "c" + i)) != null; ++i) {
            c[i] = n;
            ++count;
        }
        if (count >= 2) {
            fi.coefficients = new double[count];
            for (i = 0; i < count; ++i) {
                fi.coefficients[i] = c[i];
            }
        }
        fi.valueUnit = props.getProperty("vunit");
        n = this.getNumber(props, "images");
        if (n != null && n > 1.0) {
            fi.nImages = (int)n.doubleValue();
        }
        if ((n = this.getNumber(props, "spacing")) != null) {
            double spacing = n;
            if (spacing < 0.0) {
                spacing = -spacing;
            }
            fi.pixelDepth = spacing;
        }
        if ((name = props.getProperty("name")) != null) {
            fi.fileName = name;
        }
        return props;
    }

    private Double getNumber(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private double getDouble(Properties props, String key) {
        Double n = this.getNumber(props, key);
        return n != null ? n : 0.0;
    }

    private boolean getBoolean(Properties props, String key) {
        String s = props.getProperty(key);
        return s != null && s.equals("true");
    }

    public static void setShowConflictMessage(boolean b) {
        showConflictMessage = b;
    }

    static void setSilentMode(boolean mode) {
        silentMode = mode;
    }
}

