/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.io.Opener;
import ij.measure.ResultsTable;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.process.ImageProcessor;
import java.awt.Desktop;
import java.io.File;

public class SimpleCommands
implements PlugIn {
    static String searchArg;
    private static String[] choices;
    private static int choiceIndex;

    @Override
    public void run(String arg) {
        if (arg.equals("search")) {
            this.search();
        } else if (arg.equals("import")) {
            Opener.openResultsTable("");
        } else if (arg.equals("table")) {
            Opener.openTable("");
        } else if (arg.equals("rename")) {
            this.rename();
        } else if (arg.equals("reset")) {
            this.reset();
        } else if (arg.equals("about")) {
            this.aboutPluginsHelp();
        } else if (arg.equals("install")) {
            this.installation();
        } else if (arg.equals("set")) {
            this.setSliceLabel();
        } else if (arg.equals("remove")) {
            this.removeStackLabels();
        } else if (arg.equals("itor")) {
            this.imageToResults();
        } else if (arg.equals("rtoi")) {
            this.resultsToImage();
        } else if (arg.equals("display")) {
            IJ.runMacroFile("ij.jar:ShowAllLuts", null);
        } else if (arg.equals("missing")) {
            this.showMissingPluginsMessage();
        } else if (arg.equals("fonts")) {
            this.showFonts();
        } else if (arg.equals("opencp")) {
            this.openControlPanel();
        } else if (arg.equals("magic")) {
            this.installMagicMontageTools();
        } else if (arg.equals("interactive")) {
            this.openInteractiveModeEditor();
        } else if (arg.startsWith("showdir")) {
            this.showDirectory(arg.replace("showdir", ""));
        } else if (arg.equals("measure")) {
            this.measureStack();
        } else if (arg.equals("invert")) {
            IJ.runMacroFile("ij.jar:InvertAllLuts", null);
        }
    }

    private synchronized void showFonts() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                IJ.runPlugIn("ij.plugin.Text", "");
            }
        });
        t.start();
    }

    private void reset() {
        GenericDialog gd = new GenericDialog("");
        gd.addChoice("Reset:", choices, choices[choiceIndex]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        choiceIndex = gd.getNextChoiceIndex();
        switch (choiceIndex) {
            case 0: {
                this.unlock();
                break;
            }
            case 1: {
                this.resetClipboard();
                break;
            }
            case 2: {
                this.resetUndo();
            }
        }
    }

    private void unlock() {
        ImagePlus imp = IJ.getImage();
        boolean wasUnlocked = imp.lockSilently();
        if (wasUnlocked) {
            IJ.showStatus("\"" + imp.getTitle() + "\" is not locked");
        } else {
            IJ.showStatus("\"" + imp.getTitle() + "\" is now unlocked");
            IJ.beep();
        }
        imp.unlock();
    }

    private void resetClipboard() {
        ImagePlus.resetClipboard();
        IJ.showStatus("Clipboard reset");
    }

    private void resetUndo() {
        Undo.setup(0, null);
        IJ.showStatus("Undo reset");
    }

    private void rename() {
        ImagePlus imp = IJ.getImage();
        GenericDialog gd = new GenericDialog("Rename");
        gd.addStringField("Title:", imp.getTitle(), 30);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            imp.setTitle(gd.getNextString());
        }
    }

    private void search() {
        searchArg = IJ.runMacroFile("ij.jar:Search", searchArg);
    }

    private void installation() {
        String url = "http://imagej.net/ij/docs/install/";
        if (IJ.isMacintosh()) {
            url = url + "osx.html";
        } else if (IJ.isWindows()) {
            url = url + "windows.html";
        } else if (IJ.isLinux()) {
            url = url + "linux.html";
        }
        IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
    }

    private void aboutPluginsHelp() {
        IJ.showMessage("\"About Plugins\" Submenu", "Plugins packaged as JAR files can add entries\nto this submenu. There is an example at\n \nhttp://imagej.net/ij/plugins/jar-demo.html");
    }

    private void setSliceLabel() {
        int n;
        ImagePlus imp = IJ.getImage();
        ImageStack stack = imp.getStack();
        String label = stack.getSliceLabel(n = imp.getCurrentSlice());
        String label2 = label;
        if (label2 == null) {
            label2 = "";
        }
        GenericDialog gd = new GenericDialog("Set Slice Label (" + n + ")");
        gd.addStringField("Label:", label2, 30);
        gd.showDialog();
        if (!gd.wasCanceled() && (label2 = gd.getNextString()) != null && !label2.equals(label)) {
            if (label2.length() == 0) {
                label2 = null;
            }
            stack.setSliceLabel(label2, n);
            imp.setProp("Slice_Label", label2);
            imp.repaintWindow();
        }
    }

    private void removeStackLabels() {
        ImagePlus imp = IJ.getImage();
        ImageStack stack = imp.getStack();
        int size = imp.getStackSize();
        for (int i = 1; i <= size; ++i) {
            stack.setSliceLabel(null, i);
        }
        if (size == 1) {
            imp.setProp("Slice_Label", null);
        }
        imp.repaintWindow();
    }

    private void imageToResults() {
        ResultsTable rt = ResultsTable.createTableFromImage(IJ.getImage());
        if (rt != null) {
            rt.show("Results");
        }
    }

    private void resultsToImage() {
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null || rt.size() == 0) {
            IJ.error("Results to Image", "The Results table is empty");
            return;
        }
        ImageProcessor ip = rt.getTableAsImage();
        if (ip == null) {
            return;
        }
        new ImagePlus("Results Table", ip).show();
    }

    private void openControlPanel() {
        Prefs.set("Control_Panel.@Main", "51 22 92 426");
        Prefs.set("Control_Panel.Help.Examples", "144 107 261 373");
        IJ.run("Control Panel...", "");
    }

    private void showMissingPluginsMessage() {
        IJ.showMessage("Path Randomization", "Plugins were not loaded due to macOS Path Randomization.\nTo work around this problem, move ImageJ.app out of the\nImageJ folder and then copy it back. More information is at\n \nhttp://imagej.net/ij/docs/install/osx.html#randomization");
    }

    private void installMagicMontageTools() {
        String name = "MagicMontageTools.txt";
        String path = "/macros/" + name;
        MacroInstaller mi = new MacroInstaller();
        if (IJ.shiftKeyDown()) {
            Toolbar.showCode(name, mi.openFromIJJar(path));
        } else {
            try {
                mi.installFromIJJar(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void openInteractiveModeEditor() {
        Editor ed = new Editor();
        ed.setSize(600, 500);
        ed.create("Interactive Interpreter", "");
    }

    private void showDirectory(String arg) {
        File imgPath;
        String path = IJ.getDir(arg = arg.toLowerCase());
        if (path == null) {
            if (arg.equals("image")) {
                if (WindowManager.getCurrentImage() == null) {
                    IJ.noImage();
                } else {
                    IJ.error("No file is associated with front image");
                }
            } else {
                IJ.error("Folder not found: " + arg);
            }
            return;
        }
        File dir = new File(path);
        if (!dir.exists()) {
            IJ.error("Folder not found: " + arg);
            return;
        }
        if (arg.equals("image") && IJ.getImage() != null && !(imgPath = new File(IJ.getDir("image"))).exists()) {
            IJ.error("Image not found");
            return;
        }
        if (IJ.debugMode) {
            IJ.log("Show Folder: arg=" + arg + ", path=" + path);
        }
        String msg1 = "";
        if (IJ.isLinux()) {
            try {
                if (IJ.debugMode) {
                    IJ.log("  trying xdg-open " + path);
                }
                Runtime.getRuntime().exec(new String[]{"xdg-open", path});
                return;
            }
            catch (Exception e2) {
                msg1 = "xdg-open error: " + e2;
            }
        }
        try {
            if (IJ.debugMode) {
                IJ.log("  trying Desktop.open " + dir);
            }
            Desktop desktop = Desktop.getDesktop();
            desktop.open(dir);
        }
        catch (Exception e) {
            String msg2 = "Desktop.open error: " + e;
            if (msg1.length() > 0) {
                msg2 = msg1 + "\n" + msg2;
            }
            IJ.error("Show Folder", msg2);
        }
    }

    private void measureStack() {
        ImagePlus imp = IJ.getImage();
        if (imp.isLocked()) {
            IJ.showStatus("Image is locked: \"" + imp.getTitle() + "\"");
            IJ.beep();
        } else {
            IJ.runMacroFile("ij.jar:MeasureStack", null);
        }
    }

    static {
        choices = new String[]{"Locked Image", "Clipboard", "Undo Buffer"};
        choiceIndex = 0;
    }
}

