/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TextReader
implements PlugIn {
    int words = 0;
    int chars = 0;
    int lines = 0;
    int width = 1;
    String directory;
    String name;
    String path;
    boolean hideErrorMessages;
    String firstTok;

    @Override
    public void run(String arg) {
        if (this.showDialog()) {
            IJ.showStatus("Opening: " + this.path);
            ImageProcessor ip = this.open(this.path);
            if (ip != null) {
                new ImagePlus(this.name, ip).show();
            }
            if (IJ.recording() && Recorder.scriptMode()) {
                String path2 = Recorder.fixPath(this.path);
                Recorder.recordCall("imp = IJ.openImage(\"" + path2 + "\");");
            }
        }
    }

    boolean showDialog() {
        OpenDialog od = new OpenDialog("Open Text Image...", null);
        this.directory = od.getDirectory();
        this.name = od.getFileName();
        if (this.name != null) {
            this.path = this.directory + this.name;
        }
        return this.name != null;
    }

    public ImageProcessor open() {
        if (this.showDialog()) {
            return this.open(this.path);
        }
        return null;
    }

    public ImageProcessor open(String path) {
        ImageProcessor ip = null;
        try {
            this.lines = 0;
            this.chars = 0;
            this.words = 0;
            BufferedReader r = new BufferedReader(new FileReader(path));
            this.countLines(r);
            ((Reader)r).close();
            r = new BufferedReader(new FileReader(path));
            if (this.width * this.lines == 0) {
                return null;
            }
            float[] pixels = new float[this.width * this.lines];
            ip = new FloatProcessor(this.width, this.lines, pixels, null);
            this.read(r, this.width * this.lines, pixels);
            ((Reader)r).close();
            int firstRowNaNCount = 0;
            for (int i = 0; i < this.width; ++i) {
                if (i >= pixels.length || !Float.isNaN(pixels[i])) continue;
                ++firstRowNaNCount;
            }
            if (firstRowNaNCount == this.width && !"NaN".equals(this.firstTok) && !"nan".equals(this.firstTok)) {
                ip.setRoi(0, 1, this.width, this.lines - 1);
                ip = ((ImageProcessor)ip).crop();
            }
            ((ImageProcessor)ip).resetMinAndMax();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showProgress(1.0);
            if (!this.hideErrorMessages) {
                IJ.error("Text Reader", msg);
            }
            ip = null;
        }
        return ip;
    }

    public void hideErrorMessages() {
        this.hideErrorMessages = true;
    }

    public String getName() {
        return this.name;
    }

    void countLines(Reader r) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        int wordsPerLine = 0;
        int wordsInPreviousLine = 0;
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 127);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(128, 255);
        tok.eolIsSignificant(true);
        while (tok.nextToken() != -1) {
            switch (tok.ttype) {
                case 10: {
                    ++this.lines;
                    if (wordsPerLine == 0) {
                        --this.lines;
                    }
                    if (this.lines == 1 && wordsPerLine > 0) {
                        this.width = wordsPerLine;
                    }
                    if (this.lines > 1 && wordsPerLine != 0 && wordsPerLine != wordsInPreviousLine) {
                        throw new IOException("Line " + this.lines + " is not the same length as the first line.");
                    }
                    if (wordsPerLine != 0) {
                        wordsInPreviousLine = wordsPerLine;
                    }
                    wordsPerLine = 0;
                    if (this.lines % 20 != 0 || this.width <= 1 || this.lines > this.width) break;
                    IJ.showProgress((double)this.lines / (double)this.width / 2.0);
                    break;
                }
                case -3: {
                    ++this.words;
                    ++wordsPerLine;
                }
            }
        }
        if (wordsPerLine == this.width) {
            ++this.lines;
        }
    }

    void read(Reader r, int size, float[] pixels) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 127);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(128, 255);
        int i = 0;
        int inc = size / 20;
        if (inc < 1) {
            inc = 1;
        }
        while (tok.nextToken() != -1) {
            if (tok.ttype != -3) continue;
            if (i == 0) {
                this.firstTok = tok.sval;
            }
            pixels[i++] = (float)Tools.parseDouble(tok.sval, Double.NaN);
            if (i == size) break;
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }
}

