/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data;

import gnu.trove.list.array.TIntArrayList;

class FastIntArrayParser {
    private static final char EOL = '\u0000';
    private final String text;
    private char symbol;
    private int cursorPosition;
    private boolean success = true;

    private FastIntArrayParser(String text) {
        this.text = text;
        this.cursorPosition = 0;
        this.symbol = text.charAt(this.cursorPosition);
    }

    public static int[] toIntArray(String text) {
        FastIntArrayParser parser = new FastIntArrayParser(text);
        parser.parseSpaces();
        int[] ints = parser.parseInts();
        if (!parser.eol()) {
            throw new NumberFormatException();
        }
        return ints;
    }

    private int[] parseInts() {
        TIntArrayList values = new TIntArrayList();
        while (true) {
            int val = this.parseInt();
            if (!this.success) break;
            values.add(val);
            this.parseSpaces();
            if (!this.success) break;
            this.parseSpaces();
        }
        this.success = true;
        return values.toArray();
    }

    private void parseSpaces() {
        do {
            this.parseSpace();
        } while (this.success);
        this.success = true;
    }

    private int parseInt() {
        this.parseCharacter('-');
        if (this.success) {
            return -this.parsePositiveInt();
        }
        this.parseCharacter('+');
        return this.parsePositiveInt();
    }

    private int parsePositiveInt() {
        int value = this.parseNumber();
        if (!this.success) {
            return 0;
        }
        while (true) {
            int numericValue = this.parseNumber();
            if (!this.success) break;
            value *= 10;
            value += numericValue;
        }
        this.success = true;
        return value;
    }

    private void parseSpace() {
        this.success = Character.isSpaceChar(this.symbol);
        if (this.success) {
            this.forwardCursor();
        }
    }

    private void parseCharacter(char c) {
        boolean bl = this.success = this.symbol == c;
        if (this.success) {
            this.forwardCursor();
        }
    }

    private int parseNumber() {
        int value = Character.getNumericValue(this.symbol);
        boolean bl = this.success = value >= 0;
        if (this.success) {
            this.forwardCursor();
        }
        return value;
    }

    private void forwardCursor() {
        ++this.cursorPosition;
        this.symbol = this.cursorPosition < this.text.length() ? this.text.charAt(this.cursorPosition) : (char)'\u0000';
    }

    private boolean eol() {
        return this.symbol == '\u0000';
    }
}

