/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.base;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.SpimDataInstantiationException;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoSingleton<T> {
    private final String tag;
    private final Constructor<T> ctor;
    protected final HashSet<String> handledTags;
    private final ArrayList<Element> unhandledContent;

    public XmlIoSingleton(String tag, Class<T> klass) {
        this.tag = tag;
        try {
            this.ctor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(klass.getSimpleName() + " must have a no-argument constructor.", e);
        }
        this.ctor.setAccessible(true);
        this.handledTags = new HashSet();
        this.unhandledContent = new ArrayList();
    }

    public String getTag() {
        return this.tag;
    }

    protected Element toXml() {
        Element elem = new Element(this.tag);
        for (Element c : this.unhandledContent) {
            elem.addContent((Content)c.clone());
        }
        return elem;
    }

    protected T fromXml(Element elem) throws SpimDataException {
        T entity;
        try {
            entity = this.ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SpimDataInstantiationException("Cannot instantiate " + this.ctor.getDeclaringClass().getName(), e);
        }
        this.unhandledContent.clear();
        for (Element c : elem.getChildren()) {
            if (this.handledTags.contains(c.getName())) continue;
            this.unhandledContent.add(c.clone());
        }
        return entity;
    }
}

