/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mpicbg.spim.data.SpimDataInstantiationException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;

public class ImgLoaders {
    private static final Map<Class<? extends BasicImgLoader>, String> imgLoaderClass_to_XmlIoClassName = new ConcurrentHashMap<Class<? extends BasicImgLoader>, String>();
    private static final Map<String, String> format_to_XmlIoClassName = new ConcurrentHashMap<String, String>();
    private static boolean buildWasCalled = false;

    private static synchronized void build() {
        if (!buildWasCalled) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Index annotationIndex = Index.load(ImgLoaderIo.class, (ClassLoader)classLoader);
                for (IndexItem item : annotationIndex) {
                    format_to_XmlIoClassName.put(((ImgLoaderIo)item.annotation()).format(), item.className());
                    imgLoaderClass_to_XmlIoClassName.put(((ImgLoaderIo)item.annotation()).type(), item.className());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("problem accessing annotation index", e);
            }
            buildWasCalled = true;
        }
    }

    public static XmlIoBasicImgLoader<?> createXmlIoForFormat(String format) throws SpimDataInstantiationException {
        String className;
        if (!buildWasCalled) {
            ImgLoaders.build();
        }
        if ((className = format_to_XmlIoClassName.get(format)) == null) {
            throw new SpimDataInstantiationException("could not find " + XmlIoBasicImgLoader.class.getSimpleName() + " implementation for format " + format);
        }
        try {
            return (XmlIoBasicImgLoader)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new SpimDataInstantiationException("could not create " + XmlIoBasicImgLoader.class.getSimpleName() + " instance " + className, e);
        }
    }

    public static <T extends BasicImgLoader> XmlIoBasicImgLoader<T> createXmlIoForImgLoaderClass(Class<T> klass) throws SpimDataInstantiationException {
        String className;
        if (!buildWasCalled) {
            ImgLoaders.build();
        }
        if ((className = imgLoaderClass_to_XmlIoClassName.get(klass)) == null) {
            throw new SpimDataInstantiationException("could not find " + XmlIoBasicImgLoader.class.getSimpleName() + " implementation for " + klass.getSimpleName());
        }
        try {
            return (XmlIoBasicImgLoader)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new SpimDataInstantiationException("could not create " + XmlIoBasicImgLoader.class.getSimpleName() + " instance " + className, e);
        }
    }

    public static void registerManually(Class<? extends XmlIoBasicImgLoader<?>> xmlIoClass) {
        ImgLoaderIo annotation = xmlIoClass.getAnnotation(ImgLoaderIo.class);
        if (annotation != null) {
            String format = annotation.format();
            Class<? extends BasicImgLoader> imgLoaderClass = annotation.type();
            imgLoaderClass_to_XmlIoClassName.put(imgLoaderClass, xmlIoClass.getName());
            format_to_XmlIoClassName.put(format, xmlIoClass.getName());
        }
    }
}

