/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.base.ViewSetupAttributeIo;
import mpicbg.spim.data.generic.base.XmlIoNamedEntity;
import mpicbg.spim.data.sequence.Angle;
import org.jdom2.Content;
import org.jdom2.Element;

@ViewSetupAttributeIo(name="angle", type=Angle.class)
public class XmlIoAngle
extends XmlIoNamedEntity<Angle> {
    public XmlIoAngle() {
        super("Angle", Angle.class);
        this.handledTags.add("axis");
        this.handledTags.add("degrees");
    }

    @Override
    public Element toXml(Angle angle) {
        Element elem = super.toXml(angle);
        if (angle.hasRotation()) {
            elem.addContent((Content)XmlHelpers.doubleArrayElement("axis", angle.getRotationAxis()));
            elem.addContent((Content)XmlHelpers.doubleElement("degrees", angle.getRotationAngleDegrees()));
        }
        return elem;
    }

    @Override
    public Angle fromXml(Element elem) throws SpimDataException {
        Angle angle = (Angle)super.fromXml(elem);
        double[] axis = XmlHelpers.getDoubleArray(elem, "axis", null);
        double degrees = XmlHelpers.getDouble(elem, "degrees", Double.NaN);
        angle.setRotation(axis, degrees);
        return angle;
    }
}

