/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.IndexColorModel;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Tuple3f;

public class ColorTable {
    public static String[] colorNames = new String[]{"None", "Black", "White", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow"};
    public static Color3f[] colors = new Color3f[]{null, new Color3f(0.0f, 0.0f, 0.0f), new Color3f(1.0f, 1.0f, 1.0f), new Color3f(1.0f, 0.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 1.0f, 1.0f), new Color3f(1.0f, 0.0f, 1.0f), new Color3f(1.0f, 1.0f, 0.0f)};

    public static Color3f getColor(String name) {
        for (int i = 0; i < colors.length; ++i) {
            if (!colorNames[i].equals(name)) continue;
            return colors[i];
        }
        return null;
    }

    public static boolean isRedCh(String color) {
        return color.equals("White") || color.equals("Red") || color.equals("Magenta") || color.equals("Yellow");
    }

    public static boolean isGreenCh(String color) {
        return color.equals("White") || color.equals("Green") || color.equals("Cyan") || color.equals("Yellow");
    }

    public static boolean isBlueCh(String color) {
        return color.equals("White") || color.equals("Blue") || color.equals("Cyan") || color.equals("Magenta");
    }

    public static String getColorName(Color3f col) {
        for (int i = 1; i < colors.length; ++i) {
            if (!colors[i].equals((Tuple3f)col)) continue;
            return colorNames[i];
        }
        return "None";
    }

    public static int getHistogramMax(ImagePlus imp) {
        int j;
        int d = imp.getStackSize();
        int[] hist = new int[256];
        for (int i = 0; i < d; ++i) {
            int[] h = imp.getStack().getProcessor(i + 1).getHistogram();
            for (j = 0; j < hist.length; ++j) {
                int n = j;
                hist[n] = hist[n] + h[j];
            }
        }
        int max = -1;
        int maxIndex = -1;
        for (j = 0; j < hist.length; ++j) {
            if (hist[j] <= max) continue;
            max = hist[j];
            maxIndex = j;
        }
        return maxIndex;
    }

    public static IndexColorModel getOpaqueIndexedColorModel(ImagePlus imp, boolean[] ch) {
        IndexColorModel cmodel = (IndexColorModel)imp.getProcessor().getColorModel();
        int N = cmodel.getMapSize();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        for (int i = 0; i < N; ++i) {
            r[i] = ch[0] ? r[i] : (byte)0;
            g[i] = ch[1] ? g[i] : (byte)0;
            b[i] = ch[2] ? b[i] : (byte)0;
        }
        IndexColorModel c = new IndexColorModel(8, N, r, g, b);
        return c;
    }

    public static IndexColorModel getIndexedColorModel(ImagePlus imp, boolean[] ch) {
        IndexColorModel cmodel = (IndexColorModel)imp.getProcessor().getColorModel();
        int N = cmodel.getMapSize();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        byte[] a = new byte[N];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        int histoMax = ColorTable.getHistogramMax(imp);
        int[] sumInt = new int[N];
        int maxInt = 0;
        for (int i = 0; i < N; ++i) {
            sumInt[i] = 0;
            if (ch[0]) {
                int n = i;
                sumInt[n] = sumInt[n] + (r[i] & 0xFF);
            }
            if (ch[1]) {
                int n = i;
                sumInt[n] = sumInt[n] + (g[i] & 0xFF);
            }
            if (ch[2]) {
                int n = i;
                sumInt[n] = sumInt[n] + (b[i] & 0xFF);
            }
            maxInt = sumInt[i] > maxInt ? sumInt[i] : maxInt;
        }
        float scale = 255.0f / (float)maxInt;
        for (int i = 0; i < N; ++i) {
            byte meanInt = (byte)(scale * (float)sumInt[i]);
            r[i] = ch[0] ? r[i] : (byte)0;
            g[i] = ch[1] ? g[i] : (byte)0;
            b[i] = ch[2] ? b[i] : (byte)0;
            a[i] = meanInt;
        }
        a[histoMax] = 0;
        IndexColorModel c = new IndexColorModel(8, N, r, g, b, a);
        return c;
    }

    public static IndexColorModel getOpaqueAverageGrayColorModel(ImagePlus imp, boolean[] ch) {
        IndexColorModel cmodel = (IndexColorModel)imp.getProcessor().getColorModel();
        int N = cmodel.getMapSize();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        byte[] a = new byte[N];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        int[] sumInt = new int[N];
        int maxInt = 0;
        for (int i = 0; i < N; ++i) {
            sumInt[i] = 0;
            if (ch[0]) {
                int n = i;
                sumInt[n] = sumInt[n] + (r[i] & 0xFF);
            }
            if (ch[1]) {
                int n = i;
                sumInt[n] = sumInt[n] + (g[i] & 0xFF);
            }
            if (ch[2]) {
                int n = i;
                sumInt[n] = sumInt[n] + (b[i] & 0xFF);
            }
            maxInt = sumInt[i] > maxInt ? sumInt[i] : maxInt;
        }
        float scale = 255.0f / (float)maxInt;
        for (int i = 0; i < N; ++i) {
            byte meanInt = (byte)(scale * (float)sumInt[i]);
            float colFac = (float)sumInt[i] / (float)maxInt;
            r[i] = meanInt;
            g[i] = meanInt;
            b[i] = meanInt;
        }
        IndexColorModel c = new IndexColorModel(8, N, r, g, b);
        return c;
    }

    public static IndexColorModel getAverageGrayColorModel(ImagePlus imp, boolean[] ch) {
        IndexColorModel cmodel = (IndexColorModel)imp.getProcessor().getColorModel();
        int N = cmodel.getMapSize();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        byte[] a = new byte[N];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        int histoMax = ColorTable.getHistogramMax(imp);
        int[] sumInt = new int[N];
        int maxInt = 0;
        for (int i = 0; i < N; ++i) {
            sumInt[i] = 0;
            if (ch[0]) {
                int n = i;
                sumInt[n] = sumInt[n] + (r[i] & 0xFF);
            }
            if (ch[1]) {
                int n = i;
                sumInt[n] = sumInt[n] + (g[i] & 0xFF);
            }
            if (ch[2]) {
                int n = i;
                sumInt[n] = sumInt[n] + (b[i] & 0xFF);
            }
            maxInt = sumInt[i] > maxInt ? sumInt[i] : maxInt;
        }
        float scale = 255.0f / (float)maxInt;
        for (int i = 0; i < N; ++i) {
            byte meanInt = (byte)(scale * (float)sumInt[i]);
            float colFac = (float)sumInt[i] / (float)maxInt;
            r[i] = meanInt;
            g[i] = meanInt;
            b[i] = meanInt;
            a[i] = meanInt;
        }
        a[histoMax] = 0;
        IndexColorModel c = new IndexColorModel(8, N, r, g, b, a);
        return c;
    }

    public static ImagePlus adjustChannels(ImagePlus imp, boolean[] ch) {
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        int[] weight = new int[3];
        IndexColorModel cmodel = (IndexColorModel)imp.getProcessor().getColorModel();
        int N = cmodel.getMapSize();
        byte[] r = new byte[N];
        byte[] g = new byte[N];
        byte[] b = new byte[N];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        float sum = 0.0f;
        for (int i = 0; i < 3; ++i) {
            if (!ch[i]) continue;
            weight[i] = 1;
            sum += 1.0f;
        }
        ImageStack res = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            byte[] bytes = (byte[])imp.getStack().getProcessor(z + 1).getPixels();
            byte[] newB = new byte[w * h];
            for (int i = 0; i < w * h; ++i) {
                int index = bytes[i] & 0xFF;
                int value = weight[0] * (r[index] & 0xFF) + weight[1] * (g[index] & 0xFF) + weight[2] * (b[index] & 0xFF);
                newB[i] = (byte)((float)value / sum);
            }
            res.addSlice("", (ImageProcessor)new ByteProcessor(w, h, newB, null));
        }
        ImagePlus newImage = new ImagePlus(imp.getTitle(), res);
        newImage.setCalibration(imp.getCalibration());
        return newImage;
    }

    public static void debug(IndexColorModel cmodel) {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        cmodel.getReds(r);
        cmodel.getGreens(g);
        cmodel.getBlues(b);
        for (int i = 0; i < 256; ++i) {
            System.out.println((r[i] & 0xFF) + "\t" + (g[i] & 0xFF) + "\t" + (b[i] & 0xFF));
        }
    }
}

