/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import customnode.CustomTriangleMesh;
import customnode.u3d.U3DExporter;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import ij3d.ColorTable;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.RegistrationMenubar;
import ij3d.UniverseSettings;
import ij3d.Utils;
import ij3d.gui.ContentCreatorDialog;
import ij3d.gui.InteractiveMeshDecimation;
import ij3d.gui.InteractiveTransformDialog;
import ij3d.gui.LUTDialog;
import ij3d.gui.PrimitiveDialogs;
import ij3d.shapes.Scalebar;
import ij3d.shortcuts.ShortCutDialog;
import isosurface.MeshEditor;
import isosurface.MeshExporter;
import isosurface.MeshGroup;
import isosurface.SmoothControl;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFileChooser;
import math3d.TransformIO;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.PointLight;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3f;
import orthoslice.MultiOrthoGroup;
import orthoslice.OrthoGroup;
import vib.FastMatrix;
import voltex.VoltexGroup;

public class Executer {
    public static final String START_ANIMATE = "startAnimate";
    public static final String STOP_ANIMATE = "stopAnimate";
    public static final String START_FREEHAND_RECORDING = "startFreehandRecording";
    public static final String STOP_FREEHAND_RECORDING = "stopFreehandRecording";
    public static final String RECORD_360 = "record360";
    public static final String RESET_VIEW = "resetView";
    public static final String SCALEBAR = "scalebar";
    public static final String CLOSE = "close";
    public static final String WINDOW_SIZE = "windowSize";
    public static final String SET_COLOR = "setColor";
    public static final String SET_TRANSPARENCY = "setTransparency";
    public static final String SET_CHANNELS = "setChannels";
    public static final String FILL_SELECTION = "fillSelection";
    public static final String SET_SLICES = "setSlices";
    public static final String LOCK = "lock";
    public static final String UNLOCK = "unlock";
    public static final String SET_THRESHOLD = "setThreshold";
    public static final String SET_CS = "setCoordinateSystem";
    public static final String SET_TRANSFORM = "setTransform";
    public static final String APPLY_TRANSFORM = "applyTransform";
    public static final String EXPORT_TRANSFORMED = "exportTransformed";
    public static final String SAVE_TRANSFORM = "saveTransform";
    public static final String RESET_TRANSFORM = "resetTransform";
    public static final String IMPORT = "importContent";
    public static final String EXPORT = "exportContent";
    public static final String SNAPSHOT = "snapshot";
    public static final String SHOW_CONTENT = "showContent";
    public static final String ADD_SPHERE = "addSphere";
    public static final String ADD_BOX = "addBox";
    public static final String ADD_CONE = "addCone";
    public static final String ADD_TUBE_POINT = "addTubePoint";
    public static final String FINISH_TUBE = "finishTube";
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String SMOOTH = "smooth";
    private final Image3DUniverse univ;
    ExecutorService exec = Executors.newSingleThreadExecutor();

    public Executer(Image3DUniverse univ) {
        this.univ = univ;
    }

    public void addContentFromFile() {
        JFileChooser chooser = new JFileChooser(OpenDialog.getLastDirectory());
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        OpenDialog.setLastDirectory((String)f.getParentFile().getAbsolutePath());
        this.addContent(null, f);
    }

    public void addContentFromImage(ImagePlus image) {
        this.addContent(image, null);
    }

    public void addTimelapseFromFile() {
        this.addContentFromFile();
    }

    public void addTimelapseFromFolder() {
        DirectoryChooser dc = new DirectoryChooser("Open from folder");
        String dir = dc.getDirectory();
        if (dir == null) {
            return;
        }
        File d = new File(dir);
        if (d.exists()) {
            this.addContent(null, d);
        } else {
            IJ.error((String)("Cannot load " + d.getAbsolutePath()));
        }
    }

    public void addTimelapseFromHyperstack(ImagePlus image) {
        this.addContentFromImage(image);
    }

    public void addContent(final ImagePlus image, final File file) {
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                Executer.this.addC(image, file);
            }
        }.start();
    }

    private Content addC(ImagePlus image, File file) {
        ContentCreatorDialog gui = new ContentCreatorDialog();
        Content c = gui.showDialog(this.univ, image, file);
        if (c == null) {
            return null;
        }
        this.univ.addContent(c);
        String title = gui.getFile() != null ? gui.getFile().getAbsolutePath() : gui.getImage().getTitle();
        boolean[] channels = gui.getChannels();
        String[] arg = new String[]{title, ColorTable.getColorName(gui.getColor()), gui.getName(), Integer.toString(gui.getThreshold()), Boolean.toString(channels[0]), Boolean.toString(channels[1]), Boolean.toString(channels[2]), Integer.toString(gui.getResamplingFactor()), Integer.toString(gui.getType())};
        Executer.record(ADD, arg);
        return c;
    }

    public void delete(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        this.univ.removeContent(c.getName());
        Executer.record(DELETE, new String[0]);
    }

    protected void importFile(String dialogTitle, String extension, String formatDescription) {
        Collection<Future<Content>> ob;
        OpenDialog od = new OpenDialog(dialogTitle, OpenDialog.getDefaultDirectory(), null);
        String filename = od.getFileName();
        if (null == filename) {
            return;
        }
        if (!filename.toLowerCase().endsWith(extension)) {
            IJ.showMessage((String)("Must select a " + formatDescription + " file!"));
            return;
        }
        String path = od.getDirectory() + filename;
        IJ.log((String)("path: " + path));
        try {
            ob = this.univ.addContentLater(path);
            Executer.record(IMPORT, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            ob = null;
        }
        if (null == ob) {
            IJ.showMessage((String)("Could not load the file:\n" + path));
        }
    }

    public void importWaveFront() {
        this.importFile("Select .obj file", ".obj", "wavefront .ob");
    }

    public void importSTL() {
        this.importFile("Select .stl file", ".stl", "STL");
    }

    public void saveAsDXF() {
        File dxf_file = Executer.promptForFile("Save as DXF", "untitled", ".dxf");
        if (dxf_file == null) {
            return;
        }
        MeshExporter.saveAsDXF(this.univ.getContents(), dxf_file);
        Executer.record(EXPORT, "DXF", dxf_file.getAbsolutePath());
    }

    public void saveAsWaveFront() {
        File obj_file = Executer.promptForFile("Save WaveFront", "untitled", ".obj");
        if (obj_file == null) {
            return;
        }
        MeshExporter.saveAsWaveFront(this.univ.getContents(), obj_file);
        Executer.record(EXPORT, "WaveFront", obj_file.getAbsolutePath());
    }

    public void saveAsAsciiSTL() {
        File stl_file = Executer.promptForFile("Save as STL (ASCII)", "untitled", ".stl");
        if (stl_file == null) {
            return;
        }
        MeshExporter.saveAsSTL(this.univ.getContents(), stl_file, 0);
        Executer.record(EXPORT, "STL ASCII", stl_file.getAbsolutePath());
    }

    public void saveAsBinarySTL() {
        File stl_file = Executer.promptForFile("Save as STL (binary)", "untitled", ".stl");
        if (stl_file == null) {
            return;
        }
        MeshExporter.saveAsSTL(this.univ.getContents(), stl_file, 1);
        Executer.record(EXPORT, "STL Binary", stl_file.getAbsolutePath());
    }

    public static File promptForFile(String title, String suggestion, String ending) {
        YesNoCancelDialog yn;
        SaveDialog sd = new SaveDialog(title, suggestion, ending);
        String dir = sd.getDirectory();
        if (null == dir) {
            return null;
        }
        String filename = sd.getFileName();
        if (!filename.toLowerCase().endsWith(ending)) {
            filename = filename + ending;
        }
        File file = new File(dir, filename);
        if (!IJ.isMacOSX() && file.exists() && !(yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File  " + filename + " exists!\nOverwrite?")).yesPressed()) {
            return null;
        }
        return file;
    }

    public void saveAsU3D() {
        SaveDialog sd = new SaveDialog("Save meshes as u3d...", "", ".u3d");
        String dir = sd.getDirectory();
        String name = sd.getFileName();
        if (dir == null || name == null) {
            return;
        }
        try {
            U3DExporter.export(this.univ, dir + name);
            String tex = U3DExporter.getTexStub(this.univ, dir + name);
            IJ.log((String)"% Here are a few latex example lines");
            IJ.log((String)"% You can compile them for example via");
            IJ.log((String)"% pdflatex yourfilename.tex");
            IJ.log((String)"");
            IJ.log((String)tex);
            Executer.record(EXPORT, "U3D", dir + name);
        }
        catch (Exception e) {
            IJ.error((String)e.getMessage());
        }
    }

    public void loadView() {
        OpenDialog sd = new OpenDialog("Open view...", "", ".view");
        String dir = sd.getDirectory();
        String name = sd.getFileName();
        if (dir == null || name == null) {
            return;
        }
        try {
            this.univ.loadView(dir + name);
        }
        catch (Exception e) {
            IJ.error((String)e.getMessage());
        }
    }

    public void saveView() {
        SaveDialog sd = new SaveDialog("Save view...", "", ".view");
        String dir = sd.getDirectory();
        String name = sd.getFileName();
        if (dir == null || name == null) {
            return;
        }
        try {
            this.univ.saveView(dir + name);
        }
        catch (Exception e) {
            IJ.error((String)e.getMessage());
        }
    }

    public void loadSession() {
        OpenDialog sd = new OpenDialog("Open session...", "session", ".scene");
        final String dir = sd.getDirectory();
        final String name = sd.getFileName();
        if (dir == null || name == null) {
            return;
        }
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                try {
                    Executer.this.univ.loadSession(dir + name);
                }
                catch (Exception e) {
                    IJ.error((String)e.getMessage());
                }
            }
        }.start();
    }

    public void saveSession() {
        SaveDialog sd = new SaveDialog("Save session...", "session", ".scene");
        String dir = sd.getDirectory();
        String name = sd.getFileName();
        if (dir == null || name == null) {
            return;
        }
        try {
            this.univ.saveSession(dir + name);
        }
        catch (Exception e) {
            IJ.error((String)e.getMessage());
        }
    }

    public void close() {
        this.univ.close();
        Executer.record(CLOSE, new String[0]);
    }

    public void updateVolume(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        if (c.getType() != 0 && c.getType() != 1) {
            return;
        }
        if (c.getResamplingFactor() != 1) {
            IJ.error((String)"Object must be loaded with resamplingfactor 1");
            return;
        }
        ((VoltexGroup)c.getContent()).update();
    }

    public void changeSlices(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        switch (c.getType()) {
            case 1: {
                this.changeOrthslices(c);
                break;
            }
            case 4: {
                this.changeMultiOrthslices(c);
            }
        }
    }

    private void changeMultiOrthslices(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        GenericDialog gd = new GenericDialog("Adjust slices...", (Frame)this.univ.getWindow());
        MultiOrthoGroup os = (MultiOrthoGroup)c.getContent();
        boolean opaque = os.getTexturesOpaque();
        gd.addMessage("Number of slices {x: " + os.getSliceCount(0) + ", y: " + os.getSliceCount(1) + ", z: " + os.getSliceCount(2) + "}");
        gd.addStringField("x_slices (e.g. 1, 2-5, 20)", "", 10);
        gd.addStringField("y_slices (e.g. 1, 2-5, 20)", "", 10);
        gd.addStringField("z_slices (e.g. 1, 2-5, 20)", "", 10);
        gd.addCheckbox("Opaque textures", opaque);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean X = false;
        boolean Y = true;
        int Z = 2;
        boolean[] xAxis = new boolean[os.getSliceCount(0)];
        boolean[] yAxis = new boolean[os.getSliceCount(1)];
        boolean[] zAxis = new boolean[os.getSliceCount(2)];
        Executer.parseRange(gd.getNextString(), xAxis);
        Executer.parseRange(gd.getNextString(), yAxis);
        Executer.parseRange(gd.getNextString(), zAxis);
        os.setVisible(0, xAxis);
        os.setVisible(1, yAxis);
        os.setVisible(2, zAxis);
        os.setTexturesOpaque(gd.getNextBoolean());
    }

    private static void parseRange(String rangeString, boolean[] b) {
        Arrays.fill(b, false);
        if (rangeString.trim().length() == 0) {
            return;
        }
        try {
            String[] tokens1;
            for (String tok1 : tokens1 = rangeString.split(",")) {
                String[] tokens2 = tok1.split("-");
                if (tokens2.length == 1) {
                    b[Integer.parseInt((String)tokens2[0].trim())] = true;
                    continue;
                }
                int start = Integer.parseInt(tokens2[0].trim());
                int end = Integer.parseInt(tokens2[1].trim());
                for (int i = start; i <= end; ++i) {
                    if (i < 0 || i >= b.length) continue;
                    b[i] = true;
                }
            }
        }
        catch (Exception e) {
            IJ.error((String)("Cannot parse " + rangeString));
            return;
        }
    }

    private void changeOrthslices(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final GenericDialog gd = new GenericDialog("Adjust slices...", (Frame)this.univ.getWindow());
        final OrthoGroup os = (OrthoGroup)c.getContent();
        final int ind1 = os.getSlice(0);
        final int ind2 = os.getSlice(1);
        final int ind3 = os.getSlice(2);
        final boolean vis1 = os.isVisible(0);
        final boolean vis2 = os.isVisible(1);
        final boolean vis3 = os.isVisible(2);
        ImagePlus imp = c.getImage();
        int w = imp.getWidth() / c.getResamplingFactor();
        int h = imp.getHeight() / c.getResamplingFactor();
        int d = imp.getStackSize() / c.getResamplingFactor();
        gd.addCheckbox("Show_yz plane", vis1);
        gd.addSlider("x coordinate", 0.0, (double)(w - 1), (double)ind1);
        gd.addCheckbox("Show_xz plane", vis2);
        gd.addSlider("y coordinate", 0.0, (double)(h - 1), (double)ind2);
        gd.addCheckbox("Show_xy plane", vis3);
        gd.addSlider("z coordinate", 0.0, (double)(d - 1), (double)ind3);
        gd.addMessage("You can use the x, y and z key plus\nthe arrow keys to adjust slices in\nx, y and z direction respectively.\n \nx, y, z + SPACE switches planes on\nand off");
        final int[] dirs = new int[]{0, 1, 2};
        final Scrollbar[] sl = new Scrollbar[3];
        final Checkbox[] cb = new Checkbox[3];
        int k = 0;
        while (k < 3) {
            final int i = k++;
            sl[i] = (Scrollbar)gd.getSliders().get(i);
            sl[i].addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    os.setSlice(dirs[i], sl[i].getValue());
                    Executer.this.univ.fireContentChanged(c);
                }
            });
            cb[i] = (Checkbox)gd.getCheckboxes().get(i);
            cb[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    os.setVisible(dirs[i], cb[i].getState());
                }
            });
        }
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (gd.wasCanceled()) {
                    os.setSlice(0, ind1);
                    os.setSlice(1, ind2);
                    os.setSlice(2, ind3);
                    os.setVisible(0, vis1);
                    os.setVisible(1, vis2);
                    os.setVisible(2, vis3);
                    Executer.this.univ.fireContentChanged(c);
                    return;
                }
                Executer.record(Executer.SET_SLICES, Integer.toString(sl[0].getValue()), Integer.toString(sl[1].getValue()), Integer.toString(sl[2].getValue()));
            }
        });
        gd.showDialog();
    }

    public void fill(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        int type = c.getType();
        if (type != 0 && type != 1) {
            return;
        }
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                ImageCanvas3D canvas = (ImageCanvas3D)Executer.this.univ.getCanvas();
                ((VoltexGroup)c.getContent()).fillRoi(canvas, canvas.getRoi(), (byte)0);
                Executer.this.univ.fireContentChanged(c);
                Executer.record(Executer.FILL_SELECTION, new String[0]);
            }
        }.start();
    }

    public void smoothMesh(Content c) {
        CustomMesh mesh;
        if (!this.checkSel(c)) {
            return;
        }
        ContentNode cn = c.getContent();
        if (cn instanceof CustomMultiMesh) {
            CustomMultiMesh multi = (CustomMultiMesh)cn;
            for (int i = 0; i < multi.size(); ++i) {
                CustomMesh m = multi.getMesh(i);
                if (!(m instanceof CustomTriangleMesh)) continue;
                MeshEditor.smooth2((CustomTriangleMesh)m, 1);
            }
        } else if (cn instanceof CustomMeshNode && (mesh = ((CustomMeshNode)cn).getMesh()) instanceof CustomTriangleMesh) {
            MeshEditor.smooth2((CustomTriangleMesh)mesh, 1);
        }
    }

    public void smoothAllMeshes() {
        Collection all = this.univ.getContents();
        final Content[] c = new Content[all.size()];
        all.toArray(c);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] thread = new Thread[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < thread.length; ++i) {
            thread[i] = new Thread(){
                {
                    this.setPriority(5);
                }

                @Override
                public void run() {
                    try {
                        int k = ai.getAndIncrement();
                        while (k < c.length) {
                            Executer.this.smoothMesh(c[k]);
                            k = ai.getAndIncrement();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread[i].start();
        }
    }

    public void smoothControl() {
        new SmoothControl(this.univ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decimateMesh() {
        CustomTriangleMesh ctm;
        Content c = this.univ.getSelected();
        if (c == null) {
            return;
        }
        ContentNode n = c.getContent();
        if (n instanceof CustomMeshNode) {
            if (!(((CustomMeshNode)n).getMesh() instanceof CustomTriangleMesh)) return;
            ctm = (CustomTriangleMesh)((CustomMeshNode)n).getMesh();
        } else {
            if (!(n instanceof MeshGroup)) return;
            ctm = ((MeshGroup)n).getMesh();
        }
        new InteractiveMeshDecimation().run(ctm);
    }

    public void displayAs(Content c, int type) {
        if (!this.checkSel(c)) {
            return;
        }
        c.displayAs(type);
    }

    protected void showColorDialog(String title, final Color3f oldC, final ColorListener colorListener, boolean showDefaultCheckbox, boolean showTimepointsCheckbox) {
        final GenericDialog gd = new GenericDialog(title, (Frame)this.univ.getWindow());
        if (showDefaultCheckbox) {
            gd.addCheckbox("Use default color", oldC == null);
        }
        gd.addSlider("Red", 0.0, 255.0, oldC == null ? 255.0 : (double)(oldC.x * 255.0f));
        gd.addSlider("Green", 0.0, 255.0, oldC == null ? 0.0 : (double)(oldC.y * 255.0f));
        gd.addSlider("Blue", 0.0, 255.0, oldC == null ? 0.0 : (double)(oldC.z * 255.0f));
        if (showTimepointsCheckbox) {
            gd.addCheckbox("Apply to all timepoints", true);
        }
        final Scrollbar rSlider = (Scrollbar)gd.getSliders().get(0);
        final Scrollbar gSlider = (Scrollbar)gd.getSliders().get(1);
        final Scrollbar bSlider = (Scrollbar)gd.getSliders().get(2);
        rSlider.setEnabled(oldC != null);
        gSlider.setEnabled(oldC != null);
        bSlider.setEnabled(oldC != null);
        if (showDefaultCheckbox) {
            final Checkbox cBox = (Checkbox)gd.getCheckboxes().get(0);
            cBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    gd.setCursor(new Cursor(3));
                    rSlider.setEnabled(!cBox.getState());
                    gSlider.setEnabled(!cBox.getState());
                    bSlider.setEnabled(!cBox.getState());
                    colorListener.colorChanged(new Color3f((float)rSlider.getValue() / 255.0f, (float)gSlider.getValue() / 255.0f, (float)bSlider.getValue() / 255.0f));
                    gd.setCursor(new Cursor(0));
                }
            });
        }
        AdjustmentListener listener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                colorListener.colorChanged(new Color3f((float)rSlider.getValue() / 255.0f, (float)gSlider.getValue() / 255.0f, (float)bSlider.getValue() / 255.0f));
            }
        };
        rSlider.addAdjustmentListener(listener);
        gSlider.addAdjustmentListener(listener);
        bSlider.addAdjustmentListener(listener);
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (gd.wasCanceled()) {
                    colorListener.colorChanged(oldC);
                } else {
                    gd.setCursor(new Cursor(3));
                    colorListener.ok(gd);
                    gd.setCursor(new Cursor(0));
                }
            }
        });
        gd.showDialog();
    }

    public void changeColor(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final ContentInstant ci = c.getCurrent();
        Color3f oldC = ci.getColor();
        ColorListener colorListener = new ColorListener(){

            @Override
            public void colorChanged(Color3f color) {
                ci.setColor(color);
                Executer.this.univ.fireContentChanged(c);
            }

            @Override
            public void ok(GenericDialog gd) {
                if (gd.getNextBoolean()) {
                    Executer.record(Executer.SET_COLOR, "null", "null", "null");
                } else {
                    Executer.record(Executer.SET_COLOR, "" + (int)gd.getNextNumber(), "" + (int)gd.getNextNumber(), "" + (int)gd.getNextNumber());
                }
                if (gd.getNextBoolean()) {
                    c.setColor(ci.getColor());
                }
                Executer.this.univ.fireContentChanged(c);
            }
        };
        this.showColorDialog("Change color...", oldC, colorListener, true, true);
    }

    public void changeBackgroundColor() {
        final Background background = ((ImageCanvas3D)this.univ.getCanvas()).getBG();
        final Label status = this.univ.getWindow().getStatusLabel();
        Color3f oldC = new Color3f();
        background.getColor(oldC);
        ColorListener colorListener = new ColorListener(){

            @Override
            public void colorChanged(Color3f color) {
                background.setColor(color);
                status.setBackground(Utils.toColor(color));
                ((ImageCanvas3D)Executer.this.univ.getCanvas()).render();
            }

            @Override
            public void ok(GenericDialog gd) {
            }
        };
        this.showColorDialog("Adjust background color ...", oldC, colorListener, false, false);
    }

    public void changePointColor(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final ContentInstant ci = c.getCurrent();
        Color3f oldC = ci.getLandmarkColor();
        ColorListener colorListener = new ColorListener(){

            @Override
            public void colorChanged(Color3f color) {
                ci.setLandmarkColor(color);
                Executer.this.univ.fireContentChanged(c);
            }

            @Override
            public void ok(GenericDialog gd) {
                if (gd.getNextBoolean()) {
                    c.setLandmarkColor(ci.getLandmarkColor());
                }
                Executer.this.univ.fireContentChanged(c);
            }
        };
        this.showColorDialog("Change point color...", oldC, colorListener, false, true);
    }

    public void adjustLUTs(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final int[] r = new int[256];
        c.getRedLUT(r);
        final int[] g = new int[256];
        c.getGreenLUT(g);
        final int[] b = new int[256];
        c.getBlueLUT(b);
        final int[] a = new int[256];
        c.getAlphaLUT(a);
        LUTDialog ld = new LUTDialog(r, g, b, a);
        ld.addCtrlHint();
        ld.addListener(new LUTDialog.Listener(){

            @Override
            public void applied() {
                c.setLUT(r, g, b, a);
                Executer.this.univ.fireContentChanged(c);
            }
        });
        ld.showDialog();
    }

    public void changeChannels(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        ContentInstant ci = c.getCurrent();
        GenericDialog gd = new GenericDialog("Adjust channels ...", (Frame)this.univ.getWindow());
        gd.addMessage("Channels");
        gd.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, ci.getChannels());
        gd.addCheckbox("Apply to all timepoints", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean[] channels = new boolean[]{gd.getNextBoolean(), gd.getNextBoolean(), gd.getNextBoolean()};
        if (gd.getNextBoolean()) {
            c.setChannels(channels);
        } else {
            ci.setChannels(channels);
        }
        this.univ.fireContentChanged(c);
        Executer.record(SET_CHANNELS, Boolean.toString(channels[0]), Boolean.toString(channels[1]), Boolean.toString(channels[2]));
    }

    public void changeTransparency(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final ContentInstant ci = c.getCurrent();
        final SliderAdjuster transp_adjuster = new SliderAdjuster(){

            @Override
            public final synchronized void setValue(ContentInstant ci, int v) {
                ci.setTransparency((float)v / 100.0f);
                this.univ.fireContentChanged(c);
            }
        };
        final GenericDialog gd = new GenericDialog("Adjust transparency ...", (Frame)this.univ.getWindow());
        final int oldTr = (int)(ci.getTransparency() * 100.0f);
        gd.addSlider("Transparency", 0.0, 100.0, (double)oldTr);
        gd.addCheckbox("Apply to all timepoints", true);
        ((Scrollbar)gd.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!transp_adjuster.go) {
                    transp_adjuster.start();
                }
                transp_adjuster.exec(e.getValue(), ci, Executer.this.univ);
            }
        });
        ((TextField)gd.getNumericFields().get(0)).addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                if (!transp_adjuster.go) {
                    transp_adjuster.start();
                }
                TextField input = (TextField)e.getSource();
                String text = input.getText();
                try {
                    int value = Integer.parseInt(text);
                    transp_adjuster.exec(value, ci, Executer.this.univ);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Checkbox aBox = (Checkbox)gd.getCheckboxes().get(0);
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (null != transp_adjuster) {
                    transp_adjuster.quit();
                }
                if (gd.wasCanceled()) {
                    float newTr = (float)oldTr / 100.0f;
                    ci.setTransparency(newTr);
                    Executer.this.univ.fireContentChanged(c);
                    return;
                }
                if (aBox.getState()) {
                    c.setTransparency(ci.getTransparency());
                }
                Executer.record(Executer.SET_TRANSPARENCY, Float.toString((float)((Scrollbar)gd.getSliders().get(0)).getValue() / 100.0f));
            }
        });
        gd.showDialog();
    }

    public void changeThreshold(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        if (c.getImage() == null) {
            IJ.error((String)"The selected object contains no image data,\ntherefore the threshold can't be changed");
            return;
        }
        final ContentInstant ci = c.getCurrent();
        final SliderAdjuster thresh_adjuster = new SliderAdjuster(){

            @Override
            public final synchronized void setValue(ContentInstant ci, int v) {
                ci.setThreshold(v);
                this.univ.fireContentChanged(c);
            }
        };
        final int oldTr = ci.getThreshold();
        if (c.getType() == 2) {
            GenericDialog gd = new GenericDialog("Adjust threshold ...", (Frame)this.univ.getWindow());
            int old = ci.getThreshold();
            gd.addNumericField("Threshold", (double)old, 0);
            gd.addCheckbox("Apply to all timepoints", true);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int th = (int)gd.getNextNumber();
            th = Math.max(0, th);
            th = Math.min(th, 255);
            if (gd.getNextBoolean()) {
                c.setThreshold(th);
            } else {
                ci.setThreshold(th);
            }
            this.univ.fireContentChanged(c);
            Executer.record(SET_THRESHOLD, Integer.toString(th));
            return;
        }
        final GenericDialog gd = new GenericDialog("Adjust threshold...");
        gd.addSlider("Threshold", 0.0, 255.0, (double)oldTr);
        ((Scrollbar)gd.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!thresh_adjuster.go) {
                    thresh_adjuster.start();
                }
                thresh_adjuster.exec(e.getValue(), ci, Executer.this.univ);
            }
        });
        gd.addCheckbox("Apply to all timepoints", true);
        final Checkbox aBox = (Checkbox)gd.getCheckboxes().get(0);
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    if (gd.wasCanceled()) {
                        ci.setThreshold(oldTr);
                        Executer.this.univ.fireContentChanged(c);
                        return;
                    }
                    if (aBox.getState()) {
                        c.setThreshold(ci.getThreshold());
                    }
                    Executer.record(Executer.SET_THRESHOLD, Integer.toString(c.getThreshold()));
                }
                finally {
                    if (null != thresh_adjuster) {
                        thresh_adjuster.quit();
                    }
                }
            }
        });
        gd.showDialog();
    }

    public void setSaturatedVolumeRendering(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        int t = c.getType();
        if (t != 0) {
            return;
        }
        if (c.getNumberOfInstants() == 1) {
            c.setSaturatedVolumeRendering(b);
            return;
        }
        ContentInstant ci = c.getCurrent();
        GenericDialog gd = new GenericDialog("Saturated volume rendering");
        gd.addCheckbox("Apply to all timepoints", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.getNextBoolean()) {
            c.setSaturatedVolumeRendering(b);
        } else {
            ci.setSaturatedVolumeRendering(b);
        }
    }

    public void setShaded(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        int t = c.getType();
        if (t != 2 && t != 3 && t != 5) {
            return;
        }
        if (c.getNumberOfInstants() == 1) {
            c.setShaded(b);
            return;
        }
        ContentInstant ci = c.getCurrent();
        GenericDialog gd = new GenericDialog("Set shaded");
        gd.addCheckbox("Apply to all timepoints", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.getNextBoolean()) {
            c.setShaded(b);
        } else {
            ci.setShaded(b);
        }
    }

    public void applySurfaceColors(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        int t = c.getType();
        if (t != 2 && t != 5) {
            return;
        }
        GenericDialog gd = new GenericDialog("Apply color from image");
        int[] ids = WindowManager.getIDList();
        String[] titles = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        gd.addChoice("Color image", titles, titles[0]);
        gd.addCheckbox("Apply to all timepoints", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImagePlus colorImage = WindowManager.getImage((String)gd.getNextChoice());
        if (gd.getNextBoolean()) {
            c.applySurfaceColors(colorImage);
        } else if (c.getCurrent() != null) {
            c.getCurrent().applySurfaceColors(colorImage);
        }
    }

    public void showCoordinateSystem(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        c.showCoordinateSystem(b);
        Executer.record(SET_CS, Boolean.toString(b));
    }

    public void showBoundingBox(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        c.showBoundingBox(b);
    }

    public void showContent(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        c.setVisible(b);
        Executer.record(SHOW_CONTENT, c.getName(), "" + b);
        if (!b) {
            this.univ.clearSelection();
        }
    }

    public void showAllCoordinateSystems(boolean b) {
        Iterator it = this.univ.contents();
        while (it.hasNext()) {
            ((Content)it.next()).showCoordinateSystem(b);
        }
    }

    public void loadPointList(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        c.loadPointList();
    }

    public void savePointList(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        c.savePointList();
    }

    public void changePointSize(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        final GenericDialog gd = new GenericDialog("Point size", (Frame)this.univ.getWindow());
        final float oldS = c.getLandmarkPointSize();
        float minS = oldS / 10.0f;
        float maxS = oldS * 10.0f;
        gd.addSlider("Size", (double)minS, (double)maxS, (double)oldS);
        final TextField textField = (TextField)gd.getNumericFields().get(0);
        textField.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e2) {
                try {
                    c.setLandmarkPointSize(Float.parseFloat(textField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        ((Scrollbar)gd.getSliders().get(0)).addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                float newS = Float.parseFloat(textField.getText());
                c.setLandmarkPointSize(newS);
            }
        });
        gd.setModal(false);
        gd.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (gd.wasCanceled()) {
                    c.setLandmarkPointSize(oldS);
                    return;
                }
            }
        });
        gd.showDialog();
    }

    public void showPointList(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        c.showPointList(b);
    }

    public void register() {
        Collection contents = this.univ.getContents();
        if (contents.size() < 2) {
            IJ.error((String)"At least two bodies are required for registration");
            return;
        }
        RegistrationMenubar rm = this.univ.getRegistrationMenuBar();
        this.univ.setMenubar(rm);
        rm.register();
    }

    public void contentProperties(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        Point3d center = new Point3d();
        c.getContent().getMin((Tuple3d)min);
        c.getContent().getMax((Tuple3d)max);
        c.getContent().getCenter((Tuple3d)center);
        TextWindow tw = new TextWindow(c.getName(), " \tx\ty\tz", "min\t" + (float)min.x + "\t" + (float)min.y + "\t" + (float)min.z + "\nmax\t" + (float)max.x + "\t" + (float)max.y + "\t" + (float)max.z + "\ncog\t" + (float)center.x + "\t" + (float)center.y + "\t" + (float)center.z + "\n\nvolume\t" + c.getContent().getVolume(), 512, 512);
    }

    public void select(String name) {
        if (name == null) {
            this.univ.select(null);
            return;
        }
        Content c = this.univ.getContent(name);
        this.univ.select(c);
    }

    public void setLocked(Content c, boolean b) {
        if (!this.checkSel(c)) {
            return;
        }
        c.setLocked(b);
        if (b) {
            Executer.record(LOCK, new String[0]);
        } else {
            Executer.record(UNLOCK, new String[0]);
        }
    }

    public void resetTransform(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        if (c.isLocked()) {
            IJ.error((String)(c.getName() + " is locked"));
            return;
        }
        this.univ.fireTransformationStarted();
        c.setTransform(new Transform3D());
        this.univ.fireTransformationFinished();
        Executer.record(RESET_TRANSFORM, new String[0]);
    }

    public void setTransform(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        if (c.isLocked()) {
            IJ.error((String)(c.getName() + " is locked"));
            return;
        }
        final boolean useToFront = this.univ.getUseToFront();
        this.univ.setUseToFront(false);
        final Transform3D org = new Transform3D();
        c.getLocalTranslate().getTransform(org);
        Transform3D t2 = new Transform3D();
        c.getLocalRotate().getTransform(t2);
        org.mul(t2);
        Matrix4f m = new Matrix4f();
        org.get(m);
        Point3d contentCenter = new Point3d();
        c.getContent().getCenter((Tuple3d)contentCenter);
        Point3f center = new Point3f(contentCenter);
        new InteractiveTransformDialog("Set transformation", center, m){

            @Override
            public void transformationUpdated(Matrix4f mat) {
                Executer.this.univ.fireTransformationStarted();
                c.setTransform(new Transform3D(mat));
                Executer.this.univ.fireTransformationFinished();
            }

            @Override
            public void oked(Matrix4f mat) {
                Transform3D t = new Transform3D(mat);
                float[] v = new float[16];
                t.get(v);
                Executer.this.univ.setUseToFront(useToFront);
                Executer.record(Executer.SET_TRANSFORM, Executer.this.affine2string(v));
            }

            @Override
            public void canceled() {
                c.setTransform(org);
                Executer.this.univ.setUseToFront(useToFront);
            }
        };
    }

    public void applyTransform(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        if (c.isLocked()) {
            IJ.error((String)(c.getName() + " is locked"));
            return;
        }
        final boolean useToFront = this.univ.getUseToFront();
        this.univ.setUseToFront(false);
        final Transform3D org = new Transform3D();
        c.getLocalTranslate().getTransform(org);
        Transform3D t2 = new Transform3D();
        c.getLocalRotate().getTransform(t2);
        org.mul(t2);
        final Matrix4f m = new Matrix4f();
        org.get(m);
        final Matrix4f conc = new Matrix4f();
        Point3d contentCenter = new Point3d();
        c.getContent().getCenter((Tuple3d)contentCenter);
        Point3f center = new Point3f(contentCenter);
        Matrix4f init = new Matrix4f();
        init.setIdentity();
        new InteractiveTransformDialog("Set transformation", center, init){

            @Override
            public void transformationUpdated(Matrix4f mat) {
                Executer.this.univ.fireTransformationStarted();
                conc.mul(mat, m);
                c.setTransform(new Transform3D(conc));
                Executer.this.univ.fireTransformationFinished();
            }

            @Override
            public void oked(Matrix4f mat) {
                Transform3D t = new Transform3D(mat);
                float[] v = new float[16];
                t.get(v);
                Executer.this.univ.setUseToFront(useToFront);
                Executer.record(Executer.APPLY_TRANSFORM, Executer.this.affine2string(v));
            }

            @Override
            public void canceled() {
                c.setTransform(org);
                Executer.this.univ.setUseToFront(useToFront);
            }
        };
    }

    public void saveTransform(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        Transform3D t1 = new Transform3D();
        c.getLocalTranslate().getTransform(t1);
        Transform3D t2 = new Transform3D();
        c.getLocalRotate().getTransform(t2);
        t1.mul(t2);
        float[] matrix = new float[16];
        t1.get(matrix);
        if (new TransformIO().saveAffineTransform(matrix)) {
            Executer.record(SAVE_TRANSFORM, this.affine2string(matrix));
        }
    }

    public void exportTransformed(final Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                Executer.this.exportTr(c);
            }
        }.start();
    }

    private void exportTr(Content c) {
        try {
            c.exportTransformed().show();
            Executer.record(EXPORT_TRANSFORMED, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)e.getMessage());
        }
    }

    public void addTube() {
        PrimitiveDialogs.addTube(this.univ);
    }

    public void addSphere() {
        PrimitiveDialogs.addSphere(this.univ);
    }

    public void addCone() {
        PrimitiveDialogs.addCone(this.univ);
    }

    public void addBox() {
        PrimitiveDialogs.addBox(this.univ);
    }

    public void resetView() {
        this.univ.resetView();
        Executer.record(RESET_VIEW, new String[0]);
    }

    public void centerSelected(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        this.univ.centerSelected(c);
    }

    public void centerUniverse() {
        Point3d c = new Point3d();
        this.univ.getGlobalCenterPoint(c);
        this.univ.centerAt(c);
    }

    public void centerOrigin() {
        this.univ.centerAt(new Point3d());
    }

    public void fitViewToUniverse() {
        this.univ.adjustView();
    }

    public void fitViewToContent(Content c) {
        if (!this.checkSel(c)) {
            return;
        }
        this.univ.adjustView(c);
    }

    public void record360() {
        new Thread(){

            @Override
            public void run() {
                ImagePlus movie = Executer.this.univ.record360();
                if (movie != null) {
                    movie.show();
                }
                Executer.record(Executer.RECORD_360, new String[0]);
            }
        }.start();
    }

    public void startFreehandRecording() {
        this.univ.startFreehandRecording();
        Executer.record(START_FREEHAND_RECORDING, new String[0]);
    }

    public void stopFreehandRecording() {
        ImagePlus movie = this.univ.stopFreehandRecording();
        if (movie != null) {
            movie.show();
        }
        Executer.record(STOP_FREEHAND_RECORDING, new String[0]);
    }

    public void startAnimation() {
        this.univ.startAnimation();
        Executer.record(START_ANIMATE, new String[0]);
    }

    public void stopAnimation() {
        this.univ.pauseAnimation();
        Executer.record(STOP_ANIMATE, new String[0]);
    }

    public void changeAnimationOptions() {
        GenericDialog gd = new GenericDialog("Change animation axis");
        String[] choices = new String[]{"x axis", "y axis", "z axis"};
        Vector3f axis = new Vector3f();
        this.univ.getRotationAxis(axis);
        axis.normalize();
        float interval = this.univ.getRotationInterval();
        int idx = 0;
        if (axis.x == 0.0f && axis.y == 1.0f && axis.z == 0.0f) {
            idx = 1;
        }
        if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 1.0f) {
            idx = 2;
        }
        gd.addChoice("Rotate around", choices, choices[idx]);
        gd.addNumericField("Rotation interval", (double)interval, 2, 6, "degree");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        idx = gd.getNextChoiceIndex();
        switch (idx) {
            case 0: {
                axis.x = 1.0f;
                axis.y = 0.0f;
                axis.z = 0.0f;
                break;
            }
            case 1: {
                axis.x = 0.0f;
                axis.y = 1.0f;
                axis.z = 0.0f;
                break;
            }
            case 2: {
                axis.x = 0.0f;
                axis.y = 0.0f;
                axis.z = 1.0f;
            }
        }
        interval = (float)gd.getNextNumber();
        this.univ.setRotationAxis(axis);
        this.univ.setRotationInterval(interval);
    }

    public void snapshot() {
        int w = this.univ.getCanvas().getWidth();
        int h = this.univ.getCanvas().getHeight();
        GenericDialog gd = new GenericDialog("Snapshot", (Frame)this.univ.getWindow());
        gd.addNumericField("Target_width", (double)w, 0);
        gd.addNumericField("Target_height", (double)h, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        w = (int)gd.getNextNumber();
        h = (int)gd.getNextNumber();
        Map props = this.univ.getCanvas().queryProperties();
        int maxW = (Integer)props.get("textureWidthMax");
        int maxH = (Integer)props.get("textureHeightMax");
        if (w < 0 || w >= maxW || h < 0 || h >= maxH) {
            IJ.error((String)("Width must be between 0 and " + maxW + ",\nheight between 0 and " + maxH));
            return;
        }
        this.univ.takeSnapshot(w, h).show();
        Executer.record(SNAPSHOT, Integer.toString(w), Integer.toString(h));
    }

    public void viewPreferences() {
        UniverseSettings.initFromDialog(this.univ);
    }

    public void editShortcuts() {
        new ShortCutDialog(this.univ.getShortcuts());
    }

    public void adjustLight() {
        final PointLight l = this.univ.getLight();
        Point3f pos = new Point3f();
        Color3f col = new Color3f();
        l.getPosition(pos);
        l.getColor(col);
        ColorListener colorListener = new ColorListener(){

            @Override
            public void colorChanged(Color3f color) {
                l.setColor(color);
            }

            @Override
            public void ok(GenericDialog gd) {
            }
        };
        this.showColorDialog("Adjust light", col, colorListener, false, false);
    }

    public void sync(boolean b) {
        this.univ.sync(b);
    }

    public void setFullScreen(boolean b) {
        this.univ.setFullScreen(b);
    }

    public void editScalebar() {
        Scalebar sc = this.univ.getScalebar();
        GenericDialog gd = new GenericDialog("Edit scalebar...", (Frame)this.univ.getWindow());
        gd.addNumericField("x position", (double)sc.getX(), 2);
        gd.addNumericField("y position", (double)sc.getY(), 2);
        gd.addNumericField("length", (double)sc.getLength(), 2);
        gd.addStringField("Units", sc.getUnit(), 5);
        gd.addChoice("Color", ColorTable.colorNames, ColorTable.getColorName(sc.getColor()));
        gd.addCheckbox("show", this.univ.isAttributeVisible(0));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        sc.setPosition((float)gd.getNextNumber(), (float)gd.getNextNumber());
        sc.setLength((float)gd.getNextNumber());
        sc.setUnit(gd.getNextString());
        sc.setColor(ColorTable.getColor(gd.getNextChoice()));
        boolean vis = gd.getNextBoolean();
        this.univ.showAttribute(0, vis);
    }

    public void j3dproperties() {
        TextWindow tw = new TextWindow("Java 3D Properties", "Key\tValue", "", 512, 512);
        Map props = VirtualUniverse.getProperties();
        tw.append("Java 3D properties\n \n");
        for (Map.Entry me : props.entrySet()) {
            tw.append(me.getKey() + "\t" + me.getValue());
        }
        props = this.univ.getCanvas().queryProperties();
        tw.append(" \nRendering properties\n \n");
        for (Map.Entry me : props.entrySet()) {
            tw.append(me.getKey() + "\t" + me.getValue());
        }
    }

    private float[] readTransform(Content selected) {
        final GenericDialog gd = new GenericDialog("Read transformation", (Frame)this.univ.getWindow());
        Transform3D t1 = new Transform3D();
        selected.getLocalTranslate().getTransform(t1);
        Transform3D t2 = new Transform3D();
        selected.getLocalRotate().getTransform(t2);
        t1.mul(t2);
        float[] matrix = new float[16];
        t1.get(matrix);
        String transform = this.affine2string(matrix);
        gd.addStringField("Transformation", transform, 25);
        Panel p = new Panel(new FlowLayout());
        Button b = new Button("Open from file");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float[] m = new TransformIO().openAffineTransform();
                if (m != null) {
                    TextField tf = (TextField)gd.getStringFields().get(0);
                    tf.setText(Executer.this.affine2string(m));
                    tf.repaint();
                }
            }
        });
        p.add(b);
        gd.addPanel(p);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        transform = gd.getNextString();
        float[] m = this.string2affine(transform);
        return m;
    }

    static FastMatrix toFastMatrix(Transform3D t3d) {
        Matrix4d m = new Matrix4d();
        t3d.get(m);
        return new FastMatrix((double[][])new double[][]{{m.m00, m.m01, m.m02, m.m03}, {m.m10, m.m11, m.m12, m.m13}, {m.m20, m.m21, m.m22, m.m23}});
    }

    private String affine2string(float[] matrix) {
        String transform = "";
        for (int i = 0; i < matrix.length; ++i) {
            transform = transform + matrix[i] + " ";
        }
        return transform;
    }

    private float[] string2affine(String transform) {
        String[] s = Tools.split((String)transform);
        float[] m = new float[s.length];
        for (int i = 0; i < s.length; ++i) {
            m[i] = Float.parseFloat(s[i]);
        }
        return m;
    }

    private static final int getAutoThreshold(ImagePlus imp) {
        int[] histo = new int[256];
        int d = imp.getStackSize();
        for (int z = 0; z < d; ++z) {
            byte[] p = (byte[])imp.getStack().getPixels(z + 1);
            for (int i = 0; i < p.length; ++i) {
                int n = p[i] & 0xFF;
                histo[n] = histo[n] + 1;
            }
        }
        return imp.getProcessor().getAutoThreshold(histo);
    }

    private final boolean checkSel(Content c) {
        if (c == null) {
            IJ.error((String)"Selection required");
            return false;
        }
        return true;
    }

    public static void record(String command, String ... args) {
        command = "call(\"ij3d.ImageJ3DViewer." + command;
        for (int i = 0; i < args.length; ++i) {
            command = command + "\", \"" + args[i];
        }
        command = command + "\");\n";
        if (Recorder.record) {
            Recorder.recordString((String)command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (null != this.exec) {
            ExecutorService executorService = this.exec;
            synchronized (executorService) {
                this.exec.shutdownNow();
                this.exec = null;
            }
        }
    }

    public void execute(Runnable task) {
        if (null == this.exec) {
            IJ.log((String)"The executer service has been shut down!");
            return;
        }
        this.exec.submit(task);
    }

    private abstract class SliderAdjuster
    extends Thread {
        boolean go;
        int newV;
        ContentInstant content;
        Image3DUniverse univ;
        final Object lock;

        SliderAdjuster() {
            super("VIB-SliderAdjuster");
            this.go = false;
            this.lock = new Object();
            this.setPriority(5);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exec(int newV, ContentInstant content, Image3DUniverse univ) {
            Object object = this.lock;
            synchronized (object) {
                this.newV = newV;
                this.content = content;
                this.univ = univ;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.go = false;
            SliderAdjuster sliderAdjuster = this;
            synchronized (sliderAdjuster) {
                this.notify();
            }
        }

        protected abstract void setValue(ContentInstant var1, int var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.go = true;
            while (this.go) {
                try {
                    ContentInstant c;
                    if (null == this.content) {
                        SliderAdjuster sliderAdjuster = this;
                        synchronized (sliderAdjuster) {
                            this.wait();
                        }
                    }
                    if (!this.go) {
                        return;
                    }
                    int transp = 0;
                    Object object = this.lock;
                    synchronized (object) {
                        c = this.content;
                        transp = this.newV;
                        Image3DUniverse u = this.univ;
                    }
                    if (null != c) {
                        this.setValue(c, transp);
                    }
                    object = this.lock;
                    synchronized (object) {
                        if (c == this.content) {
                            this.content = null;
                            this.univ = null;
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static interface ColorListener {
        public void colorChanged(Color3f var1);

        public void ok(GenericDialog var1);
    }
}

