/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import ij3d.UniverseListener;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.RenderingError;
import org.jogamp.java3d.RenderingErrorListener;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.utils.universe.SimpleUniverse;

public class ImageWindow3D
extends JFrame
implements UniverseListener {
    private DefaultUniverse universe;
    private final ImageCanvas3D canvas3D;
    private final Label status = new Label("");
    private boolean noOffScreen = true;
    private final ErrorListener error_listener;
    private ImagePlus imp;
    private Canvas3D offScreenCanvas3D;
    final ImagePlusUpdater imp_updater = new ImagePlusUpdater();
    private final int top = 0;
    private final int bottom = 0;
    private final int left = 0;
    private final int right = 0;
    private int lastToolID;

    public ImageWindow3D(String title, DefaultUniverse universe) {
        super(title);
        String j3dNoOffScreen = System.getProperty("j3d.noOffScreen");
        if (j3dNoOffScreen != null && j3dNoOffScreen.equals("true")) {
            this.noOffScreen = true;
        }
        this.imp = new ImagePlus();
        this.imp.setTitle("ImageJ 3D Viewer");
        this.universe = universe;
        this.canvas3D = (ImageCanvas3D)universe.getCanvas();
        this.error_listener = new ErrorListener();
        this.error_listener.addTo(universe);
        this.add((Component)((Object)this.canvas3D), -1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImageWindow3D.this.close();
            }
        });
        universe.addUniverseListener(this);
        this.updateImagePlus();
        universe.ui.setHandTool();
    }

    public DefaultUniverse getUniverse() {
        return this.universe;
    }

    public ImageCanvas getCanvas() {
        return new ImageCanvas(this.getImagePlus());
    }

    private Canvas3D getOffScreenCanvas() {
        if (this.offScreenCanvas3D != null) {
            return this.offScreenCanvas3D;
        }
        GraphicsConfigTemplate3D templ = new GraphicsConfigTemplate3D();
        templ.setDoubleBuffer(3);
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)templ);
        this.offScreenCanvas3D = new Canvas3D(gc, true);
        Screen3D sOn = this.canvas3D.getScreen3D();
        Screen3D sOff = this.offScreenCanvas3D.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas3D);
        return this.offScreenCanvas3D;
    }

    private static ImagePlus makeDummyImagePlus() {
        ColorProcessor cp = new ColorProcessor(1, 1);
        return new ImagePlus("3D", (ImageProcessor)cp);
    }

    public void updateImagePlus() {
        this.imp_updater.update();
    }

    public void updateImagePlusAndWait() {
        this.imp_updater.updateAndWait();
    }

    void quitImageUpdater() {
        this.imp_updater.quit();
    }

    public ImagePlus getImagePlus() {
        if (this.imp == null) {
            this.imp_updater.updateAndWait();
        }
        return this.imp;
    }

    private ImagePlus getNewImagePlus() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return ImageWindow3D.makeDummyImagePlus();
        }
        if (this.noOffScreen) {
            Robot robot;
            if (this.universe != null && this.universe.getUseToFront()) {
                this.toFront();
            }
            Point p = this.canvas3D.getLocationOnScreen();
            int w = this.canvas3D.getWidth();
            int h = this.canvas3D.getHeight();
            try {
                robot = new Robot(this.getGraphicsConfiguration().getDevice());
            }
            catch (AWTException e) {
                return ImageWindow3D.makeDummyImagePlus();
            }
            Rectangle r = new Rectangle(p.x + 0, p.y + 0, w - 0 - 0, h - 0 - 0);
            BufferedImage bImage = robot.createScreenCapture(r);
            ColorProcessor cp = new ColorProcessor((Image)bImage);
            ImagePlus result = new ImagePlus("3d", (ImageProcessor)cp);
            result.setRoi(this.canvas3D.getRoi());
            return result;
        }
        BufferedImage bImage = new BufferedImage(this.canvas3D.getWidth(), this.canvas3D.getHeight(), 2);
        ImageComponent2D buffer = new ImageComponent2D(2, bImage);
        try {
            this.getOffScreenCanvas();
            this.offScreenCanvas3D.setOffScreenBuffer(buffer);
            this.offScreenCanvas3D.renderOffScreenBuffer();
            this.offScreenCanvas3D.waitForOffScreenRendering();
            bImage = this.offScreenCanvas3D.getOffScreenBuffer().getImage();
            this.offScreenCanvas3D.setOffScreenBuffer(null);
        }
        catch (Exception e) {
            this.noOffScreen = true;
            this.universe.getViewer().getView().removeCanvas3D(this.offScreenCanvas3D);
            this.offScreenCanvas3D = null;
            System.err.println("Java3D error: Off-screen rendering not supported by this\nsetup. Falling back to screen capturing");
            return this.getNewImagePlus();
        }
        ColorProcessor cp = new ColorProcessor((Image)bImage);
        ImagePlus result = new ImagePlus("3d", (ImageProcessor)cp);
        result.setRoi(this.canvas3D.getRoi());
        return result;
    }

    public Label getStatusLabel() {
        return this.status;
    }

    public void close() {
        if (null == this.universe) {
            return;
        }
        this.universe.removeUniverseListener(this);
        try {
            Method m = SimpleUniverse.class.getMethod("removeRenderingErrorListener", RenderingErrorListener.class);
            if (null != m) {
                m.invoke((Object)this.universe, this.error_listener);
            }
        }
        catch (Exception ex) {
            System.out.println("Could NOT remove the RenderingErrorListener!");
            ex.printStackTrace();
        }
        if (null != this.universe.getWindow()) {
            this.universe.cleanup();
        }
        this.imp_updater.quit();
        this.canvas3D.flush();
        this.universe = null;
        this.dispose();
    }

    @Override
    public void universeClosed() {
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void transformationUpdated(View view) {
    }

    @Override
    public void contentSelected(Content c) {
    }

    @Override
    public void transformationFinished(View view) {
        this.updateImagePlus();
    }

    @Override
    public void contentAdded(Content c) {
        this.updateImagePlus();
    }

    @Override
    public void contentRemoved(Content c) {
        this.updateImagePlus();
    }

    @Override
    public void contentChanged(Content c) {
        this.updateImagePlus();
    }

    @Override
    public void canvasResized() {
        this.updateImagePlus();
    }

    private class ErrorListener
    implements RenderingErrorListener {
        private ErrorListener() {
        }

        public void errorOccurred(RenderingError error) {
            throw new RuntimeException(error.getDetailMessage());
        }

        public void addTo(DefaultUniverse universe) {
            try {
                Class[] params = new Class[]{RenderingErrorListener.class};
                Class<?> c = universe.getClass();
                String name = "addRenderingErrorListener";
                Method m = c.getMethod("addRenderingErrorListener", params);
                Object[] list = new Object[]{this};
                m.invoke((Object)universe, list);
            }
            catch (Exception e) {
                System.err.println("Java3D < 1.5 detected");
            }
        }
    }

    private class ImagePlusUpdater
    extends Thread {
        boolean go;
        int update;

        ImagePlusUpdater() {
            super("3D-V-IMP-updater");
            this.go = true;
            this.update = 0;
            try {
                this.setDaemon(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                ++this.update;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateAndWait() {
            this.update();
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                while (this.update > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.go) {
                int u;
                ImagePlusUpdater imagePlusUpdater = this;
                synchronized (imagePlusUpdater) {
                    if (0 == this.update) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                    u = this.update;
                }
                ImageWindow3D.this.imp = ImageWindow3D.this.getNewImagePlus();
                imagePlusUpdater = this;
                synchronized (imagePlusUpdater) {
                    if (u != this.update) {
                        continue;
                    }
                    this.update = 0;
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.go = false;
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                this.update = -2147483647;
                this.notify();
            }
        }
    }
}

