/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.gui.GenericDialog;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.KeyStroke;
import org.jogamp.vecmath.Color3f;

public class UniverseSettings {
    public static final File propsfile = new File(UniverseSettings.getPrefsDir(), ".ImageJ_3D_Viewer.props");
    public static final int PERSPECTIVE = 1;
    public static final int PARALLEL = 0;
    public static int startupWidth = 512;
    public static int startupHeight = 512;
    public static int projection = 1;
    public static boolean showGlobalCoordinateSystem = false;
    public static boolean showLocalCoordinateSystemsByDefault = false;
    public static boolean showScalebar = false;
    public static boolean showSelectionBox = true;
    public static Color3f defaultBackground = new Color3f();
    public static final HashMap<String, String> shortcuts = new HashMap();

    protected static String getPrefsDir() {
        String env = System.getenv("IJ_PREFS_DIR");
        if (env != null && !env.equals("")) {
            return env;
        }
        return System.getProperty("user.home");
    }

    public static void save() {
        Properties properties = new Properties();
        properties.put("Startup_Width", UniverseSettings.str(startupWidth));
        properties.put("Startup_Height", UniverseSettings.str(startupHeight));
        properties.put("Projection", UniverseSettings.str(projection));
        properties.put("Show_Global_Coordinate_System", UniverseSettings.str(showGlobalCoordinateSystem));
        properties.put("Show_Local_Coordinate_System_When_Adding_Content", UniverseSettings.str(showLocalCoordinateSystemsByDefault));
        properties.put("Show_Scalebar", UniverseSettings.str(showScalebar));
        properties.put("Background", UniverseSettings.str(defaultBackground));
        for (String key : shortcuts.keySet()) {
            properties.put("shortcut." + key, shortcuts.get(key));
        }
        try {
            properties.store(new FileOutputStream(propsfile), "ImageJ 3D Viewer properties");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static void setDefaultShortcuts() {
        shortcuts.clear();
        shortcuts.put("File > Open...", UniverseSettings.getKeyStroke(79));
        shortcuts.put("Edit > Delete", "pressed DELETE");
        shortcuts.put("File > Quit", UniverseSettings.getKeyStroke(87));
        shortcuts.put("Edit > Change transparency", UniverseSettings.getKeyStroke(84));
        shortcuts.put("Edit > Change color", UniverseSettings.getKeyStroke(67));
        shortcuts.put("View > Fullscreen", UniverseSettings.getKeyStroke(70));
        shortcuts.put("View > Reset view", "ctrl pressed H");
        shortcuts.put("Help > Java 3D Properties", "pressed F1");
    }

    private static String getKeyStroke(int kc) {
        return KeyStroke.getKeyStroke(kc, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString();
    }

    public static void load() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(propsfile));
            startupWidth = UniverseSettings.integer(properties.getProperty("Startup_Width", UniverseSettings.str(startupWidth)));
            startupHeight = UniverseSettings.integer(properties.getProperty("Startup_Height", UniverseSettings.str(startupHeight)));
            projection = UniverseSettings.integer(properties.getProperty("Projection", UniverseSettings.str(projection)));
            showGlobalCoordinateSystem = UniverseSettings.bool(properties.getProperty("Show_Global_Coordinate_System", UniverseSettings.str(showGlobalCoordinateSystem)));
            showLocalCoordinateSystemsByDefault = UniverseSettings.bool(properties.getProperty("Show_Local_Coordinate_System_When_Adding_Content", UniverseSettings.str(showLocalCoordinateSystemsByDefault)));
            showScalebar = UniverseSettings.bool(properties.getProperty("Show_Scalebar", UniverseSettings.str(showScalebar)));
            defaultBackground = UniverseSettings.col(properties.getProperty("Background", UniverseSettings.str(defaultBackground)));
            shortcuts.clear();
            for (Object o : properties.keySet()) {
                String key = (String)o;
                if (!key.startsWith("shortcut.")) continue;
                key = key.substring(".shortcut".length());
                String v = properties.getProperty((String)o);
                shortcuts.put(key, v);
            }
            if (shortcuts.isEmpty()) {
                UniverseSettings.setDefaultShortcuts();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void initFromDialog(Image3DUniverse univ) {
        GenericDialog gd = new GenericDialog("View Preferences", (Frame)univ.getWindow());
        gd.addMessage("The following options are startup options\nThey are not applied, unless you activate\n'Apply changes now' below.");
        gd.addNumericField("Width", (double)startupWidth, 0);
        gd.addNumericField("Height", (double)startupHeight, 0);
        String[] choice = new String[]{"PARALLEL", "PERSPECTIVE"};
        int[] v1 = new int[]{0, 1};
        String def = projection == v1[0] ? choice[0] : choice[1];
        gd.addChoice("Projection", choice, def);
        gd.addCheckbox("Show global coordinate system", showGlobalCoordinateSystem);
        gd.addCheckbox("Use current color as default backround", false);
        gd.addCheckbox("Show scalebar", showScalebar);
        gd.addCheckbox("Apply changes now", true);
        gd.addMessage("The following options are applied immediately:");
        gd.addCheckbox("Show local coordinate system by default", showLocalCoordinateSystemsByDefault);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        startupWidth = (int)gd.getNextNumber();
        startupHeight = (int)gd.getNextNumber();
        projection = v1[gd.getNextChoiceIndex()];
        showGlobalCoordinateSystem = gd.getNextBoolean();
        if (gd.getNextBoolean() && univ != null) {
            ((ImageCanvas3D)univ.getCanvas()).getBG().getColor(defaultBackground);
        }
        showScalebar = gd.getNextBoolean();
        boolean apply = gd.getNextBoolean();
        showLocalCoordinateSystemsByDefault = gd.getNextBoolean();
        UniverseSettings.save();
        if (apply) {
            UniverseSettings.apply(univ);
        }
    }

    public static void apply(Image3DUniverse univ) {
        if (univ == null) {
            return;
        }
        univ.setSize(startupWidth, startupHeight);
        univ.getViewer().getView().setProjectionPolicy(projection);
        univ.showAttribute(1, showGlobalCoordinateSystem);
        univ.showAttribute(0, showScalebar);
    }

    private static final String str(int i) {
        return Integer.toString(i);
    }

    private static final String str(boolean b) {
        return Boolean.toString(b);
    }

    private static final String str(Color3f c) {
        return "[" + c.x + "," + c.y + "," + c.z + "]";
    }

    private static final Color3f col(String s) {
        s = s.substring(1, s.length() - 1);
        String[] tmp = s.split(",");
        return new Color3f(Float.parseFloat(tmp[0]), Float.parseFloat(tmp[1]), Float.parseFloat(tmp[2]));
    }

    private static final boolean bool(String s) {
        return Boolean.parseBoolean(s);
    }

    private static final int integer(String s) {
        return Integer.parseInt(s);
    }
}

