/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shortcuts;

import ij3d.UniverseSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ShortCuts {
    private final List<String> commands = new ArrayList<String>();
    private final HashMap<String, JMenuItem> items = new HashMap();
    private final HashMap<String, String> shortcuts = UniverseSettings.shortcuts;

    public ShortCuts(JMenuBar menubar) {
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            this.scan(menubar.getMenu(i), "");
        }
        for (String command : this.commands) {
            String shortcut = this.shortcuts.get(command);
            if (shortcut == null) continue;
            this.setShortCut(command, shortcut);
        }
    }

    public void save() {
        UniverseSettings.save();
    }

    public void reload() {
        UniverseSettings.load();
    }

    public Iterable<String> getCommands() {
        return this.commands;
    }

    public String getShortCut(String command) {
        return this.shortcuts.get(command);
    }

    public void setShortCut(String command, String shortcut) {
        if (shortcut.trim().length() == 0) {
            this.clearShortCut(command);
            return;
        }
        this.shortcuts.put(command, shortcut);
        KeyStroke stroke = KeyStroke.getKeyStroke(shortcut);
        this.items.get(command).setAccelerator(stroke);
    }

    public void clearShortCut(String command) {
        this.items.get(command).setAccelerator(null);
        this.shortcuts.remove(command);
    }

    public int getNumberOfCommands() {
        return this.commands.size();
    }

    public String getCommand(int i) {
        return this.commands.get(i);
    }

    private void scan(JMenu menu, String prefix) {
        prefix = prefix + menu.getText() + " > ";
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem mi = menu.getItem(i);
            if (mi == null) continue;
            if (mi instanceof JMenu) {
                this.scan((JMenu)mi, prefix);
                continue;
            }
            String c = prefix + mi.getText();
            this.commands.add(c);
            this.items.put(c, mi);
        }
    }
}

