/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.Image3DUniverse;
import java.awt.Window;
import java.awt.image.IndexColorModel;
import java.util.HashMap;
import org.jogamp.vecmath.Color3f;
import process3d.Smooth;
import vib.NaiveResampler;

public class Show_Colour_Surfaces
implements PlugIn {
    public void displayAsSurfaces(Image3DUniverse univ, ImagePlus image, int backgroundColorIndex, double smoothingSigma) {
        this.displayAsSurfaces(univ, image, backgroundColorIndex, smoothingSigma, -1);
    }

    public void displayAsSurfaces(Image3DUniverse univ, ImagePlus image, int backgroundColorIndex, double smoothingSigma, int requestedResampling) {
        int v;
        ImageStack stack;
        IndexColorModel cm;
        if (image == null) {
            IJ.error((String)"Show_Colour_Surfaces.displayAsSurfaces was passed a null 'image'");
            return;
        }
        if (univ == null) {
            IJ.error((String)"Show_Colour_Surfaces.displayAsSurfaces was passed a null 'univ'");
            return;
        }
        int type = image.getType();
        if (type != 3) {
            IJ.error((String)"Show_Colour_Surfaces only works with 8-bit indexed color images.");
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getStackSize();
        Calibration calibration = image.getCalibration();
        if (calibration == null) {
            calibration = new Calibration(image);
        }
        int maxSampleSide = Math.max(width, Math.max(height, depth));
        int resamplingFactor = 1;
        if (requestedResampling < 0) {
            System.out.println("resamplingFactor is now: " + resamplingFactor);
            while (maxSampleSide / resamplingFactor > 512) {
                resamplingFactor *= 2;
            }
        } else {
            resamplingFactor = requestedResampling;
        }
        if (resamplingFactor != 1) {
            image = NaiveResampler.resample((ImagePlus)image, (int)resamplingFactor);
            width = image.getWidth();
            height = image.getHeight();
            depth = image.getStackSize();
            calibration = image.getCalibration();
            if (calibration == null) {
                calibration = new Calibration(image);
            }
            maxSampleSide = Math.max(width, Math.max(height, depth));
        }
        if ((cm = (IndexColorModel)(stack = image.getStack()).getColorModel()) == null) {
            IJ.error((String)"The color model for this image stack was null");
            return;
        }
        int colours = cm.getMapSize();
        byte[] reds = new byte[colours];
        byte[] greens = new byte[colours];
        byte[] blues = new byte[colours];
        cm.getReds(reds);
        cm.getBlues(blues);
        cm.getGreens(greens);
        if (backgroundColorIndex < 0) {
            GenericDialog gd = new GenericDialog("Show Colour Surfaces");
            gd.addNumericField("Index of background colour (from 0 to " + (colours - 1) + " inclusive):", 0.0, 3);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            backgroundColorIndex = (int)gd.getNextNumber();
        }
        if (backgroundColorIndex < 0 || backgroundColorIndex >= colours) {
            IJ.error((String)("The background colour must have an index from 0 to " + (colours - 1) + " inclusive"));
            return;
        }
        HashMap<Integer, Boolean> coloursUsedInImage = new HashMap<Integer, Boolean>();
        for (int c = 0; c < colours; ++c) {
            coloursUsedInImage.put(c, false);
        }
        for (int z = 0; z < depth; ++z) {
            byte[] pixels = (byte[])stack.getPixels(z + 1);
            for (int i = 0; i < pixels.length; ++i) {
                v = pixels[i] & 0xFF;
                coloursUsedInImage.put(v, true);
            }
        }
        for (int i = 0; i < colours; ++i) {
            boolean used = (Boolean)coloursUsedInImage.get(i);
            if (!used) {
                System.out.println("Skipping colour index " + i + ", since it's not used in the image");
                continue;
            }
            if (i == backgroundColorIndex) continue;
            Color3f c = new Color3f((float)(reds[i] & 0xFF) / 255.0f, (float)(greens[i] & 0xFF) / 255.0f, (float)(blues[i] & 0xFF) / 255.0f);
            v = (byte)i;
            ImageStack newStack = new ImageStack(width, height);
            for (int z = 0; z < depth; ++z) {
                byte[] originalPixels = (byte[])stack.getPixels(z + 1);
                byte[] newBytes = new byte[originalPixels.length];
                for (int j = 0; j < originalPixels.length; ++j) {
                    if (originalPixels[j] != v) continue;
                    newBytes[j] = -1;
                }
                ByteProcessor bp = new ByteProcessor(width, height);
                bp.setPixels((Object)newBytes);
                newStack.addSlice("", (ImageProcessor)bp);
            }
            ImagePlus colourImage = new ImagePlus("Image for colour index: " + i, newStack);
            colourImage.setCalibration(calibration);
            if (smoothingSigma > 0.0) {
                ImagePlus smoothedColourImage = Smooth.smooth((ImagePlus)colourImage, (boolean)true, (float)((float)smoothingSigma), (boolean)true);
                smoothedColourImage.setTitle("Smoothed image for colour index: " + i);
                colourImage.close();
                colourImage = smoothedColourImage;
            }
            boolean[] channels = new boolean[]{true, true, true};
            Content content = univ.addContent(colourImage, c, colourImage.getTitle(), 40, channels, resamplingFactor, 2);
            content.setLocked(true);
            colourImage.close();
        }
    }

    public void run(String ignored) {
        Image3DUniverse univ;
        int chosenIndex;
        ImagePlus image = IJ.getImage();
        if (image == null) {
            IJ.error((String)"There is no image to view.");
            return;
        }
        Calibration c = image.getCalibration();
        if (c == null) {
            c = new Calibration(image);
        }
        double maxSampleSeparation = Math.max(Math.max(Math.abs(c.pixelWidth), Math.abs(c.pixelHeight)), Math.abs(c.pixelDepth));
        int type = image.getType();
        if (type != 3) {
            IJ.error((String)"Show_Colour_Surfaces only works with 8-bit indexed color images.");
            return;
        }
        ImageStack stack = image.getStack();
        IndexColorModel cm = (IndexColorModel)stack.getColorModel();
        if (cm == null) {
            IJ.error((String)"The color model for this image stack was null");
            return;
        }
        int colours = cm.getMapSize();
        int maxSampleSide = Math.max(Math.max(image.getWidth(), image.getHeight()), image.getStackSize());
        int suggestedResamplingFactor = 1;
        while (maxSampleSide / suggestedResamplingFactor > 512) {
            suggestedResamplingFactor *= 2;
        }
        GenericDialog gd = new GenericDialog("Show Colour Surfaces");
        String[] choices = new String[Image3DUniverse.universes.size() + 1];
        String useNewString = "Create New 3D Viewer";
        choices[choices.length - 1] = "Create New 3D Viewer";
        for (int i = 0; i < choices.length - 1; ++i) {
            String contentsString = Image3DUniverse.universes.get(i).allContentsString();
            String shortContentsString = contentsString.length() == 0 ? "[Empty]" : contentsString.substring(0, Math.min(20, contentsString.length() - 1));
            choices[i] = "[" + i + "] containing " + shortContentsString;
        }
        gd.addChoice("Use 3D Viewer", choices, "Create New 3D Viewer");
        gd.addNumericField("Resampling factor: ", (double)suggestedResamplingFactor, 0);
        gd.addNumericField("Index of background colour (from 0 to " + (colours - 1) + " inclusive):", 0.0, 0);
        gd.addNumericField("Radius of smoothing, or -1 for no smoothing (much faster)", maxSampleSeparation, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String chosenViewer = gd.getNextChoice();
        for (chosenIndex = 0; chosenIndex < choices.length && !choices[chosenIndex].equals(chosenViewer); ++chosenIndex) {
        }
        int resamplingFactor = (int)gd.getNextNumber();
        int backgroundColorIndex = (int)gd.getNextNumber();
        double smoothingSigma = gd.getNextNumber();
        if (chosenIndex == choices.length - 1) {
            univ = new Image3DUniverse(512, 512);
            univ.show();
            GUI.center((Window)univ.getWindow());
        } else {
            univ = Image3DUniverse.universes.get(chosenIndex);
        }
        this.displayAsSurfaces(univ, image, backgroundColorIndex, smoothingSigma, resamplingFactor);
    }
}

