/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import octree.CubeData;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.vecmath.Color3f;

public class AppearanceCreator
implements AxisConstants {
    private static final int TEX_MODE = 1;
    private static final int COMP_TYPE = 10;
    private static final boolean BY_REF = true;
    private static final boolean Y_UP = true;
    private static final int SIZE = 128;
    private TextureAttributes texAttr;
    private TransparencyAttributes transAttr;
    private PolygonAttributes polyAttr;
    private Material material;
    private ColoringAttributes colAttr;
    private RenderingAttributes rendAttr;
    private static AppearanceCreator instance;

    private AppearanceCreator() {
        this.initAttributes(null, 0.1f);
    }

    public static AppearanceCreator instance() {
        if (instance == null) {
            instance = new AppearanceCreator();
        }
        return instance;
    }

    public Appearance getAppearance(CubeData cdata, int index) {
        Appearance a = new Appearance();
        a.setMaterial(this.material);
        a.setTransparencyAttributes(this.transAttr);
        a.setPolygonAttributes(this.polyAttr);
        a.setColoringAttributes(this.colAttr);
        a.setRenderingAttributes(this.rendAttr);
        a.setTexture((Texture)this.getTexture(cdata, index));
        a.setTexCoordGeneration(cdata.tg);
        a.setTextureAttributes(this.texAttr);
        return a;
    }

    public void setTransparency(float f) {
        this.transAttr.setTransparency(f);
    }

    public void setThreshold(float f) {
        this.rendAttr.setAlphaTestValue(f);
    }

    public void setColor(Color3f c) {
        this.colAttr.setColor(c);
    }

    private Texture2D getTexture(CubeData cdata, int index) {
        Texture2D tex = new Texture2D(1, 1, 128, 128);
        ImageComponent2D pArray = new ImageComponent2D(10, 128, 128, true, true);
        pArray.set(cdata.images[index]);
        tex.setImage(0, (ImageComponent)pArray);
        tex.setEnable(true);
        tex.setMinFilter(3);
        tex.setMagFilter(3);
        tex.setBoundaryModeS(2);
        tex.setBoundaryModeT(2);
        return tex;
    }

    private void initAttributes(Color3f color, float transparency) {
        this.texAttr = new TextureAttributes();
        this.texAttr.setTextureMode(6);
        this.texAttr.setCombineRgbMode(1);
        this.texAttr.setPerspectiveCorrectionMode(1);
        this.transAttr = new TransparencyAttributes();
        this.transAttr.setTransparency(0.1f);
        this.transAttr.setCapability(3);
        this.transAttr.setTransparencyMode(2);
        this.transAttr.setTransparency(transparency);
        this.polyAttr = new PolygonAttributes();
        this.polyAttr.setCullFace(0);
        this.material = new Material();
        this.material.setLightingEnable(false);
        this.colAttr = new ColoringAttributes();
        this.colAttr.setCapability(1);
        this.colAttr.setShadeModel(1);
        if (color == null) {
            this.colAttr.setColor(1.0f, 1.0f, 1.0f);
        } else {
            this.colAttr.setColor(color);
        }
        this.rendAttr = new RenderingAttributes();
        this.rendAttr.setDepthTestFunction(0);
        this.rendAttr.setCapability(1);
        this.rendAttr.setAlphaTestValue(0.0f);
        this.rendAttr.setAlphaTestFunction(6);
    }
}

