/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import sc.fiji.hdf5.HDF5ImageJ;

public class HDF5_Simple_Writer
implements PlugInFilter {
    String _saveMode;
    ImagePlus _imp;

    public int setup(String arg, ImagePlus imp) {
        this._saveMode = arg;
        this._imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String filename;
        String name;
        String directory;
        OpenDialog sd;
        if (this._saveMode.equals("append")) {
            sd = new OpenDialog("Save to HDF5 (append) ...", OpenDialog.getLastDirectory(), "");
            directory = sd.getDirectory();
            name = sd.getFileName();
            if (name == null) {
                return;
            }
            if (name == "") {
                return;
            }
            filename = directory + name;
        } else {
            sd = new SaveDialog("Save to HDF5 (new or replace)...", OpenDialog.getLastDirectory(), ".h5");
            directory = sd.getDirectory();
            name = sd.getFileName();
            if (name == null) {
                return;
            }
            if (name == "") {
                return;
            }
            filename = directory + name;
        }
        GenericDialog gd = new GenericDialog("Save HDF5");
        gd.addMessage("Data set name template (for hyperstacks should contain placeholders '{t}' and '{c}')");
        String dsetNameTemplate = Prefs.get((String)"hdf5writervibez.nametemplate", (String)"/t{t}/channel{c}");
        gd.addStringField("dsetnametemplate", dsetNameTemplate, 128);
        gd.addMessage("Format string for frame number. Either printf syntax (e.g. '%d') or comma-separated list of names.");
        String formatTime = Prefs.get((String)"hdf5writervibez.timeformat", (String)"%d");
        gd.addStringField("formattime", formatTime, 128);
        gd.addMessage("Format string for channel number. Either printf syntax (e.g. '%d') or comma-separated list of names.");
        String formatChannel = Prefs.get((String)"hdf5writervibez.timeformat", (String)"%d");
        gd.addStringField("formatchannel", formatChannel, 128);
        gd.addMessage("Compression level (0-9)");
        int compressionLevel = (int)Prefs.get((String)"hdf5writervibez.compressionlevel", (double)0.0);
        gd.addNumericField("compressionlevel", (double)compressionLevel, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        dsetNameTemplate = gd.getNextString();
        formatTime = gd.getNextString();
        formatChannel = gd.getNextString();
        compressionLevel = (int)gd.getNextNumber();
        HDF5ImageJ.saveHyperStack(this._imp, filename, dsetNameTemplate, formatTime, formatChannel, compressionLevel, this._saveMode);
    }
}

