/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.Ptr;

public class LongPtr
implements Ptr {
    public long[] array;
    public int offset;

    public LongPtr(long[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public LongPtr(long ... array) {
        this.array = array;
        this.offset = 0;
    }

    public long unwrap() {
        return this.array[this.offset];
    }

    public void update(long[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static int memcmp(long[] x, int xi, long[] y, int yi, int n) {
        while (n > 0) {
            long vx = x[xi];
            long vy = y[yi];
            if (vx != vy || n < 8) {
                return LongPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static int memcmp(long x, long y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)(x & 0xFFL);
            int yb = (int)(y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c, int n) {
        assert (n % 64 == 0);
        long longValue = ((long)c & 0xFFL) << 56 | ((long)c & 0xFFL) << 48 | ((long)c & 0xFFL) << 40 | ((long)c & 0xFFL) << 32 | ((long)c & 0xFFL) << 24 | ((long)c & 0xFFL) << 16 | ((long)c & 0xFFL) << 8 | (long)c & 0xFFL;
        Arrays.fill(str, strOffset, strOffset + c / 64, (double)longValue);
    }
}

