/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.janelia.thickness.inference.visitor.FileSaverVisitor;
import org.scijava.util.FileUtils;

public abstract class CSVVisitor
extends FileSaverVisitor {
    protected String separator;

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public CSVVisitor(String basePath, String relativeFilePattern, String separator) {
        super(basePath, relativeFilePattern);
        this.separator = separator;
    }

    protected <T> void write(Iterable<T> source, String path) throws IOException {
        StringBuilder sb = new StringBuilder("");
        Iterator<T> it = source.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append("\n").append(it.next());
        }
        FileUtils.writeFile((File)new File(path), (byte[])sb.toString().getBytes());
    }

    public static class IndexedIterable<T>
    implements Iterable<String> {
        private final String separator;
        private final Iterable<T> iterable;

        public IndexedIterable(String separator, Iterable<T> iterable) {
            this.separator = separator;
            this.iterable = iterable;
        }

        @Override
        public Iterator<String> iterator() {
            return new IndexedIterator();
        }

        public class IndexedIterator
        implements Iterator<String> {
            private final Iterator<T> it;
            private int index;

            public IndexedIterator() {
                this.it = IndexedIterable.this.iterable.iterator();
                this.index = -1;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public String next() {
                return String.format("%d%s%s", ++this.index, IndexedIterable.this.separator, this.it.next().toString());
            }
        }
    }
}

