/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.EntityUtils;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescriptionUtils;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewRegistrationsUtils;

public class ChangeViewSetupId {
    public static Map<Integer, Integer> assignNewViewSetupIds(AbstractSpimData<?> spimData, Set<Integer> idsInUse) {
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        List setups = seq.getViewSetupsOrdered();
        HashMap<Integer, Integer> oldIdToNewIdMap = new HashMap<Integer, Integer>();
        for (BasicViewSetup setup : setups) {
            int oldId;
            int newId = oldId = setup.getId();
            while (idsInUse.contains(newId)) {
                ++newId;
            }
            if (newId != oldId) {
                oldIdToNewIdMap.put(oldId, newId);
            }
            idsInUse.add(newId);
        }
        AbstractSequenceDescriptionUtils.changeIds((AbstractSequenceDescription)seq, oldIdToNewIdMap);
        ViewRegistrations regs = spimData.getViewRegistrations();
        ViewRegistrationsUtils.changeViewsetupIds((ViewRegistrations)regs, oldIdToNewIdMap);
        return oldIdToNewIdMap;
    }

    public static void changeViewSetupId(AbstractSpimData<?> spimData, int oldViewSetupId, int newViewSetupId) {
        List setups = spimData.getSequenceDescription().getViewSetupsOrdered();
        EntityUtils.changeIds((Collection)setups, (int[])new int[]{oldViewSetupId, newViewSetupId});
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ViewRegistrationsUtils.changeViewsetupIds((ViewRegistrations)viewRegistrations, (int[])new int[]{oldViewSetupId, newViewSetupId});
    }
}

