/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.tools.DelayedPackDialog;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import bdv.viewer.VisibilityAndGrouping;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@Deprecated
public class VisibilityAndGroupingDialog
extends DelayedPackDialog {
    private static final long serialVersionUID = 1L;
    private final VisibilityPanel visibilityPanel;
    private final GroupingPanel groupingPanel;
    private final ModePanel modePanel;

    public VisibilityAndGroupingDialog(Frame owner, VisibilityAndGrouping visibilityAndGrouping) {
        this(owner, visibilityAndGrouping.getState());
    }

    public VisibilityAndGroupingDialog(Frame owner, ViewerState state) {
        super(owner, "visibility and grouping", false);
        this.visibilityPanel = new VisibilityPanel(state, this::isVisible);
        this.visibilityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "visibility"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.groupingPanel = new GroupingPanel(state, this::isVisible);
        this.groupingPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "grouping"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.modePanel = new ModePanel(state, this::isVisible);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 3));
        content.add(this.visibilityPanel);
        content.add(this.groupingPanel);
        content.add(this.modePanel);
        this.add((Component)content, "North");
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Object hideKey = new Object();
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                VisibilityAndGroupingDialog.this.setVisible(false);
            }
        };
        im.put(KeyStroke.getKeyStroke(27, 0), hideKey);
        am.put(hideKey, hideAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                VisibilityAndGroupingDialog.this.visibilityPanel.shown();
                VisibilityAndGroupingDialog.this.groupingPanel.shown();
                VisibilityAndGroupingDialog.this.modePanel.shown();
            }
        });
        this.pack();
    }

    public void update() {
        this.visibilityPanel.update();
        this.groupingPanel.update();
        this.modePanel.update();
    }

    public static class GroupingPanel
    extends JPanel
    implements ViewerStateChangeListener {
        private static final long serialVersionUID = 1L;
        private final ArrayList<Runnable> updateNames = new ArrayList();
        private final Map<SourceGroup, JRadioButton> currentButtonsMap = new HashMap<SourceGroup, JRadioButton>();
        private final ArrayList<Consumer<Set<SourceGroup>>> updateActiveBoxes = new ArrayList();
        private final ArrayList<Runnable> updateAssignBoxes = new ArrayList();
        private final ViewerState state;
        private final BooleanSupplier isVisible;
        private final AtomicBoolean recreateContentPending = new AtomicBoolean(true);
        private final AtomicBoolean updateGroupNamesPending = new AtomicBoolean(true);
        private final AtomicBoolean updateGroupAssignmentsPending = new AtomicBoolean(true);
        private final AtomicBoolean updateGroupActivityPending = new AtomicBoolean(true);
        private final AtomicBoolean updateCurrentGroupPending = new AtomicBoolean(true);

        public GroupingPanel(ViewerState state, BooleanSupplier isVisible) {
            super(new GridBagLayout());
            this.state = state;
            this.isVisible = isVisible;
            state.changeListeners().add((Object)this);
        }

        private void shown() {
            if (this.recreateContentPending.getAndSet(false)) {
                this.recreateContentNow();
            }
            if (this.updateCurrentGroupPending.getAndSet(false)) {
                this.updateCurrentGroupNow();
            }
            if (this.updateGroupNamesPending.getAndSet(false)) {
                this.updateGroupNamesNow();
            }
            if (this.updateGroupActivityPending.getAndSet(false)) {
                this.updateGroupActivityNow();
            }
            if (this.updateGroupAssignmentsPending.getAndSet(false)) {
                this.updateGroupAssignmentsNow();
            }
        }

        private void recreateContent() {
            if (this.isVisible.getAsBoolean()) {
                this.recreateContentNow();
                this.recreateContentPending.set(false);
            } else {
                this.recreateContentPending.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recreateContentNow() {
            ViewerState viewerState = this.state;
            synchronized (viewerState) {
                JToggleButton b;
                this.removeAll();
                this.updateNames.clear();
                this.currentButtonsMap.clear();
                this.updateActiveBoxes.clear();
                this.updateAssignBoxes.clear();
                GridBagConstraints c = new GridBagConstraints();
                c.insets = new Insets(0, 5, 0, 5);
                List<SourceAndConverter<?>> sources = this.state.getSources();
                List<SourceGroup> groups = this.state.getGroups();
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)new JLabel("shortcut"), c);
                c.anchor = 22;
                c.gridy = -1;
                int nShortcuts = Math.min(groups.size(), 10);
                for (int i = 0; i < nShortcuts; ++i) {
                    this.add((Component)new JLabel(Integer.toString(i == 10 ? 0 : i + 1)), c);
                }
                c.gridx = 1;
                c.gridy = 0;
                c.anchor = 10;
                this.add((Component)new JLabel("group name"), c);
                c.anchor = 22;
                c.gridy = -1;
                for (final SourceGroup sourceGroup : groups) {
                    final JTextField jTextField = new JTextField(this.state.getGroupName(sourceGroup), 10);
                    jTextField.getDocument().addDocumentListener(new DocumentListener(){

                        private void doit() {
                            state.setGroupName(sourceGroup, jTextField.getText());
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.doit();
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.doit();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            this.doit();
                        }
                    });
                    this.updateNames.add(() -> {
                        String name = this.state.getGroupName(sourceGroup);
                        if (!jTextField.getText().equals(name)) {
                            jTextField.setText(name);
                        }
                    });
                    this.add((Component)jTextField, c);
                }
                c.anchor = 10;
                c.gridx = 2;
                c.gridy = 0;
                this.add((Component)new JLabel("current"), c);
                c.gridy = -1;
                ButtonGroup currentButtonGroup = new ButtonGroup();
                for (SourceGroup sourceGroup : groups) {
                    b = new JRadioButton();
                    b.addActionListener(arg_0 -> this.lambda$recreateContentNow$1((JRadioButton)b, sourceGroup, arg_0));
                    this.currentButtonsMap.put(sourceGroup, (JRadioButton)b);
                    currentButtonGroup.add(b);
                    this.add((Component)b, c);
                }
                c.gridx = 3;
                c.gridy = 0;
                c.anchor = 10;
                this.add((Component)new JLabel("active in fused"), c);
                c.gridy = -1;
                for (SourceGroup sourceGroup : groups) {
                    b = new JCheckBox();
                    b.addActionListener(arg_0 -> this.lambda$recreateContentNow$2(sourceGroup, (JCheckBox)b, arg_0));
                    this.updateActiveBoxes.add(arg_0 -> GroupingPanel.lambda$recreateContentNow$3((JCheckBox)b, sourceGroup, arg_0));
                    this.add((Component)b, c);
                }
                c.gridx = 4;
                c.gridy = 0;
                c.gridwidth = sources.size();
                c.anchor = 10;
                this.add((Component)new JLabel("assigned sources"), c);
                c.gridwidth = 1;
                c.anchor = 22;
                for (SourceAndConverter<?> sourceAndConverter : sources) {
                    c.gridy = 1;
                    for (SourceGroup group : groups) {
                        JCheckBox b2 = new JCheckBox();
                        b2.addActionListener(e -> {
                            if (b2.isSelected()) {
                                this.state.addSourceToGroup(source, group);
                            } else {
                                this.state.removeSourceFromGroup(source, group);
                            }
                        });
                        this.updateAssignBoxes.add(() -> b2.setSelected(this.state.getSourcesInGroup(group).contains(source)));
                        this.add((Component)b2, c);
                        ++c.gridy;
                    }
                    ++c.gridx;
                }
                this.invalidate();
                Window window = SwingUtilities.getWindowAncestor(this);
                if (window != null) {
                    window.pack();
                }
                this.update();
            }
        }

        private void update() {
            this.updateGroupNames();
            this.updateCurrentGroup();
            this.updateGroupActivity();
            this.updateGroupAssignments();
        }

        private void updateGroupNames() {
            if (this.isVisible.getAsBoolean()) {
                this.updateGroupNamesNow();
                this.updateGroupNamesPending.set(false);
            } else {
                this.updateGroupNamesPending.set(true);
            }
        }

        private void updateGroupNamesNow() {
            this.updateNames.forEach(Runnable::run);
        }

        private void updateGroupAssignments() {
            if (this.isVisible.getAsBoolean()) {
                this.updateGroupAssignmentsNow();
                this.updateGroupAssignmentsPending.set(false);
            } else {
                this.updateGroupAssignmentsPending.set(true);
            }
        }

        private void updateGroupAssignmentsNow() {
            this.updateAssignBoxes.forEach(Runnable::run);
        }

        private void updateGroupActivity() {
            if (this.isVisible.getAsBoolean()) {
                this.updateGroupActivityNow();
                this.updateGroupActivityPending.set(false);
            } else {
                this.updateGroupActivityPending.set(true);
            }
        }

        private void updateGroupActivityNow() {
            Set<SourceGroup> activeGroups = this.state.getActiveGroups();
            this.updateActiveBoxes.forEach((Consumer<Consumer<Set<SourceGroup>>>)((Consumer<Consumer>)c -> c.accept(activeGroups)));
        }

        private void updateCurrentGroup() {
            if (this.isVisible.getAsBoolean()) {
                this.updateCurrentGroupNow();
                this.updateCurrentGroupPending.set(false);
            } else {
                this.updateCurrentGroupPending.set(true);
            }
        }

        private void updateCurrentGroupNow() {
            SourceGroup currentGroup = this.state.getCurrentGroup();
            if (currentGroup == null) {
                this.currentButtonsMap.values().forEach(b -> b.setSelected(false));
            } else {
                this.currentButtonsMap.get(currentGroup).setSelected(true);
            }
        }

        @Override
        public void viewerStateChanged(ViewerStateChange change) {
            switch (change) {
                case CURRENT_GROUP_CHANGED: {
                    SwingUtilities.invokeLater(this::updateCurrentGroup);
                    break;
                }
                case GROUP_ACTIVITY_CHANGED: {
                    SwingUtilities.invokeLater(this::updateGroupActivity);
                    break;
                }
                case SOURCE_TO_GROUP_ASSIGNMENT_CHANGED: {
                    SwingUtilities.invokeLater(this::updateGroupAssignments);
                    break;
                }
                case GROUP_NAME_CHANGED: {
                    SwingUtilities.invokeLater(this::updateGroupNames);
                    break;
                }
                case NUM_SOURCES_CHANGED: 
                case NUM_GROUPS_CHANGED: {
                    SwingUtilities.invokeLater(this::recreateContent);
                }
            }
        }

        private static /* synthetic */ void lambda$recreateContentNow$3(JCheckBox b, SourceGroup group, Set active) {
            b.setSelected(active.contains(group));
        }

        private /* synthetic */ void lambda$recreateContentNow$2(SourceGroup group, JCheckBox b, ActionEvent e) {
            this.state.setGroupActive(group, b.isSelected());
        }

        private /* synthetic */ void lambda$recreateContentNow$1(JRadioButton b, SourceGroup group, ActionEvent e) {
            if (b.isSelected()) {
                this.state.setCurrentGroup(group);
            }
        }
    }

    public static class ModePanel
    extends JPanel
    implements ViewerStateChangeListener {
        private static final long serialVersionUID = 1L;
        private final ViewerState state;
        private JCheckBox groupingBox;
        private JCheckBox fusedModeBox;
        private final BooleanSupplier isVisible;
        private final AtomicBoolean updatePending = new AtomicBoolean(true);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModePanel(ViewerState state, BooleanSupplier isVisible) {
            super(new GridBagLayout());
            this.state = state;
            this.isVisible = isVisible;
            state.changeListeners().add((Object)this);
            ViewerState viewerState = state;
            synchronized (viewerState) {
                this.recreateContent();
                this.update();
            }
        }

        private void shown() {
            if (this.updatePending.getAndSet(false)) {
                this.updateNow();
            }
        }

        private void recreateContent() {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 5);
            c.gridwidth = 1;
            c.anchor = 21;
            this.groupingBox = new JCheckBox();
            this.groupingBox.addActionListener(e -> {
                ViewerState viewerState = this.state;
                synchronized (viewerState) {
                    this.state.setDisplayMode(this.state.getDisplayMode().withGrouping(this.groupingBox.isSelected()));
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.groupingBox, c);
            c.gridx = 1;
            this.add((Component)new JLabel("enable grouping"), c);
            this.fusedModeBox = new JCheckBox();
            this.fusedModeBox.addActionListener(e -> {
                ViewerState viewerState = this.state;
                synchronized (viewerState) {
                    this.state.setDisplayMode(this.state.getDisplayMode().withFused(this.fusedModeBox.isSelected()));
                }
            });
            c.gridx = 0;
            c.gridy = 1;
            this.add((Component)this.fusedModeBox, c);
            c.gridx = 1;
            this.add((Component)new JLabel("enable fused mode"), c);
        }

        private void update() {
            if (this.isVisible.getAsBoolean()) {
                this.updateNow();
                this.updatePending.set(false);
            } else {
                this.updatePending.set(true);
            }
        }

        private void updateNow() {
            this.groupingBox.setSelected(this.state.getDisplayMode().hasGrouping());
            this.fusedModeBox.setSelected(this.state.getDisplayMode().hasFused());
        }

        @Override
        public void viewerStateChanged(ViewerStateChange change) {
            if (change == ViewerStateChange.DISPLAY_MODE_CHANGED) {
                SwingUtilities.invokeLater(this::update);
            }
        }
    }

    public static class VisibilityPanel
    extends JPanel
    implements ViewerStateChangeListener {
        private static final long serialVersionUID = 1L;
        private final ViewerState state;
        private final Map<SourceAndConverter<?>, JRadioButton> currentButtonsMap = new HashMap();
        private final ArrayList<Consumer<Set<SourceAndConverter<?>>>> updateActiveBoxes = new ArrayList();
        private final ArrayList<Consumer<Set<SourceAndConverter<?>>>> updateVisibleBoxes = new ArrayList();
        private final BooleanSupplier isVisible;
        private final AtomicBoolean recreateContentPending = new AtomicBoolean(true);
        private final AtomicBoolean updatePending = new AtomicBoolean(true);

        public VisibilityPanel(ViewerState state, BooleanSupplier isVisible) {
            super(new GridBagLayout());
            this.state = state;
            this.isVisible = isVisible;
            state.changeListeners().add((Object)this);
        }

        private void shown() {
            if (this.recreateContentPending.getAndSet(false)) {
                this.recreateContentNow();
            }
            if (this.updatePending.getAndSet(false)) {
                this.updateNow();
            }
        }

        private void recreateContent() {
            if (this.isVisible.getAsBoolean()) {
                this.recreateContentNow();
                this.recreateContentPending.set(false);
            } else {
                this.recreateContentPending.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recreateContentNow() {
            ViewerState viewerState = this.state;
            synchronized (viewerState) {
                JToggleButton b;
                this.removeAll();
                this.currentButtonsMap.clear();
                this.updateActiveBoxes.clear();
                this.updateVisibleBoxes.clear();
                List<SourceAndConverter<?>> sources = this.state.getSources();
                GridBagConstraints c = new GridBagConstraints();
                c.insets = new Insets(0, 5, 0, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)new JLabel("source"), c);
                c.anchor = 22;
                c.gridy = -1;
                for (SourceAndConverter<?> sourceAndConverter : sources) {
                    this.add((Component)new JLabel(sourceAndConverter.getSpimSource().getName()), c);
                }
                c.anchor = 10;
                c.gridx = 1;
                c.gridy = 0;
                this.add((Component)new JLabel("current"), c);
                c.gridy = -1;
                ButtonGroup currentButtonGroup = new ButtonGroup();
                for (SourceAndConverter<?> source : sources) {
                    b = new JRadioButton();
                    b.addActionListener(arg_0 -> this.lambda$recreateContentNow$0((JRadioButton)b, source, arg_0));
                    this.currentButtonsMap.put(source, (JRadioButton)b);
                    currentButtonGroup.add(b);
                    this.add((Component)b, c);
                }
                c.gridx = 2;
                c.gridy = 0;
                this.add((Component)new JLabel("active in fused"), c);
                c.gridy = -1;
                for (SourceAndConverter<?> source : sources) {
                    b = new JCheckBox();
                    b.addActionListener(arg_0 -> this.lambda$recreateContentNow$1(source, (JCheckBox)b, arg_0));
                    this.updateActiveBoxes.add(arg_0 -> VisibilityPanel.lambda$recreateContentNow$2((JCheckBox)b, source, arg_0));
                    this.add((Component)b, c);
                }
                c.gridx = 3;
                c.gridy = 0;
                this.add((Component)new JLabel("visible"), c);
                c.gridy = -1;
                for (SourceAndConverter<?> source : sources) {
                    b = new JCheckBox();
                    this.updateVisibleBoxes.add(arg_0 -> VisibilityPanel.lambda$recreateContentNow$3((JCheckBox)b, source, arg_0));
                    b.setEnabled(false);
                    this.add((Component)b, c);
                }
                this.invalidate();
                Window window = SwingUtilities.getWindowAncestor(this);
                if (window != null) {
                    window.pack();
                }
                this.update();
            }
        }

        private void update() {
            if (this.isVisible.getAsBoolean()) {
                this.updateNow();
                this.updatePending.set(false);
            } else {
                this.updatePending.set(true);
            }
        }

        private void updateNow() {
            SourceAndConverter<?> currentSource = this.state.getCurrentSource();
            if (currentSource == null) {
                this.currentButtonsMap.values().forEach(b -> b.setSelected(false));
            } else {
                this.currentButtonsMap.get(currentSource).setSelected(true);
            }
            Set<SourceAndConverter<?>> activeSources = this.state.getActiveSources();
            this.updateActiveBoxes.forEach((Consumer<Consumer<Set<SourceAndConverter<?>>>>)((Consumer<Consumer>)c -> c.accept(activeSources)));
            Set<SourceAndConverter<?>> visibleSources = this.state.getVisibleSources();
            this.updateVisibleBoxes.forEach((Consumer<Consumer<Set<SourceAndConverter<?>>>>)((Consumer<Consumer>)c -> c.accept(visibleSources)));
        }

        @Override
        public void viewerStateChanged(ViewerStateChange change) {
            AtomicBoolean pendingUpdate = new AtomicBoolean();
            AtomicBoolean pendingRecreate = new AtomicBoolean();
            switch (change) {
                case CURRENT_SOURCE_CHANGED: 
                case SOURCE_ACTIVITY_CHANGED: 
                case VISIBILITY_CHANGED: {
                    SwingUtilities.invokeLater(this::update);
                    break;
                }
                case NUM_SOURCES_CHANGED: {
                    SwingUtilities.invokeLater(this::recreateContent);
                }
            }
        }

        private static /* synthetic */ void lambda$recreateContentNow$3(JCheckBox b, SourceAndConverter source, Set visible) {
            b.setSelected(visible.contains(source));
        }

        private static /* synthetic */ void lambda$recreateContentNow$2(JCheckBox b, SourceAndConverter source, Set active) {
            b.setSelected(active.contains(source));
        }

        private /* synthetic */ void lambda$recreateContentNow$1(SourceAndConverter source, JCheckBox b, ActionEvent e) {
            this.state.setSourceActive(source, b.isSelected());
        }

        private /* synthetic */ void lambda$recreateContentNow$0(JRadioButton b, SourceAndConverter source, ActionEvent e) {
            if (b.isSelected()) {
                this.state.setCurrentSource(source);
            }
        }
    }
}

