/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.AbstractTransformedBoxSelectionDialog;
import bdv.tools.boundingbox.BoxDisplayModePanel;
import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.boundingbox.BoxSelectionPanel;
import bdv.tools.boundingbox.TransformedBox;
import bdv.tools.boundingbox.TransformedBoxEditor;
import bdv.tools.boundingbox.TransformedBoxModel;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class TransformedBoxSelectionDialog
extends AbstractTransformedBoxSelectionDialog<Result> {
    private static final long serialVersionUID = 1L;
    protected final TransformedBoxModel model;
    protected final TransformedBoxEditor boxEditor;
    protected final JPanel content;
    protected final AbstractViewerPanel viewer;
    protected final BoxSelectionPanel boxSelectionPanel;
    protected final AbstractTransformedBoxSelectionDialog.TimepointSelectionPanel timepointSelectionPanel;
    protected final BoxSelectionOptions options;

    public TransformedBoxSelectionDialog(AbstractViewerPanel viewer, ConverterSetups converterSetups, int setupId, InputTriggerConfig keyConfig, TriggerBehaviourBindings triggerbindings, AffineTransform3D boxTransform, Interval initialInterval, Interval rangeInterval, BoxSelectionOptions options) {
        super(SwingUtilities.getWindowAncestor(viewer), options.values.getTitle());
        this.viewer = viewer;
        this.options = options;
        this.model = new TransformedBoxModel(initialInterval, boxTransform);
        this.boxEditor = new TransformedBoxEditor(keyConfig, viewer, converterSetups, setupId, triggerbindings, this.model);
        this.boxEditor.setPerspective(1.0, 1000.0);
        this.boxEditor.setEditable(true);
        this.boxSelectionPanel = new BoxSelectionPanel(this.model.box(), rangeInterval);
        this.timepointSelectionPanel = new AbstractTransformedBoxSelectionDialog.TimepointSelectionPanel(viewer, options);
        this.content = this.createContent();
        this.getContentPane().add((Component)this.content, "Center");
        this.pack();
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TransformedBoxSelectionDialog.this.boxEditor.install();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TransformedBoxSelectionDialog.this.boxEditor.uninstall();
            }
        });
        this.model.intervalChangedListeners().add(() -> {
            this.boxSelectionPanel.updateSliders(this.model.box().getInterval());
            viewer.getDisplayComponent().repaint();
        });
    }

    protected JPanel createContent() {
        JPanel content = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{80};
        layout.columnWeights = new double[]{1.0};
        content.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel lblTitle = new JLabel("Selection:");
        lblTitle.setFont(content.getFont().deriveFont(1));
        content.add((Component)lblTitle, gbc);
        ++gbc.gridy;
        JPanel boundsPanel = new JPanel();
        boundsPanel.setLayout(new BoxLayout(boundsPanel, 3));
        boundsPanel.add(this.boxSelectionPanel);
        if (this.timepointSelectionPanel.mode != BoxSelectionOptions.TimepointSelection.NONE) {
            boundsPanel.add(this.timepointSelectionPanel);
        }
        content.add((Component)boundsPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 512;
        gbc.fill = 0;
        BoxDisplayModePanel boxModePanel = new BoxDisplayModePanel(this.boxEditor.boxDisplayMode());
        content.add((Component)boxModePanel, gbc);
        return content;
    }

    @Override
    protected void createResult(boolean status) {
        int t0;
        int t1;
        switch (this.timepointSelectionPanel.mode) {
            default: {
                t1 = 0;
                t0 = 0;
                break;
            }
            case SINGLE: {
                t0 = t1 = this.timepointSelectionPanel.timeValue.getCurrentValue();
                break;
            }
            case RANGE: {
                t0 = this.timepointSelectionPanel.timeRange.getMinBoundedValue().getCurrentValue();
                t1 = this.timepointSelectionPanel.timeRange.getMaxBoundedValue().getCurrentValue();
            }
        }
        this.result = new Result(status, this.model, t0, t1);
    }

    public static class Result
    implements TransformedBox {
        private final boolean valid;
        private final Interval interval;
        private final int t0;
        private final int t1;
        private final AffineTransform3D transform;

        public Result(boolean valid, TransformedBoxModel model, int t0, int t1) {
            this.valid = valid;
            this.interval = new FinalInterval(model.box().getInterval());
            this.t0 = t0;
            this.t1 = t1;
            this.transform = new AffineTransform3D();
            model.getTransform(this.transform);
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public Interval getInterval() {
            return this.interval;
        }

        @Override
        public void getTransform(AffineTransform3D t) {
            t.set(this.transform);
        }

        public int getMinTimepoint() {
            return this.t0;
        }

        public int getMaxTimepoint() {
            return this.t1;
        }
    }
}

