/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.convertersetupeditor;

import bdv.ui.UIUtils;
import bdv.ui.rangeslider.RangeSlider;
import bdv.util.BoundedRange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import net.miginfocom.swing.MigLayout;
import org.scijava.listeners.Listeners;

class BoundedRangePanel
extends JPanel {
    private Supplier<JPopupMenu> popup;
    private BoundedRange range;
    private final RangeSlider rangeSlider;
    private static final int SLIDER_LENGTH = 10000;
    private final JSpinner minSpinner;
    private final JSpinner maxSpinner;
    private final JLabel upperBoundLabel;
    private final JLabel lowerBoundLabel;
    private final Listeners.List<ChangeListener> listeners = new Listeners.SynchronizedList();
    private boolean isConsistent = true;
    private Color consistentBg = Color.WHITE;
    private Color inConsistentBg = Color.WHITE;
    private boolean blockUpdates = false;

    public BoundedRangePanel() {
        this(new BoundedRange(0.0, 1.0, 0.0, 0.5));
    }

    public BoundedRangePanel(BoundedRange range) {
        this.setLayout((LayoutManager)new MigLayout("ins 5 5 5 10, fillx, filly, hidemode 3", "[][grow][][]", "[]0[]"));
        this.updateColors();
        this.minSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 1.0));
        this.maxSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1.0, 1.0));
        this.rangeSlider = new RangeSlider(0, 10000);
        this.upperBoundLabel = new JLabel();
        this.lowerBoundLabel = new JLabel();
        this.setupMinSpinner();
        this.setupMaxSpinner();
        this.setupRangeSlider();
        this.setupBoundLabels();
        this.setupPopupMenu();
        this.add((Component)this.minSpinner, "sy 2");
        this.add((Component)this.rangeSlider, "growx, sy 2");
        this.add((Component)this.maxSpinner, "sy 2");
        this.add((Component)this.upperBoundLabel, "right, wrap");
        this.add((Component)this.lowerBoundLabel, "right");
        this.setRange(range);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.minSpinner != null) {
            this.minSpinner.setEnabled(enabled);
        }
        if (this.rangeSlider != null) {
            this.rangeSlider.setEnabled(enabled);
        }
        if (this.maxSpinner != null) {
            this.maxSpinner.setEnabled(enabled);
        }
        if (this.upperBoundLabel != null) {
            this.upperBoundLabel.setEnabled(enabled);
        }
        if (this.lowerBoundLabel != null) {
            this.lowerBoundLabel.setEnabled(enabled);
        }
    }

    @Override
    public void updateUI() {
        JPopupMenu menu;
        super.updateUI();
        this.updateColors();
        if (!this.isConsistent) {
            this.setBackground(this.inConsistentBg);
        }
        if (this.popup != null && (menu = this.popup.get()) != null) {
            SwingUtilities.updateComponentTreeUI(menu);
        }
        if (this.upperBoundLabel != null) {
            this.updateBoundLabelFonts();
        }
    }

    private void updateColors() {
        this.consistentBg = UIManager.getColor("Panel.background");
        this.inConsistentBg = UIUtils.mix(this.consistentBg, Color.red, 0.9);
    }

    public void setConsistent(boolean isConsistent) {
        this.isConsistent = isConsistent;
        this.setBackground(isConsistent ? this.consistentBg : this.inConsistentBg);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.minSpinner != null) {
            this.minSpinner.setBackground(bg);
        }
        if (this.rangeSlider != null) {
            this.rangeSlider.setBackground(bg);
        }
        if (this.maxSpinner != null) {
            this.maxSpinner.setBackground(bg);
        }
        if (this.upperBoundLabel != null) {
            this.upperBoundLabel.setBackground(bg);
        }
        if (this.lowerBoundLabel != null) {
            this.lowerBoundLabel.setBackground(bg);
        }
    }

    private void setupMinSpinner() {
        UIUtils.setPreferredWidth(this.minSpinner, 70);
        this.minSpinner.addChangeListener(e -> {
            double value = (Double)this.minSpinner.getValue();
            if (value != this.range.getMin()) {
                this.updateRange(this.range.withMin(value));
            }
        });
        this.minSpinner.setEditor(new UnboundedNumberEditor(this.minSpinner));
    }

    private void setupMaxSpinner() {
        UIUtils.setPreferredWidth(this.maxSpinner, 70);
        this.maxSpinner.addChangeListener(e -> {
            double value = (Double)this.maxSpinner.getValue();
            if (value != this.range.getMax()) {
                this.updateRange(this.range.withMax(value));
            }
        });
        this.maxSpinner.setEditor(new UnboundedNumberEditor(this.maxSpinner));
    }

    private void setupRangeSlider() {
        UIUtils.setPreferredWidth(this.rangeSlider, 50);
        this.rangeSlider.setRange(0, 10000);
        this.rangeSlider.setFocusable(false);
        this.rangeSlider.addChangeListener(e -> this.updateRange(this.range.withMin(this.posToValue(this.rangeSlider.getValue())).withMax(this.posToValue(this.rangeSlider.getUpperValue()))));
        this.rangeSlider.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BoundedRangePanel.this.updateNumberFormat();
            }
        });
    }

    private void setupBoundLabels() {
        this.upperBoundLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.lowerBoundLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.updateBoundLabelFonts();
    }

    private void updateBoundLabelFonts() {
        Font labelFont = UIManager.getFont("Label.font");
        Font font = new Font(labelFont.getName(), labelFont.getStyle(), 10);
        this.upperBoundLabel.setFont(font);
        this.lowerBoundLabel.setFont(font);
    }

    private void setupPopupMenu() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 1 && e.getX() > BoundedRangePanel.this.upperBoundLabel.getX()) {
                    this.doPop(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPop(e);
                }
            }

            private void doPop(MouseEvent e) {
                JPopupMenu menu;
                if (BoundedRangePanel.this.isEnabled() && BoundedRangePanel.this.popup != null && (menu = (JPopupMenu)BoundedRangePanel.this.popup.get()) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(ml);
        this.rangeSlider.addMouseListener(ml);
    }

    private double posToValue(int pos) {
        double dmin = this.range.getMinBound();
        double dmax = this.range.getMaxBound();
        return (double)pos * (dmax - dmin) / 10000.0 + dmin;
    }

    private int valueToPos(double value) {
        double dmin = this.range.getMinBound();
        double dmax = this.range.getMaxBound();
        return (int)Math.round((value - dmin) * 10000.0 / (dmax - dmin));
    }

    private synchronized void updateNumberFormat() {
        int sw = this.rangeSlider.getWidth();
        if (sw > 0) {
            double vrange = this.range.getMaxBound() - this.range.getMinBound();
            int digits = (int)Math.ceil(Math.log10((double)sw / vrange));
            this.blockUpdates = true;
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.minSpinner.getEditor();
            numberEditor.getFormat().setMaximumFractionDigits(digits);
            numberEditor.stateChanged(new ChangeEvent(this.minSpinner));
            numberEditor = (JSpinner.NumberEditor)this.maxSpinner.getEditor();
            numberEditor.getFormat().setMaximumFractionDigits(digits);
            numberEditor.stateChanged(new ChangeEvent(this.maxSpinner));
            this.blockUpdates = false;
        }
    }

    private synchronized void updateRange(BoundedRange newRange) {
        if (!this.blockUpdates) {
            this.setRange(newRange);
        }
    }

    public synchronized void setRange(BoundedRange range) {
        if (Objects.equals(this.range, range)) {
            return;
        }
        this.range = range;
        this.blockUpdates = true;
        double minBound = range.getMinBound();
        double maxBound = range.getMaxBound();
        SpinnerNumberModel minSpinnerModel = (SpinnerNumberModel)this.minSpinner.getModel();
        minSpinnerModel.setMinimum(Double.valueOf(minBound));
        minSpinnerModel.setMaximum(Double.valueOf(maxBound));
        minSpinnerModel.setValue(range.getMin());
        SpinnerNumberModel maxSpinnerModel = (SpinnerNumberModel)this.maxSpinner.getModel();
        maxSpinnerModel.setMinimum(Double.valueOf(minBound));
        maxSpinnerModel.setMaximum(Double.valueOf(maxBound));
        maxSpinnerModel.setValue(range.getMax());
        this.rangeSlider.setRange(this.valueToPos(range.getMin()), this.valueToPos(range.getMax()));
        double frac = Math.max(Math.abs((double)Math.round(minBound) - minBound), Math.abs((double)Math.round(maxBound) - maxBound));
        String format = frac > 0.005 ? "%.2f" : "%.0f";
        this.upperBoundLabel.setText(String.format(format, maxBound));
        this.lowerBoundLabel.setText(String.format(format, minBound));
        this.invalidate();
        this.blockUpdates = false;
        this.listeners.list.forEach(ChangeListener::boundedRangeChanged);
    }

    public BoundedRange getRange() {
        return this.range;
    }

    public Listeners<ChangeListener> changeListeners() {
        return this.listeners;
    }

    public void setPopup(Supplier<JPopupMenu> popup) {
        this.popup = popup;
    }

    public void shrinkBoundsToRange() {
        this.updateRange(this.range.withMinBound(this.range.getMin()).withMaxBound(this.range.getMax()));
    }

    public void setBoundsDialog() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JSpinner minSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 1.0));
        JSpinner maxSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 1.0));
        minSpinner.setEditor(new UnboundedNumberEditor(minSpinner));
        maxSpinner.setEditor(new UnboundedNumberEditor(maxSpinner));
        minSpinner.setValue(this.range.getMinBound());
        maxSpinner.setValue(this.range.getMaxBound());
        minSpinner.addChangeListener(e -> {
            double value = (Double)minSpinner.getValue();
            if (value > (Double)maxSpinner.getValue()) {
                maxSpinner.setValue(value);
            }
        });
        maxSpinner.addChangeListener(e -> {
            double value = (Double)maxSpinner.getValue();
            if (value < (Double)minSpinner.getValue()) {
                minSpinner.setValue(value);
            }
        });
        panel.add("right", new JLabel("min"));
        panel.add("growx, wrap", minSpinner);
        panel.add("right", new JLabel("max"));
        panel.add("growx", maxSpinner);
        int result = JOptionPane.showConfirmDialog(null, panel, "Set Bounds", 2, -1);
        if (result == 0) {
            double min = (Double)minSpinner.getValue();
            double max = (Double)maxSpinner.getValue();
            this.updateRange(this.range.withMinBound(min).withMaxBound(max));
        }
    }

    private static class UnboundedNumberEditor
    extends JSpinner.NumberEditor {
        public UnboundedNumberEditor(JSpinner spinner) {
            super(spinner);
            JFormattedTextField ftf = this.getTextField();
            DecimalFormat format = (DecimalFormat)((NumberFormatter)ftf.getFormatter()).getFormat();
            NumberFormatter formatter = new NumberFormatter(format);
            formatter.setValueClass(spinner.getValue().getClass());
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            ftf.setFormatterFactory(factory);
        }
    }

    public static interface ChangeListener {
        public void boundedRangeChanged();
    }
}

