/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.keymap;

import bdv.ui.keymap.AbstractKeymapManager;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SelectAndEditProfileSettingsPage;
import bdv.ui.settings.style.StyleProfile;
import bdv.ui.settings.style.StyleProfileManager;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.io.gui.VisualEditorPanel;

public class KeymapSettingsPage
extends SelectAndEditProfileSettingsPage<StyleProfile<Keymap>> {
    public KeymapSettingsPage(String treePath, KeymapManager styleManager, CommandDescriptions commandDescriptions) {
        this(treePath, styleManager, new KeymapManager(), commandDescriptions);
    }

    public <M extends AbstractKeymapManager<M>> KeymapSettingsPage(String treePath, M styleManager, M editingStyleManager, CommandDescriptions commandDescriptions) {
        super(treePath, new StyleProfileManager(styleManager, editingStyleManager), new KeymapProfileEditPanel((Keymap)styleManager.getSelectedStyle(), commandDescriptions));
    }

    static class KeymapProfileEditPanel
    implements SelectAndEditProfileSettingsPage.ProfileEditPanel<StyleProfile<Keymap>> {
        private final Listeners.SynchronizedList<ModificationListener> modificationListeners;
        private final Keymap editedStyle;
        private final VisualEditorPanel styleEditorPanel;
        private boolean trackModifications = true;

        public KeymapProfileEditPanel(Keymap initialStyle, CommandDescriptions commandDescriptions) {
            this.editedStyle = initialStyle.copy("Edited");
            this.styleEditorPanel = new VisualEditorPanel(this.editedStyle.getConfig(), commandDescriptions.createCommandDescriptionsMap());
            this.styleEditorPanel.setButtonPanelVisible(false);
            this.modificationListeners = new Listeners.SynchronizedList();
            this.styleEditorPanel.modelChangedListeners().add(() -> {
                this.styleEditorPanel.modelToConfig();
                if (this.trackModifications) {
                    this.modificationListeners.list.forEach(ModificationListener::setModified);
                }
            });
            this.styleEditorPanel.setPreferredSize(new Dimension(200, 200));
        }

        @Override
        public void loadProfile(StyleProfile<Keymap> profile) {
            this.trackModifications = false;
            this.editedStyle.set(profile.getStyle());
            this.styleEditorPanel.configToModel();
            this.trackModifications = true;
        }

        @Override
        public void storeProfile(StyleProfile<Keymap> profile) {
            this.trackModifications = false;
            this.styleEditorPanel.modelToConfig();
            this.editedStyle.setName(profile.getStyle().getName());
            this.trackModifications = true;
            profile.getStyle().set(this.editedStyle);
        }

        @Override
        public Listeners<ModificationListener> modificationListeners() {
            return this.modificationListeners;
        }

        @Override
        public JPanel getJPanel() {
            return this.styleEditorPanel;
        }
    }
}

