/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.LongStream;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

public enum AxisOrder implements EuclideanSpace
{
    XYZ(3, 2, -1, -1),
    XYZC(4, 2, 3, -1),
    XYZT(4, 2, -1, 3),
    XYZCT(5, 2, 3, 4),
    XYZTC(5, 2, 4, 3),
    XYCZT(5, 3, 2, 4),
    XY(2, -1, -1, -1),
    XYC(3, -1, 2, -1),
    XYT(3, -1, -1, 2),
    XYCT(4, -1, 2, 3),
    XYTC(4, -1, 3, 2),
    XYCZ(4, 3, 2, -1),
    DEFAULT(0, 0, 0, 0);

    final int numDimensions;
    final int zDimension;
    final int channelDimension;
    final int timeDimension;

    private AxisOrder(int numDimensions, int zDimension, int channelDimension, int timeDimension) {
        this.numDimensions = numDimensions;
        this.zDimension = zDimension;
        this.channelDimension = channelDimension;
        this.timeDimension = timeDimension;
    }

    public static AxisOrder getAxisOrder(AxisOrder axisOrder, EuclideanSpace space, boolean viewerIs2D) {
        if (axisOrder == DEFAULT) {
            if (viewerIs2D) {
                switch (space.numDimensions()) {
                    case 2: {
                        return XY;
                    }
                    case 3: {
                        return XYT;
                    }
                    case 4: {
                        return XYTC;
                    }
                    case 5: {
                        return XYZTC;
                    }
                }
            } else {
                switch (space.numDimensions()) {
                    case 2: {
                        return XY;
                    }
                    case 3: {
                        return XYZ;
                    }
                    case 4: {
                        return XYZT;
                    }
                    case 5: {
                        return XYZTC;
                    }
                }
            }
            throw new IllegalArgumentException("image dimensionality " + space.numDimensions() + " is not supported");
        }
        return axisOrder;
    }

    public static <T> ArrayList<RandomAccessibleInterval<T>> splitInputStackIntoSourceStacks(RandomAccessibleInterval<T> img, AxisOrder axisOrder) {
        boolean flipZ;
        boolean addZ;
        if (img.numDimensions() != axisOrder.numDimensions) {
            throw new IllegalArgumentException("provided AxisOrder doesn't match dimensionality of image");
        }
        ArrayList<RandomAccessibleInterval<T>> sourceStacks = new ArrayList<RandomAccessibleInterval<T>>();
        int c = axisOrder.channelDimension;
        if (c != -1) {
            int numSlices = (int)img.dimension(c);
            for (int s = 0; s < numSlices; ++s) {
                sourceStacks.add(Views.hyperSlice(img, c, (long)s + img.min(c)));
            }
        } else {
            sourceStacks.add(img);
        }
        boolean bl = addZ = !axisOrder.hasZ();
        if (addZ) {
            for (int i = 0; i < sourceStacks.size(); ++i) {
                sourceStacks.set(i, Views.addDimension(sourceStacks.get(i), 0L, 0L));
            }
        }
        boolean bl2 = flipZ = !axisOrder.hasZ() && axisOrder.hasTimepoints();
        if (flipZ) {
            for (int i = 0; i < sourceStacks.size(); ++i) {
                sourceStacks.set(i, Views.permute(sourceStacks.get(i), 2, 3));
            }
        }
        return sourceStacks;
    }

    public static <T> Pair<ArrayList<RandomAccessible<T>>, Interval> splitInputStackIntoSourceStacks(RandomAccessible<T> img, Interval interval, AxisOrder axisOrder) {
        boolean flipZ;
        boolean addZ;
        if (img.numDimensions() != axisOrder.numDimensions) {
            throw new IllegalArgumentException("provided AxisOrder doesn't match dimensionality of image");
        }
        ArrayList<RandomAccessible<T>> sourceStacks = new ArrayList<RandomAccessible<T>>();
        int c = axisOrder.channelDimension;
        if (c != -1) {
            long[] min = new long[interval.numDimensions() - 1];
            long[] max = new long[interval.numDimensions() - 1];
            for (int dim = 0; dim < min.length; ++dim) {
                int otherIndex = dim >= axisOrder.channelDimension ? dim + 1 : dim;
                min[dim] = interval.min(otherIndex);
                max[dim] = interval.max(otherIndex);
            }
            interval = new FinalInterval(min, max);
            int numSlices = (int)interval.dimension(c);
            for (int s = 0; s < numSlices; ++s) {
                sourceStacks.add(Views.hyperSlice(img, c, (long)s + interval.min(c)));
            }
        } else {
            sourceStacks.add(img);
        }
        boolean bl = addZ = !axisOrder.hasZ();
        if (addZ) {
            long[] min = LongStream.concat(Arrays.stream(Intervals.minAsLongArray(interval)), LongStream.of(0L)).toArray();
            long[] max = LongStream.concat(Arrays.stream(Intervals.maxAsLongArray(interval)), LongStream.of(0L)).toArray();
            interval = new FinalInterval(min, max);
            for (int i = 0; i < sourceStacks.size(); ++i) {
                sourceStacks.set(i, Views.addDimension((RandomAccessible)sourceStacks.get(i)));
            }
        }
        boolean bl2 = flipZ = !axisOrder.hasZ() && axisOrder.hasTimepoints();
        if (flipZ) {
            long[] min = Intervals.minAsLongArray(interval);
            long[] max = Intervals.maxAsLongArray(interval);
            long minTmp = min[3];
            long maxTmp = max[3];
            min[3] = min[2];
            max[3] = max[2];
            min[2] = minTmp;
            max[2] = maxTmp;
            interval = new FinalInterval(min, max);
            for (int i = 0; i < sourceStacks.size(); ++i) {
                sourceStacks.set(i, Views.permute((RandomAccessible)sourceStacks.get(i), 2, 3));
            }
        }
        return new ValuePair<ArrayList<RandomAccessible<T>>, Interval>(sourceStacks, interval);
    }

    public int zDimension() {
        return this.zDimension;
    }

    public boolean hasZ() {
        return this.zDimension >= 0;
    }

    public int channelDimension() {
        return this.channelDimension;
    }

    public boolean hasChannels() {
        return this.channelDimension >= 0;
    }

    public long numChannels(Dimensions dimensions) {
        return this.hasChannels() ? dimensions.dimension(this.channelDimension) : 1L;
    }

    public int timeDimension() {
        return this.timeDimension;
    }

    public boolean hasTimepoints() {
        return this.timeDimension >= 0;
    }

    public long numTimepoints(Dimensions dimensions) {
        return this.hasTimepoints() ? dimensions.dimension(this.timeDimension) : 1L;
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }
}

