/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

public class BoundedValueDouble {
    private double rangeMin;
    private double rangeMax;
    private double currentValue;
    private UpdateListener updateListener;

    public BoundedValueDouble(double rangeMin, double rangeMax, double currentValue) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.currentValue = currentValue;
        this.updateListener = null;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void setRange(double min, double max) {
        assert (min <= max);
        this.rangeMin = min;
        this.rangeMax = max;
        this.currentValue = Math.min(Math.max(this.currentValue, min), max);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public void setCurrentValue(double value) {
        this.currentValue = value;
        if (this.currentValue < this.rangeMin) {
            this.currentValue = this.rangeMin;
        } else if (this.currentValue > this.rangeMax) {
            this.currentValue = this.rangeMax;
        }
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public void setUpdateListener(UpdateListener l) {
        this.updateListener = l;
    }

    public static interface UpdateListener {
        public void update();
    }
}

