/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.BoundedRange;
import bdv.util.Bounds;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceToConverterSetupBimap;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.volatiles.VolatileARGBType;

public class ConverterSetupBounds {
    private final SourceToConverterSetupBimap bimap;
    private final Map<ConverterSetup, Bounds> setupToBounds = new HashMap<ConverterSetup, Bounds>();

    ConverterSetupBounds(SourceToConverterSetupBimap bimap) {
        this.bimap = bimap;
    }

    public Bounds getBounds(ConverterSetup setup) {
        return this.setupToBounds.compute(setup, this::getExtendedBounds);
    }

    public void setBounds(ConverterSetup setup, Bounds bounds) {
        this.setupToBounds.put(setup, bounds);
        double min = setup.getDisplayRangeMin();
        double max = setup.getDisplayRangeMax();
        BoundedRange range = new BoundedRange(min, max, min, max).withMinBound(bounds.getMinBound()).withMaxBound(bounds.getMaxBound());
        if (range.getMin() != min || range.getMax() != max) {
            setup.setDisplayRange(range.getMin(), range.getMax());
        }
    }

    private Bounds getDefaultBounds(ConverterSetup setup) {
        Bounds bounds = new Bounds(setup.getDisplayRangeMin(), setup.getDisplayRangeMax());
        SourceAndConverter<?> source = this.bimap.getSource(setup);
        if (source != null) {
            Object type = source.getSpimSource().getType();
            if (type instanceof ARGBType || type instanceof VolatileARGBType) {
                bounds = bounds.join(new Bounds(0.0, 255.0));
            } else if (type instanceof IntegerType) {
                IntegerType integerType = (IntegerType)type;
                bounds = bounds.join(new Bounds(integerType.getMinValue(), integerType.getMaxValue()));
            } else {
                bounds = bounds.join(new Bounds(0.0, 1.0));
            }
        }
        return bounds;
    }

    private Bounds getExtendedBounds(ConverterSetup setup, Bounds bounds) {
        if (bounds == null) {
            bounds = this.getDefaultBounds(setup);
        }
        return bounds.join(new Bounds(setup.getDisplayRangeMin(), setup.getDisplayRangeMax()));
    }
}

