/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.TransformEventHandler2D;
import bdv.TransformEventHandler3D;
import bdv.TransformEventHandlerFactory;
import bdv.ui.UIUtils;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.viewer.animate.MessageOverlayAnimator;
import bdv.viewer.render.AccumulateProjectorARGB;
import bdv.viewer.render.AccumulateProjectorFactory;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.ui.behaviour.KeyPressedManager;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class ViewerOptions {
    public final Values values = new Values();

    public static ViewerOptions options() {
        return new ViewerOptions();
    }

    public ViewerOptions width(int w) {
        this.values.width = w;
        return this;
    }

    public ViewerOptions height(int h) {
        this.values.height = h;
        return this;
    }

    public ViewerOptions screenScales(double[] s) {
        Values.access$202(this.values, s);
        return this;
    }

    public ViewerOptions targetRenderNanos(long t) {
        this.values.targetRenderNanos = t;
        return this;
    }

    public ViewerOptions numRenderingThreads(int n) {
        this.values.numRenderingThreads = n;
        return this;
    }

    public ViewerOptions numSourceGroups(int n) {
        this.values.numSourceGroups = n;
        return this;
    }

    public ViewerOptions useVolatileIfAvailable(boolean v) {
        this.values.useVolatileIfAvailable = v;
        return this;
    }

    public ViewerOptions msgOverlay(MessageOverlayAnimator o) {
        this.values.msgOverlay = o;
        return this;
    }

    public ViewerOptions transformEventHandlerFactory(TransformEventHandlerFactory f) {
        this.values.transformEventHandlerFactory = f;
        return this;
    }

    public ViewerOptions is2D(boolean is2D) {
        this.values.is2D = is2D;
        this.transformEventHandlerFactory(is2D ? TransformEventHandler2D::new : TransformEventHandler3D::new);
        return this;
    }

    public ViewerOptions accumulateProjectorFactory(AccumulateProjectorFactory<ARGBType> f) {
        this.values.accumulateProjectorFactory = f;
        return this;
    }

    public ViewerOptions inputTriggerConfig(InputTriggerConfig c) {
        this.values.inputTriggerConfig = c;
        return this;
    }

    public ViewerOptions shareKeyPressedEvents(KeyPressedManager manager) {
        this.values.keyPressedManager = manager;
        return this;
    }

    public ViewerOptions keymapManager(KeymapManager keymapManager) {
        this.values.keymapManager = keymapManager;
        return this;
    }

    public ViewerOptions appearanceManager(AppearanceManager appearanceManager) {
        this.values.appearanceManager = appearanceManager;
        return this;
    }

    public static class Values {
        private int width = (int)Math.round(800.0 * UIUtils.getUIScaleFactor(this));
        private int height = (int)Math.round(600.0 * UIUtils.getUIScaleFactor(this));
        private double[] screenScales = new double[]{1.0, 0.75, 0.5, 0.25, 0.125};
        private long targetRenderNanos = 30000000L;
        private int numRenderingThreads = Runtime.getRuntime().availableProcessors();
        private int numSourceGroups = 10;
        private boolean useVolatileIfAvailable = true;
        private MessageOverlayAnimator msgOverlay = new MessageOverlayAnimator(800L);
        private TransformEventHandlerFactory transformEventHandlerFactory = TransformEventHandler3D::new;
        private boolean is2D = false;
        private AccumulateProjectorFactory<ARGBType> accumulateProjectorFactory = AccumulateProjectorARGB.factory;
        private InputTriggerConfig inputTriggerConfig = null;
        private KeyPressedManager keyPressedManager = null;
        private KeymapManager keymapManager = null;
        private AppearanceManager appearanceManager = null;

        public ViewerOptions optionsFromValues() {
            return new ViewerOptions().width(this.width).height(this.height).screenScales(this.screenScales).targetRenderNanos(this.targetRenderNanos).numRenderingThreads(this.numRenderingThreads).numSourceGroups(this.numSourceGroups).useVolatileIfAvailable(this.useVolatileIfAvailable).msgOverlay(this.msgOverlay).is2D(this.is2D).transformEventHandlerFactory(this.transformEventHandlerFactory).accumulateProjectorFactory(this.accumulateProjectorFactory).inputTriggerConfig(this.inputTriggerConfig).shareKeyPressedEvents(this.keyPressedManager).keymapManager(this.keymapManager).appearanceManager(this.appearanceManager);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public double[] getScreenScales() {
            return this.screenScales;
        }

        public long getTargetRenderNanos() {
            return this.targetRenderNanos;
        }

        public int getNumRenderingThreads() {
            return this.numRenderingThreads;
        }

        public int getNumSourceGroups() {
            return this.numSourceGroups;
        }

        public boolean isUseVolatileIfAvailable() {
            return this.useVolatileIfAvailable;
        }

        public MessageOverlayAnimator getMsgOverlay() {
            return this.msgOverlay;
        }

        public TransformEventHandlerFactory getTransformEventHandlerFactory() {
            return this.transformEventHandlerFactory;
        }

        public boolean is2D() {
            return this.is2D;
        }

        public AccumulateProjectorFactory<ARGBType> getAccumulateProjectorFactory() {
            return this.accumulateProjectorFactory;
        }

        public InputTriggerConfig getInputTriggerConfig() {
            return this.inputTriggerConfig;
        }

        public KeyPressedManager getKeyPressedManager() {
            return this.keyPressedManager;
        }

        public KeymapManager getKeymapManager() {
            return this.keymapManager;
        }

        public AppearanceManager getAppearanceManager() {
            return this.appearanceManager;
        }

        static /* synthetic */ double[] access$202(Values x0, double[] x1) {
            x0.screenScales = x1;
            return x1;
        }
    }
}

