/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.ui.UIUtils;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.overlay.IntervalAndTransform;
import bdv.viewer.overlay.MultiBoxOverlay;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;

public class MultiBoxOverlayRenderer {
    protected final MultiBoxOverlay box;
    protected Interval boxInterval = Intervals.createMinSize(10L, 10L, 160L, 120L);
    protected Interval virtualScreenInterval;
    protected final ArrayList<IntervalAndTransform> boxSources;

    public MultiBoxOverlayRenderer() {
        this(800, 600);
    }

    public MultiBoxOverlayRenderer(int screenWidth, int screenHeight) {
        this.box = new MultiBoxOverlay();
        this.virtualScreenInterval = Intervals.createMinSize(0L, 0L, screenWidth, screenHeight);
        this.boxSources = new ArrayList();
    }

    public synchronized void paint(Graphics2D g) {
        double uiScale = UIUtils.getUIScaleFactor(this);
        FinalInterval paintInterval = Intervals.createMinSize((int)Math.round((double)this.boxInterval.min(0) * uiScale), (int)Math.round((double)this.boxInterval.min(1) * uiScale), (int)Math.round((double)this.boxInterval.dimension(0) * uiScale), (int)Math.round((double)this.boxInterval.dimension(1) * uiScale));
        this.box.paint(g, this.boxSources, this.virtualScreenInterval, paintInterval);
    }

    public boolean isHighlightInProgress() {
        return this.box.isHighlightInProgress();
    }

    public void highlight(int sourceIndex) {
        this.box.highlight(sourceIndex);
    }

    public synchronized void updateVirtualScreenSize(int screenWidth, int screenHeight) {
        long oldW = this.virtualScreenInterval.dimension(0);
        long oldH = this.virtualScreenInterval.dimension(1);
        if ((long)screenWidth != oldW || (long)screenHeight != oldH) {
            this.virtualScreenInterval = Intervals.createMinSize(0L, 0L, screenWidth, screenHeight);
        }
    }

    public synchronized void setBoxInterval(Interval interval) {
        this.boxInterval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void setViewerState(bdv.viewer.state.ViewerState viewerState) {
        bdv.viewer.state.ViewerState viewerState2 = viewerState;
        synchronized (viewerState2) {
            this.setViewerState(viewerState.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setViewerState(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            List<SourceAndConverter<?>> sources = state.getSources();
            int timepoint = state.getCurrentTimepoint();
            ArrayList presentSources = new ArrayList();
            sources.forEach(s -> {
                if (s.getSpimSource().isPresent(timepoint)) {
                    presentSources.add(s);
                }
            });
            int numPresentSources = presentSources.size();
            if (this.boxSources.size() != numPresentSources) {
                while (this.boxSources.size() < numPresentSources) {
                    this.boxSources.add(new IntervalAndTransform());
                }
                while (this.boxSources.size() > numPresentSources) {
                    this.boxSources.remove(this.boxSources.size() - 1);
                }
            }
            AffineTransform3D sourceToViewer = state.getViewerTransform();
            AffineTransform3D sourceTransform = new AffineTransform3D();
            int i = 0;
            for (SourceAndConverter source : presentSources) {
                IntervalAndTransform boxsource = this.boxSources.get(i++);
                source.getSpimSource().getSourceTransform(timepoint, 0, sourceTransform);
                sourceTransform.preConcatenate(sourceToViewer);
                boxsource.setSourceToViewer(sourceTransform);
                boxsource.setSourceInterval(source.getSpimSource().getSource(timepoint, 0));
                boxsource.setVisible(state.isSourceVisible(source));
            }
        }
    }
}

