/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.gui.ImprovedFormattedTextField;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import bigwarp.BigWarp;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.Common;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;

public class TransformGraphPanel
extends JPanel
implements ViewerStateChangeListener {
    public static final String DEFAULT_COORDINATE_SYSTEM = "<DEFAULT>";
    private static final long serialVersionUID = 3848019442560524183L;
    private static final String TRANSFORM_SOURCE_HELP_TEXT = "Select a container containing transformations.";
    private static final String COORD_SYSTEMS_HELP_TEXT = "All available coordinate systems.";
    private static final ViewerStateChange CURRENT_SOURCE_CHANGED = null;
    private final BigWarp<?> bw;
    private final ImprovedFormattedTextField transformGraphSourceText;
    private final JLabel destCoordinateSystemLabel;
    private final JComboBox<String> destCoordinateSystemsDropdown;
    private N5Reader n5;
    private TransformGraph graph;
    private boolean active;
    private final ViewerPanel viewerPanel;
    private HashMap<SourceAndConverter<?>, String> sourceToCoordinateSystems;

    public TransformGraphPanel(final BigWarp<?> bw, ViewerPanel viewerPanel, Container content) {
        super(new GridBagLayout());
        this.bw = bw;
        this.active = true;
        this.viewerPanel = viewerPanel;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transformation database"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.destCoordinateSystemsDropdown = new JComboBox<String>(new String[]{DEFAULT_COORDINATE_SYSTEM});
        JLabel srcDirLabel = new JLabel("Directory");
        File startingFolder = bw.getBigwarpSettingsFolder();
        this.transformGraphSourceText = new ImprovedFormattedTextField(new MessageFormat("{0}"));
        this.transformGraphSourceText.setCallback(() -> {
            this.active = false;
            try {
                N5URI n5uri = new N5URI(this.transformGraphSourceText.getText());
                this.n5 = new N5Factory().gsonBuilder(Common.gsonBuilder()).openReader(n5uri.getContainerPath());
                this.graph = Common.openGraph((N5Reader)this.n5, (String)n5uri.getGroupPath());
            }
            catch (Exception e) {
                this.graph = null;
            }
            if (this.graph != null) {
                this.destCoordinateSystemsDropdown.removeAllItems();
                HashSet coordinateSystems = new HashSet();
                this.graph.getTransforms().stream().forEach(t -> {
                    coordinateSystems.add(t.getInput());
                    coordinateSystems.add(t.getOutput());
                });
                this.destCoordinateSystemsDropdown.addItem(DEFAULT_COORDINATE_SYSTEM);
                coordinateSystems.forEach(x -> this.destCoordinateSystemsDropdown.addItem((String)x));
                this.destCoordinateSystemsDropdown.setSelectedIndex(0);
            }
            this.active = true;
        });
        JButton browseBtn = new JButton("Browse");
        browseBtn.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setCurrentDirectory(startingFolder);
            int ret = fileChooser.showOpenDialog(content);
            if (ret == 0) {
                File folder = fileChooser.getSelectedFile();
                this.transformGraphSourceText.setText(folder.getAbsolutePath());
            }
        });
        this.destCoordinateSystemLabel = new JLabel("Coordinate system");
        this.destCoordinateSystemLabel.setToolTipText(TRANSFORM_SOURCE_HELP_TEXT);
        this.destCoordinateSystemsDropdown.setToolTipText(COORD_SYSTEMS_HELP_TEXT);
        this.destCoordinateSystemsDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransformGraphPanel.this.active) {
                    String cs = (String)TransformGraphPanel.this.destCoordinateSystemsDropdown.getSelectedItem();
                    System.out.println("coordinateSystem: " + cs);
                    bw.transformationsFromCoordinateSystem();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)srcDirLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.transformGraphSourceText, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 22;
        this.add((Component)browseBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.destCoordinateSystemLabel, gbc);
        gbc.gridx = 1;
        this.add(this.destCoordinateSystemsDropdown, gbc);
    }

    public TransformGraph getGraph() {
        return this.graph;
    }

    public N5Reader getN5() {
        return this.n5;
    }

    public JComboBox<String> getDestinationCoordinateSystemsDropdown() {
        return this.destCoordinateSystemsDropdown;
    }

    public JTextField getTransformSource() {
        return this.transformGraphSourceText;
    }

    public void setDestinationCoordinateSystem(String coordinateSystem) {
        this.destCoordinateSystemsDropdown.setSelectedItem(coordinateSystem);
    }

    public String getCoordinateSystem() {
        return (String)this.destCoordinateSystemsDropdown.getSelectedItem();
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }

    public void initializeSourceCoordinateSystems() {
        this.sourceToCoordinateSystems.clear();
    }

    public void updateSourceDropdownOnSourceChange() {
    }

    public void updateSourceCoordinateSystemMap() {
        this.sourceToCoordinateSystems.put(this.viewerPanel.state().getCurrentSource(), COORD_SYSTEMS_HELP_TEXT);
    }

    public void viewerStateChanged(ViewerStateChange change) {
    }
}

