/*
 * Decompiled with CFR 0.152.
 */
package bdv.img;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.DefaultMipmapOrdering;
import bdv.viewer.render.MipmapOrdering;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.view.Views;

public class WarpedSource<T>
implements Source<T>,
MipmapOrdering {
    private final Source<T> source;
    private final String suffix;
    private final MipmapOrdering sourceMipmapOrdering;
    private InvertibleRealTransform xfm;
    private Interval[] boundingIntervalsPerLevel;
    private boolean isTransformed;
    private final Supplier<Boolean> boundingBoxCullingSupplier;
    private final AffineTransform3D tmpSrcTransform;
    private BoundingBoxEstimation bboxEst;

    public static <T> SourceAndConverter<T> wrap(SourceAndConverter<T> wrap, String name, int ndims) {
        return new SourceAndConverter(new WarpedSource<T>(wrap.getSpimSource(), name), wrap.getConverter(), wrap.asVolatile() == null ? null : WarpedSource.wrap(wrap.asVolatile(), name, ndims));
    }

    public WarpedSource(Source<T> source, String suffix) {
        this(source, suffix, null);
    }

    public WarpedSource(Source<T> source, String suffix, Supplier<Boolean> doBoundingBoxCulling) {
        this.source = source;
        this.suffix = suffix;
        this.isTransformed = false;
        this.boundingBoxCullingSupplier = doBoundingBoxCulling;
        this.xfm = null;
        this.bboxEst = new BoundingBoxEstimation(BoundingBoxEstimation.Method.FACES, 5);
        this.boundingIntervalsPerLevel = new Interval[source.getNumMipmapLevels()];
        this.tmpSrcTransform = new AffineTransform3D();
        this.sourceMipmapOrdering = MipmapOrdering.class.isInstance(source) ? (MipmapOrdering)source : new DefaultMipmapOrdering(source);
        this.updateBoundingIntervals();
    }

    public boolean isPresent(int t) {
        return this.source.isPresent(t);
    }

    public boolean doBoundingBoxCulling() {
        if (this.boundingBoxCullingSupplier != null) {
            return this.boundingBoxCullingSupplier.get();
        }
        return !this.isTransformed && this.source.doBoundingBoxCulling();
    }

    public void updateTransform(RealTransform xfm) {
        this.xfm = xfm instanceof InvertibleRealTransform ? (InvertibleRealTransform)xfm : new WrappedIterativeInvertibleRealTransform(xfm);
        this.updateBoundingIntervals();
    }

    protected void updateBoundingIntervals() {
        for (int i = 0; i < this.getNumMipmapLevels(); ++i) {
            this.boundingIntervalsPerLevel[i] = this.estimateBoundingInterval(0, i);
        }
    }

    public void setIsTransformed(boolean isTransformed) {
        this.isTransformed = isTransformed;
    }

    public void setBoundingBoxEstimator(BoundingBoxEstimation bboxEst) {
        this.bboxEst = bboxEst;
    }

    public boolean isTransformed() {
        return this.isTransformed;
    }

    public Source<T> getWrappedSource() {
        return this.source;
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (this.isTransformed) {
            return Views.interval((RandomAccessible)Views.raster(this.getInterpolatedSource(t, level, Interpolation.NEARESTNEIGHBOR)), (Interval)this.boundingIntervalsPerLevel[level]);
        }
        return this.source.getSource(t, level);
    }

    private Interval estimateBoundingInterval(int t, int level) {
        if (this.xfm == null) {
            return this.source.getSource(t, level);
        }
        this.source.getSourceTransform(t, level, this.tmpSrcTransform);
        InvertibleRealTransform xfmcopy = this.xfm.copy();
        if (this.xfm instanceof WrappedIterativeInvertibleRealTransform) {
            WrappedIterativeInvertibleRealTransform copy = (WrappedIterativeInvertibleRealTransform)xfmcopy;
            copy.getOptimzer().setMaxStep(500.0);
        }
        RealTransformSequence seq = new RealTransformSequence();
        seq.add((RealTransform)this.tmpSrcTransform);
        seq.add((RealTransform)xfmcopy.inverse());
        seq.add((RealTransform)this.tmpSrcTransform.inverse());
        Interval res = this.bboxEst.estimatePixelInterval((RealTransform)seq, (Interval)this.source.getSource(t, level));
        return res;
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        RealRandomAccessible realSrc = this.source.getInterpolatedSource(t, level, method);
        if (this.isTransformed && this.xfm != null) {
            AffineTransform3D transform = new AffineTransform3D();
            this.source.getSourceTransform(t, level, transform);
            RealTransformSequence seq = new RealTransformSequence();
            seq.add((RealTransform)transform);
            seq.add((RealTransform)this.xfm.copy());
            seq.add((RealTransform)transform.inverse());
            if (this.xfm == null) {
                return RealViews.affineReal((RealRandomAccessible)this.source.getInterpolatedSource(t, level, method), (AffineGet)transform);
            }
            return new RealTransformRealRandomAccessible(this.source.getInterpolatedSource(t, level, method), (RealTransform)seq);
        }
        return realSrc;
    }

    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.source.getSourceTransform(t, level, transform);
    }

    public RealTransform getTransform() {
        return this.xfm;
    }

    public T getType() {
        return (T)this.source.getType();
    }

    public String getName() {
        if (this.suffix == null || this.suffix.isEmpty()) {
            return this.source.getName();
        }
        return this.source.getName() + "_" + this.suffix;
    }

    public String getOriginalName() {
        return this.getWrappedSource().getName();
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.source.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.source.getNumMipmapLevels();
    }

    public synchronized MipmapOrdering.MipmapHints getMipmapHints(AffineTransform3D screenTransform, int timepoint, int previousTimepoint) {
        return this.sourceMipmapOrdering.getMipmapHints(screenTransform, timepoint, previousTimepoint);
    }
}

