/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.viewer.animate.AbstractTransformAnimator;
import bigwarp.util.BigWarpUtils;
import bigwarp.util.Rotation2DHelpers;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class SimilarityTransformAnimator2D
extends AbstractTransformAnimator {
    private final double startAngle;
    private final double totalAngle;
    private final double cosInvAngleStart;
    private final double sinInvAngleStart;
    private final double cosInvAngleEnd;
    private final double sinInvAngleEnd;
    private final double scaleStart;
    private final double scaleEnd;
    private final double scaleDiff;
    private final double[] xg0Start;
    private final double[] xg0Diff;

    public SimilarityTransformAnimator2D(AffineTransform3D transformStart, AffineTransform3D transformEnd, double cX, double cY, long duration) {
        super(duration);
        this.startAngle = Rotation2DHelpers.extractRotation(transformStart);
        double endAngle = Rotation2DHelpers.extractRotation(transformEnd);
        this.scaleStart = Rotation2DHelpers.extractScale(transformStart, 0);
        this.scaleEnd = Rotation2DHelpers.extractScale(transformEnd, 0);
        this.scaleDiff = this.scaleEnd - this.scaleStart;
        this.totalAngle = Rotation2DHelpers.shorterAngleBetweenRotations(this.startAngle, endAngle);
        this.cosInvAngleStart = Math.cos(-this.startAngle);
        this.sinInvAngleStart = Math.sin(-this.startAngle);
        this.cosInvAngleEnd = Math.cos(-endAngle);
        this.sinInvAngleEnd = Math.sin(-endAngle);
        double[] tStart = new double[3];
        double[] tEnd = new double[3];
        for (int d = 0; d < 3; ++d) {
            tStart[d] = transformStart.get(d, 3) / this.scaleStart;
            tEnd[d] = transformEnd.get(d, 3) / this.scaleEnd;
        }
        this.xg0Start = new double[3];
        double[] xg0End = new double[3];
        this.xg0Diff = new double[3];
        Rotation2DHelpers.cosSinMult(tStart, this.xg0Start, this.cosInvAngleStart, this.sinInvAngleStart);
        LinAlgHelpers.scale((double[])this.xg0Start, (double)-1.0, (double[])this.xg0Start);
        Rotation2DHelpers.cosSinMult(tEnd, xg0End, this.cosInvAngleEnd, this.sinInvAngleEnd);
        LinAlgHelpers.scale((double[])xg0End, (double)-1.0, (double[])xg0End);
        LinAlgHelpers.subtract((double[])xg0End, (double[])this.xg0Start, (double[])this.xg0Diff);
    }

    public AffineTransform3D get(double t) {
        double scaleCurrent = this.scaleStart + t * this.scaleDiff;
        double angleCurrent = this.startAngle + t * this.totalAngle;
        double[] xg0Current = new double[3];
        double[] tCurrent = new double[3];
        LinAlgHelpers.scale((double[])this.xg0Diff, (double)(-(t * this.scaleEnd / scaleCurrent)), (double[])xg0Current);
        for (int r = 0; r < 3; ++r) {
            int n = r;
            xg0Current[n] = xg0Current[n] - this.xg0Start[r];
        }
        double[][] Rcurrent = Rotation2DHelpers.rotationToMatrix(angleCurrent);
        LinAlgHelpers.mult((double[][])Rcurrent, (double[])xg0Current, (double[])tCurrent);
        double[][] m = new double[3][4];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m[r][c] = scaleCurrent * Rcurrent[r][c];
            }
            m[r][3] = scaleCurrent * tCurrent[r];
        }
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(m);
        return transform;
    }

    public static void main(String[] args) {
        AffineTransform3D transformStart = new AffineTransform3D();
        AffineTransform3D transformEnd = new AffineTransform3D();
        transformStart.scale(2.0);
        transformStart.rotate(2, 0.7853981633974483);
        transformStart.translate(new double[]{-1.0, 5.0, 0.0});
        BigWarpUtils.flipX(transformStart);
        transformEnd.scale(3.0);
        transformEnd.rotate(2, -0.5235987755982988);
        transformEnd.translate(new double[]{10.0, -6.0, 0.0});
        BigWarpUtils.flipX(transformEnd);
        double cX = 683.0;
        double cY = -256.0;
        System.out.println(transformStart);
        System.out.println("   det orig: " + BigWarpUtils.det(transformStart));
        BigWarpUtils.ensurePositiveDeterminant(transformStart);
        System.out.println("   det after correction: " + BigWarpUtils.det(transformStart));
        System.out.println(transformStart);
        System.out.println(" ");
        System.out.println(transformEnd);
        System.out.println("   det orig: " + BigWarpUtils.det(transformEnd));
        BigWarpUtils.ensurePositiveDeterminant(transformEnd);
        System.out.println("   det after correction: " + BigWarpUtils.det(transformEnd));
        System.out.println(transformEnd);
        SimilarityTransformAnimator2D anim = new SimilarityTransformAnimator2D(transformStart, transformEnd, cX, cY, 300L);
        AffineTransform3D compXfm = anim.get(1.0);
        System.out.println(" ");
        System.out.println("compXfm: ");
        System.out.println(compXfm);
        System.out.println("  det: " + BigWarpUtils.det(compXfm));
        System.out.println("done");
        System.exit(0);
    }
}

