/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.util.Affine3DHelpers;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.OverlayRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;

public class BigWarpMaskSphereOverlay
implements OverlayRenderer {
    protected static final BasicStroke stroke = new BasicStroke(1.0f);
    protected final BigWarpViewerPanel viewer;
    protected double[] radii;
    protected final double[] viewerCoords;
    protected double minWidth = 0.1;
    protected final Color[] colors;
    protected final AffineTransform3D viewerTransform;
    protected double[] center;
    protected int width;
    protected int height;
    protected boolean is3d;
    protected boolean visible = false;

    public BigWarpMaskSphereOverlay(BigWarpViewerPanel viewer, boolean is3d) {
        this(viewer, new double[]{0.0, 0.0}, new Color[]{Color.ORANGE, Color.YELLOW}, is3d);
    }

    public BigWarpMaskSphereOverlay(BigWarpViewerPanel viewer, Color[] colors, boolean is3d) {
        this(viewer, new double[]{0.0, 0.0}, colors, is3d);
    }

    public BigWarpMaskSphereOverlay(BigWarpViewerPanel viewer, double[] radii, Color[] colors, boolean is3d) {
        this.viewer = viewer;
        this.radii = radii;
        this.colors = colors;
        this.viewerCoords = new double[3];
        this.center = new double[3];
        this.is3d = is3d;
        this.viewerTransform = new AffineTransform3D();
    }

    public double[] getCenter() {
        return this.center;
    }

    public double[] getRadii() {
        return this.radii;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public void setCenter(RealLocalizable c) {
        c.localize(this.center);
    }

    public void setCenter(RealPoint center) {
        center.localize(this.center);
    }

    public void setRadii(double[] radii) {
        this.radii = radii;
    }

    public void setInnerRadius(double inner) {
        double del = this.radii[1] - this.radii[0];
        this.radii[0] = inner;
        this.radii[1] = inner + del;
    }

    public void setOuterRadiusDelta(double outerDelta) {
        this.radii[1] = this.radii[0] + outerDelta;
    }

    public void setColor(Color color, int i) {
        this.colors[i] = color;
    }

    public void setColors(Color[] colors) {
        System.arraycopy(colors, 0, this.colors, 0, Math.min(colors.length, this.colors.length));
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.viewer.requestRepaint();
    }

    public void toggleVisible() {
        this.setVisible(!this.visible);
    }

    public void drawOverlays(Graphics g) {
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.SrcOver);
            this.viewer.state().getViewerTransform(this.viewerTransform);
            double scale = Affine3DHelpers.extractScale((AffineTransform3D)this.viewerTransform, (int)0);
            this.viewerTransform.apply(this.center, this.viewerCoords);
            double zv = this.is3d ? this.viewerCoords[2] : 0.0;
            double dz2 = zv * zv;
            for (int i = 0; i < this.radii.length; ++i) {
                double rad = this.radii[i];
                double scaledRadius = scale * rad;
                if (!(this.viewerCoords[0] + scaledRadius > 0.0) || !(this.viewerCoords[0] - scaledRadius < (double)this.width) || !(this.viewerCoords[1] + scaledRadius > 0.0) || !(this.viewerCoords[1] - scaledRadius < (double)this.height)) continue;
                double arad = this.is3d ? Math.sqrt(scaledRadius * scaledRadius - dz2) : scaledRadius;
                int rarad = (int)Math.round(arad);
                g2d.setColor(this.colors[i]);
                g2d.setStroke(stroke);
                g2d.drawOval((int)this.viewerCoords[0] - rarad, (int)this.viewerCoords[1] - rarad, 2 * rarad + 1, 2 * rarad + 1);
            }
        }
    }

    public void setCanvasSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

