/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bigwarp.BigWarp;
import bigwarp.BigwarpSettings;
import bigwarp.landmarks.LandmarkTableModel;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class BigWarpAutoSaver {
    private final transient BigWarp<?> bw;
    final transient Timer timer;
    final transient AutoSave saveTask;
    final long period;
    @SerializedName(value="location")
    @JsonAdapter(value=BigwarpSettings.FileAdapter.class)
    protected File autoSaveDirectory;

    public BigWarpAutoSaver(BigWarp<?> bw, long period) {
        this.bw = bw;
        this.period = period;
        this.timer = new Timer();
        this.saveTask = new AutoSave();
        this.timer.schedule((TimerTask)this.saveTask, period, period);
    }

    public long getPeriod() {
        return this.period;
    }

    public void stop() {
        this.saveTask.cancel();
        this.timer.cancel();
    }

    public static void setAutosaveOptions(BigWarp<?> bw, long period, String autoSavePath) {
        if (period > 0L) {
            bw.warpVisDialog.getAutoSaveOptionsPanel().getDoAutoSaveBox().setSelected(true);
            int periodMinutes = (int)(period / 60000L);
            bw.warpVisDialog.getAutoSaveOptionsPanel().getAutoSavePeriodSpinner().setValue(periodMinutes);
            if (bw.autoSaver != null) {
                bw.autoSaver.stop();
            }
            BigWarpAutoSaver autoSaver = new BigWarpAutoSaver(bw, period);
            bw.setAutoSaver(autoSaver);
            autoSaver.setAutosaveFolder(new File(autoSavePath));
        } else {
            bw.warpVisDialog.getAutoSaveOptionsPanel().getDoAutoSaveBox().setSelected(false);
            bw.warpVisDialog.repaint();
        }
    }

    public void setAutosaveFolder(File autoSaveFolder) {
        boolean exists = autoSaveFolder.exists();
        if (!exists) {
            exists = autoSaveFolder.mkdir();
        }
        if (exists && autoSaveFolder.isDirectory()) {
            this.autoSaveDirectory = autoSaveFolder;
            this.bw.warpVisDialog.getAutoSaveOptionsPanel().getAutoSaveFolderText().setText(autoSaveFolder.getAbsolutePath());
            this.bw.warpVisDialog.repaint();
        }
    }

    private class AutoSave
    extends TimerTask {
        private AutoSave() {
        }

        @Override
        public void run() {
            LandmarkTableModel ltm = BigWarpAutoSaver.this.bw.getLandmarkPanel().getTableModel();
            if (ltm.isModifiedSinceSave()) {
                BigWarpAutoSaver.this.bw.autoSaveLandmarks();
            }
        }
    }
}

