/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.tools.bookmarks.Bookmarks;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import bdv.viewer.state.SourceGroup;
import bdv.viewer.state.SourceState;
import bdv.viewer.state.ViewerState;
import bigwarp.BigWarp;
import bigwarp.BigWarpAutoSaver;
import bigwarp.BigWarpInit;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.SourceInfo;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.NgffTransformations;
import bigwarp.transforms.io.TransformWriterJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mpicbg.spim.data.SpimDataException;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.imglib2.N5DisplacementField;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.scijava.listeners.Listeners;

public class BigwarpSettings
extends TypeAdapter<BigwarpSettings> {
    public static Gson gson = new GsonBuilder().registerTypeAdapter(AffineTransform3D.class, (Object)new AffineTransform3dAdapter()).setPrettyPrinting().create();
    private final transient BigWarp<?> bigWarp;
    private final LandmarkTableModel landmarks;
    private final BigWarpTransform transform;
    private final Map<Integer, SourceInfo> sourceInfos;
    BigWarpViewerPanel viewerP;
    BigWarpViewerPanel viewerQ;
    SetupAssignments setupAssignments;
    Bookmarks bookmarks;
    BigWarpAutoSaver autoSaver;
    boolean overwriteSources = false;

    public BigwarpSettings(BigWarp<?> bigWarp, BigWarpViewerPanel viewerP, BigWarpViewerPanel viewerQ, SetupAssignments setupAssignments, Bookmarks bookmarks, BigWarpAutoSaver autoSaver, LandmarkTableModel landmarks, BigWarpTransform transform, Map<Integer, SourceInfo> sourceInfos) {
        this.bigWarp = bigWarp;
        this.viewerP = viewerP;
        this.viewerQ = viewerQ;
        this.setupAssignments = setupAssignments;
        this.bookmarks = bookmarks;
        this.autoSaver = autoSaver;
        this.landmarks = landmarks;
        this.transform = transform;
        this.sourceInfos = sourceInfos;
    }

    public void setOverwriteSources(boolean overwriteSources) {
        this.overwriteSources = overwriteSources;
    }

    public void serialize(String jsonFilename) throws IOException {
        try (FileWriter fileWriter = new FileWriter(jsonFilename);){
            this.write(new JsonWriter((Writer)fileWriter), this);
        }
    }

    public void write(JsonWriter out, BigwarpSettings value) throws IOException {
        out.beginObject();
        out.name("Sources");
        new BigWarpSourcesAdapter(this.bigWarp, this.overwriteSources).write(out, this.sourceInfos);
        out.name("ViewerP");
        new BigWarpViewerPanelAdapter(this.viewerP).write(out, this.viewerP);
        out.name("ViewerQ");
        new BigWarpViewerPanelAdapter(this.viewerQ).write(out, this.viewerQ);
        out.name("SetupAssignments");
        new SetupAssignmentsAdapter(this.setupAssignments).write(out, this.setupAssignments);
        out.name("Bookmarks");
        gson.toJson((Object)this.bookmarks, Bookmarks.class, out);
        out.name("Autosave");
        gson.toJson((Object)this.autoSaver, BigWarpAutoSaver.class, out);
        if (this.landmarks != null) {
            out.name("Transform");
            out.jsonValue(TransformWriterJson.write(this.landmarks, this.transform).toString());
        }
        out.endObject();
    }

    public BigwarpSettings read(JsonReader in) throws IOException {
        JsonObject json = JsonParser.parseReader((JsonReader)in).getAsJsonObject();
        if (json.has("Sources")) {
            boolean is2D;
            new BigWarpSourcesAdapter(this.bigWarp, this.overwriteSources).fromJsonTree(json.get("Sources"));
            boolean bl = is2D = BigWarp.detectNumDims(this.bigWarp.getSources()) == 2;
            if (is2D != this.bigWarp.options.values.is2D()) {
                this.bigWarp.changeDimensionality(is2D);
            }
        }
        if (json.has("Transform")) {
            TransformWriterJson.read(this.bigWarp, json.get("Transform").getAsJsonObject());
        }
        if (json.has("ViewerP")) {
            new BigWarpViewerPanelAdapter(this.viewerP).fromJsonTree(json.get("ViewerP"));
        }
        if (json.has("ViewerQ")) {
            new BigWarpViewerPanelAdapter(this.viewerQ).fromJsonTree(json.get("ViewerQ"));
        }
        if (json.has("SetupAssignments")) {
            new SetupAssignmentsAdapter(this.setupAssignments).fromJsonTree(json.get("SetupAssignments"));
        }
        if (json.has("Bookmarks")) {
            this.bigWarp.setBookmarks((Bookmarks)gson.fromJson(json.get("Bookmarks"), Bookmarks.class));
        }
        if (json.has("Autosave")) {
            this.bigWarp.setAutoSaver((BigWarpAutoSaver)gson.fromJson(json.get("Autosave"), BigWarpAutoSaver.class));
        }
        return this;
    }

    private static interface ConverterSetupDTO
    extends ConverterSetup {
        public int getGroupId();
    }

    public static class AffineTransform3dAdapter
    extends TypeAdapter<AffineTransform3D> {
        public void write(JsonWriter out, AffineTransform3D value) throws IOException {
            assert (value.numDimensions() == 3);
            double[] values = value.getRowPackedCopy();
            out.beginArray();
            for (double v : values) {
                out.value(v);
            }
            out.endArray();
        }

        public AffineTransform3D read(JsonReader in) throws IOException {
            AffineTransform3D affine = new AffineTransform3D();
            double[] values = new double[12];
            in.beginArray();
            for (int i = 0; i < values.length; ++i) {
                values[i] = in.nextDouble();
            }
            in.endArray();
            affine.set(values);
            return affine;
        }
    }

    public static class FileAdapter
    extends TypeAdapter<File> {
        public void write(JsonWriter out, File value) throws IOException {
            out.value(value.getCanonicalPath());
        }

        public File read(JsonReader in) throws IOException {
            return new File(in.nextString());
        }
    }

    public static class ConverterSetupAdapter
    extends TypeAdapter<ConverterSetup> {
        private final SetupAssignments setupAssignments;
        private int setupId = -1;

        public ConverterSetupAdapter(SetupAssignments setupAssignments) {
            this.setupAssignments = setupAssignments;
        }

        public void setSetupId(int setupId) {
            this.setupId = setupId;
        }

        public void write(JsonWriter out, ConverterSetup value) throws IOException {
            List minMaxGroups = this.setupAssignments.getMinMaxGroups();
            out.name("min").value(value.getDisplayRangeMin());
            out.name("max").value(value.getDisplayRangeMax());
            out.name("color").value((long)value.getColor().get());
            out.name("groupId").value((long)minMaxGroups.indexOf(this.setupAssignments.getMinMaxGroup(value)));
        }

        public ConverterSetup read(JsonReader in) throws IOException {
            double tmpmin = 0.0;
            double tmpmax = 0.0;
            int tmpcolor = 0;
            int tmpgroupId = 0;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "min": {
                        tmpmin = in.nextDouble();
                        break;
                    }
                    case "max": {
                        tmpmax = in.nextDouble();
                        break;
                    }
                    case "color": {
                        tmpcolor = in.nextInt();
                        break;
                    }
                    case "groupId": {
                        tmpgroupId = in.nextInt();
                    }
                }
            }
            final double min = tmpmin;
            final double max = tmpmax;
            final int color = tmpcolor;
            final int groupId = tmpgroupId;
            ConverterSetupDTO converterSetupDTO = new ConverterSetupDTO(){
                private final int id;
                {
                    this.id = setupId;
                }

                @Override
                public int getGroupId() {
                    return groupId;
                }

                public Listeners<ConverterSetup.SetupChangeListener> setupChangeListeners() {
                    return null;
                }

                public int getSetupId() {
                    return this.id;
                }

                public void setDisplayRange(double min2, double max2) {
                }

                public void setColor(ARGBType color2) {
                }

                public boolean supportsColor() {
                    return false;
                }

                public double getDisplayRangeMin() {
                    return min;
                }

                public double getDisplayRangeMax() {
                    return max;
                }

                public ARGBType getColor() {
                    return new ARGBType(color);
                }
            };
            return converterSetupDTO;
        }
    }

    public static class MinMaxGroupsAdapter
    extends TypeAdapter<List<MinMaxGroup>> {
        public void write(JsonWriter out, List<MinMaxGroup> value) throws IOException {
            out.beginObject();
            for (int i = 0; i < value.size(); ++i) {
                out.name(Integer.toString(i));
                out.beginObject();
                out.name("fullRangeMin").value(value.get(i).getFullRangeMin());
                out.name("fullRangeMax").value(value.get(i).getFullRangeMax());
                out.name("rangeMin").value(value.get(i).getRangeMin());
                out.name("rangeMax").value(value.get(i).getRangeMax());
                out.name("currentMin").value(value.get(i).getMinBoundedValue().getCurrentValue());
                out.name("currentMax").value(value.get(i).getMaxBoundedValue().getCurrentValue());
                out.endObject();
            }
            out.endObject();
        }

        public List<MinMaxGroup> read(JsonReader in) throws IOException {
            HashMap<Integer, MinMaxGroup> groupMap = new HashMap<Integer, MinMaxGroup>();
            ArrayList<MinMaxGroup> groups = new ArrayList<MinMaxGroup>();
            in.beginObject();
            while (in.hasNext()) {
                int id = Integer.parseInt(in.nextName());
                double fullRangeMin = 0.0;
                double fullRangeMax = 0.0;
                double rangeMin = 0.0;
                double rangeMax = 0.0;
                double currentMin = 0.0;
                double currentMax = 0.0;
                in.beginObject();
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "fullRangeMin": {
                            fullRangeMin = in.nextDouble();
                            break;
                        }
                        case "fullRangeMax": {
                            fullRangeMax = in.nextDouble();
                            break;
                        }
                        case "rangeMin": {
                            rangeMin = in.nextDouble();
                            break;
                        }
                        case "rangeMax": {
                            rangeMax = in.nextDouble();
                            break;
                        }
                        case "currentMin": {
                            currentMin = in.nextDouble();
                            break;
                        }
                        case "currentMax": {
                            currentMax = in.nextDouble();
                        }
                    }
                }
                double minIntervalSize = 0.0;
                MinMaxGroup group = new MinMaxGroup(fullRangeMin, fullRangeMax, rangeMin, rangeMax, currentMin, currentMax, 0.0);
                groupMap.put(id, group);
                in.endObject();
            }
            in.endObject();
            for (int i = 0; i < groupMap.size(); ++i) {
                groups.add((MinMaxGroup)groupMap.get(i));
            }
            return groups;
        }
    }

    public static class SetupAssignmentsAdapter
    extends TypeAdapter<SetupAssignments> {
        private final SetupAssignments setupAssignments;

        public SetupAssignmentsAdapter(SetupAssignments setupAssignments) {
            this.setupAssignments = setupAssignments;
        }

        public void write(JsonWriter out, SetupAssignments value) throws IOException {
            out.beginObject();
            out.name("ConverterSetups");
            out.beginObject();
            List converterSetups = value.getConverterSetups();
            ConverterSetupAdapter converterSetupAdapter = new ConverterSetupAdapter(value);
            for (ConverterSetup converterSetup : converterSetups) {
                out.name(Integer.toString(converterSetup.getSetupId()));
                out.beginObject();
                converterSetupAdapter.setSetupId(converterSetup.getSetupId());
                converterSetupAdapter.write(out, converterSetup);
                out.endObject();
            }
            out.endObject();
            List minMaxGroups = value.getMinMaxGroups();
            out.name("MinMaxGroups");
            new MinMaxGroupsAdapter().write(out, minMaxGroups);
            out.endObject();
        }

        public SetupAssignments read(JsonReader in) throws IOException {
            ArrayList minMaxGroups;
            ArrayList<ConverterSetupDTO> converters = new ArrayList<ConverterSetupDTO>();
            try {
                Field minMaxGroupsField = this.setupAssignments.getClass().getDeclaredField("minMaxGroups");
                minMaxGroupsField.setAccessible(true);
                minMaxGroups = (ArrayList)minMaxGroupsField.get(this.setupAssignments);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            minMaxGroups.clear();
            in.beginObject();
            block10: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "ConverterSetups": {
                        ConverterSetupAdapter converterSetupAdapter = new ConverterSetupAdapter(this.setupAssignments);
                        in.beginObject();
                        while (in.hasNext()) {
                            int id = Integer.parseInt(in.nextName());
                            converterSetupAdapter.setSetupId(id);
                            in.beginObject();
                            ConverterSetupDTO dto = (ConverterSetupDTO)converterSetupAdapter.read(in);
                            converters.add(dto);
                            in.endObject();
                        }
                        in.endObject();
                        List converterSetups = this.setupAssignments.getConverterSetups();
                        List originalSetupIdOrder = converterSetups.stream().map(ConverterSetup::getSetupId).collect(Collectors.toList());
                        for (int idx = 0; idx < converters.size(); ++idx) {
                            ConverterSetupDTO converterSetupDTO = (ConverterSetupDTO)converters.get(idx);
                            int setupId = converterSetupDTO.getSetupId();
                            int idxOfConverterSetup = originalSetupIdOrder.indexOf(setupId);
                            if (idxOfConverterSetup < 0 || idx == idxOfConverterSetup) continue;
                            converters.remove(idx);
                            converters.add(idxOfConverterSetup, converterSetupDTO);
                        }
                        continue block10;
                    }
                    case "MinMaxGroups": {
                        minMaxGroups.addAll(new MinMaxGroupsAdapter().read(in));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown SetupAssignment Key: " + name);
                    }
                }
            }
            in.endObject();
            for (ConverterSetupDTO setupDto : converters) {
                ConverterSetup setup = this.setupAssignments.getConverterSetups().stream().filter(it -> it.getSetupId() == setupDto.getSetupId()).findFirst().get();
                setup.setDisplayRange(setupDto.getDisplayRangeMin(), setupDto.getDisplayRangeMax());
                setup.setColor(setupDto.getColor());
                MinMaxGroup group = (MinMaxGroup)minMaxGroups.get(setupDto.getGroupId());
                this.setupAssignments.moveSetupToGroup(setup, group);
            }
            return this.setupAssignments;
        }
    }

    public static class BigWarpViewerPanelAdapter
    extends TypeAdapter<BigWarpViewerPanel> {
        private final BigWarpViewerPanel panel;
        private final ViewerState state;

        public BigWarpViewerPanelAdapter(BigWarpViewerPanel viewerP) {
            this.panel = viewerP;
            try {
                Field deprecatedState = ViewerPanel.class.getDeclaredField("deprecatedState");
                deprecatedState.setAccessible(true);
                this.state = (ViewerState)deprecatedState.get((Object)this.panel);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        public void write(JsonWriter out, BigWarpViewerPanel value) throws IOException {
            out.beginObject();
            out.name("Sources");
            this.writeSources(out, value);
            out.name("SourceGroups");
            this.writeGroups(out, value);
            out.name("DisplayMode");
            this.writeDisplayMode(out, value);
            out.name("Interpolation");
            this.writeInterpolationMode(out, value);
            out.name("CurrentSource").value((long)value.getState().getCurrentSource());
            out.name("CurrentGroup").value((long)value.getState().getCurrentGroup());
            out.name("CurrentTimePoint").value((long)value.getState().getCurrentTimepoint());
            out.endObject();
        }

        private void writeInterpolationMode(JsonWriter out, BigWarpViewerPanel value) throws IOException {
            Interpolation interpolation = value.getState().getInterpolation();
            switch (interpolation) {
                case NLINEAR: {
                    out.value("nlinear");
                    break;
                }
                default: {
                    out.value("nearestneighbor");
                }
            }
        }

        private void readInterpolationMode(JsonReader in) throws IOException {
            switch (in.nextString()) {
                case "nlinear": {
                    this.state.setInterpolation(Interpolation.NLINEAR);
                    break;
                }
                default: {
                    this.state.setInterpolation(Interpolation.NEARESTNEIGHBOR);
                }
            }
        }

        private void writeDisplayMode(JsonWriter out, ViewerPanel value) throws IOException {
            switch (value.getState().getDisplayMode()) {
                case GROUP: {
                    out.value("sg");
                    break;
                }
                case FUSED: {
                    out.value("fs");
                    break;
                }
                case FUSEDGROUP: {
                    out.value("fg");
                    break;
                }
                default: {
                    out.value("ss");
                }
            }
        }

        private void readDisplayMode(JsonReader in) throws IOException {
            switch (in.nextString()) {
                case "sg": {
                    this.state.setDisplayMode(DisplayMode.GROUP);
                    break;
                }
                case "fs": {
                    this.state.setDisplayMode(DisplayMode.FUSED);
                    break;
                }
                case "fg": {
                    this.state.setDisplayMode(DisplayMode.FUSEDGROUP);
                    break;
                }
                default: {
                    this.state.setDisplayMode(DisplayMode.SINGLE);
                }
            }
        }

        private void writeGroups(JsonWriter out, ViewerPanel value) throws IOException {
            out.beginArray();
            List sourceGroups = value.getState().getSourceGroups();
            for (SourceGroup sourceGroup : sourceGroups) {
                out.beginObject();
                out.name("active").value(sourceGroup.isActive());
                out.name("name").value(sourceGroup.getName());
                out.name("id");
                out.beginArray();
                for (Integer sourceId : sourceGroup.getSourceIds()) {
                    out.value((Number)sourceId);
                }
                out.endArray();
                out.endObject();
            }
            out.endArray();
        }

        private void readGroups(JsonReader in) throws IOException {
            in.beginArray();
            SynchronizedViewerState state = this.panel.state();
            state.setGroupsActive((Collection)state.getActiveGroups(), false);
            state.removeGroups((Collection)state.getGroups());
            while (in.hasNext()) {
                in.beginObject();
                bdv.viewer.SourceGroup group = new bdv.viewer.SourceGroup();
                state.addGroup(group);
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "active": {
                            boolean active = in.nextBoolean();
                            state.setGroupActive(group, active);
                            break;
                        }
                        case "name": {
                            String name = in.nextString();
                            state.setGroupName(group, name);
                            break;
                        }
                        case "id": {
                            state.removeSourcesFromGroup(new ArrayList(state.getSourcesInGroup(group)), group);
                            in.beginArray();
                            while (in.hasNext()) {
                                state.addSourceToGroup((SourceAndConverter)state.getSources().get(in.nextInt()), group);
                            }
                            in.endArray();
                        }
                    }
                }
                in.endObject();
            }
            in.endArray();
        }

        private void writeSources(JsonWriter out, ViewerPanel value) throws IOException {
            out.beginArray();
            List sources = value.getState().getSources();
            for (SourceState source : sources) {
                out.value(source.isActive());
            }
            out.endArray();
        }

        private void readSources(JsonReader in) throws IOException {
            List sources = this.state.getSources();
            in.beginArray();
            int i = 0;
            while (in.hasNext()) {
                boolean isActive = in.nextBoolean();
                SourceState source = (SourceState)sources.get(i++);
                source.setActive(isActive);
            }
            in.endArray();
        }

        public BigWarpViewerPanel read(JsonReader in) throws IOException {
            in.beginObject();
            while (in.hasNext()) {
                String nextName;
                switch (nextName = in.nextName()) {
                    case "Sources": {
                        this.readSources(in);
                        break;
                    }
                    case "SourceGroups": {
                        this.readGroups(in);
                        break;
                    }
                    case "DisplayMode": {
                        this.readDisplayMode(in);
                        break;
                    }
                    case "Interpolation": {
                        this.readInterpolationMode(in);
                        break;
                    }
                    case "CurrentSource": {
                        this.state.setCurrentSource(in.nextInt());
                        break;
                    }
                    case "CurrentGroup": {
                        this.state.setCurrentGroup(in.nextInt());
                        break;
                    }
                    case "CurrentTimePoint": {
                        this.state.setCurrentTimepoint(in.nextInt());
                    }
                }
            }
            in.endObject();
            return this.panel;
        }
    }

    public static class BigWarpSourcesAdapter<T extends NativeType<T>>
    extends TypeAdapter<Map<Integer, SourceInfo>> {
        private BigWarp<T> bigwarp;
        private boolean overwriteExisting;

        public BigWarpSourcesAdapter(BigWarp<T> bigwarp, boolean overwriteSources) {
            this.bigwarp = bigwarp;
            this.overwriteExisting = overwriteSources;
        }

        public void write(JsonWriter out, Map<Integer, SourceInfo> value) throws IOException {
            out.beginObject();
            for (Map.Entry<Integer, SourceInfo> entry : value.entrySet()) {
                if (!entry.getValue().isSerializable()) continue;
                SourceInfo sourceInfo = entry.getValue();
                int id = sourceInfo.getId();
                String uri = sourceInfo.getUri();
                String name = sourceInfo.getName();
                out.name("" + id);
                out.beginObject();
                if (uri == null && name != null && !name.trim().isEmpty()) {
                    uri = "imagej:///" + name;
                }
                if (uri != null) {
                    out.name("uri").value(uri);
                }
                if (sourceInfo.getName() != null) {
                    out.name("name").value(sourceInfo.getName());
                }
                out.name("isMoving").value(sourceInfo.isMoving());
                String transformUri = sourceInfo.getTransformUri();
                if (transformUri != null) {
                    out.name("transform").value(transformUri);
                }
                out.endObject();
            }
            out.endObject();
        }

        public Map<Integer, SourceInfo> read(JsonReader in) throws IOException {
            in.beginObject();
            while (in.hasNext()) {
                int id = Integer.parseInt(in.nextName());
                in.beginObject();
                String uri = null;
                String transformUri = null;
                String name = null;
                Boolean isMoving = null;
                while (in.hasNext()) {
                    String key;
                    switch (key = in.nextName()) {
                        case "uri": {
                            uri = in.nextString();
                            break;
                        }
                        case "name": {
                            name = in.nextString();
                            break;
                        }
                        case "isMoving": {
                            isMoving = in.nextBoolean();
                            break;
                        }
                        case "transform": {
                            transformUri = in.nextString();
                        }
                    }
                }
                SourceInfo existingInfo = this.bigwarp.data.sourceInfos.get(id);
                int targetIdx = -1;
                if (existingInfo != null && this.overwriteExisting) {
                    targetIdx = this.bigwarp.data.remove(existingInfo);
                    existingInfo = null;
                }
                if (existingInfo == null && uri != null) {
                    LinkedHashMap sources;
                    try {
                        sources = BigWarpInit.createSources(this.bigwarp.data, uri, id, (boolean)isMoving);
                    }
                    catch (URISyntaxException | SpimDataException e) {
                        throw new RuntimeException(e);
                    }
                    RealTransform transform = null;
                    String tformUri = transformUri;
                    if (transformUri != null) {
                        String trimUrl = transformUri.trim();
                        try {
                            N5URI n5Uri = new N5URI(trimUrl);
                            URI tformUriClean = n5Uri.getURI();
                            if (tformUriClean.getFragment() == null) {
                                String groupPath = tformUriClean.getQuery() == null ? "dfield" : n5Uri.getGroupPath();
                                boolean isInverse = groupPath.endsWith("invdfield");
                                transform = N5DisplacementField.open((N5Reader)new N5Factory().openReader(n5Uri.getContainerPath()), (String)groupPath, (boolean)isInverse);
                            }
                        }
                        catch (URISyntaxException n5Uri) {
                            // empty catch block
                        }
                        if (transform == null) {
                            transform = NgffTransformations.open(trimUrl);
                        }
                    }
                    BigWarpInit.add(this.bigwarp.data, sources, transform, () -> tformUri);
                    if (targetIdx >= 0) {
                        SourceAndConverter sacToMove = this.bigwarp.data.sources.remove(this.bigwarp.data.sources.size() - 1);
                        this.bigwarp.data.sources.add(targetIdx, sacToMove);
                        ConverterSetup setupToMove = this.bigwarp.data.converterSetups.remove(this.bigwarp.data.converterSetups.size() - 1);
                        this.bigwarp.data.converterSetups.add(targetIdx, setupToMove);
                    }
                }
                in.endObject();
            }
            in.endObject();
            this.bigwarp.data.applyTransformations();
            this.bigwarp.initialize();
            return this.bigwarp.data.sourceInfos;
        }
    }
}

